/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.primitives.Ints;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.LongSupplierSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class EntireLayoutLongSupplierSerializer
implements LongSupplierSerializer {
    private final IOPeon ioPeon;
    private final String valueFile;
    private final String metaFile;
    private CountingOutputStream valuesOut;
    private final CompressionFactory.LongEncodingWriter writer;
    private long metaCount = 0L;
    private int numInserted = 0;

    public EntireLayoutLongSupplierSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressionFactory.LongEncodingWriter writer) {
        this.ioPeon = ioPeon;
        this.valueFile = filenameBase + ".value";
        this.metaFile = filenameBase + ".format";
        this.writer = writer;
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.valueFile));
        this.writer.setOutputStream((OutputStream)this.valuesOut);
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        this.writer.write(value);
        ++this.numInserted;
    }

    @Override
    public void closeAndConsolidate(ByteSink consolidatedOut) throws IOException {
        this.close();
        try (OutputStream out = consolidatedOut.openStream();
             InputStream meta = this.ioPeon.makeInputStream(this.metaFile);
             InputStream value = this.ioPeon.makeInputStream(this.valueFile);){
            ByteStreams.copy((InputStream)meta, (OutputStream)out);
            ByteStreams.copy((InputStream)value, (OutputStream)out);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.valuesOut.close();
        try (CountingOutputStream metaOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.metaFile));){
            metaOut.write(2);
            metaOut.write(Ints.toByteArray((int)this.numInserted));
            metaOut.write(Ints.toByteArray((int)0));
            this.writer.putMeta((OutputStream)metaOut, CompressedObjectStrategy.CompressionStrategy.NONE);
            metaOut.close();
            this.metaCount = metaOut.getCount();
        }
    }

    @Override
    public long getSerializedSize() {
        return this.metaCount + this.valuesOut.getCount();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        try (InputStream meta = this.ioPeon.makeInputStream(this.metaFile);
             InputStream value = this.ioPeon.makeInputStream(this.valueFile);){
            ByteStreams.copy((ReadableByteChannel)Channels.newChannel(meta), (WritableByteChannel)channel);
            ByteStreams.copy((ReadableByteChannel)Channels.newChannel(value), (WritableByteChannel)channel);
        }
    }
}

