/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.IndexIO;
import io.druid.segment.data.CompressedIntBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.SingleValueIndexedIntsWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class CompressedIntsIndexedWriter
extends SingleValueIndexedIntsWriter {
    private static final byte VERSION = 2;
    private final int chunkFactor;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final GenericIndexedWriter<ResourceHolder<IntBuffer>> flattener;
    private IntBuffer endBuffer;
    private int numInserted;

    public static CompressedIntsIndexedWriter create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression) {
        return new CompressedIntsIndexedWriter(ioPeon, filenameBase, 16384, IndexIO.BYTE_ORDER, compression);
    }

    public CompressedIntsIndexedWriter(IOPeon ioPeon, String filenameBase, int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        this.chunkFactor = chunkFactor;
        this.compression = compression;
        this.flattener = new GenericIndexedWriter<ResourceHolder<IntBuffer>>(ioPeon, filenameBase, CompressedIntBufferObjectStrategy.getBufferForOrder(byteOrder, compression, chunkFactor));
        this.endBuffer = IntBuffer.allocate(chunkFactor);
        this.numInserted = 0;
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    protected void addValue(int val) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<IntBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            this.endBuffer = IntBuffer.allocate(this.chunkFactor);
        }
        this.endBuffer.put(val);
        ++this.numInserted;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.numInserted > 0) {
                this.endBuffer.limit(this.endBuffer.position());
                this.endBuffer.rewind();
                this.flattener.write((ResourceHolder<IntBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            }
            this.endBuffer = null;
        }
        finally {
            this.flattener.close();
        }
    }

    @Override
    public long getSerializedSize() {
        return 10L + this.flattener.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.numInserted)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.chunkFactor)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        ReadableByteChannel from = Channels.newChannel((InputStream)this.flattener.combineStreams().getInput());
        ByteStreams.copy((ReadableByteChannel)from, (WritableByteChannel)channel);
    }
}

