/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.LongSupplierSerializer;
import io.druid.segment.data.VSizeCompressedObjectStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class BlockLayoutLongSupplierSerializer
implements LongSupplierSerializer {
    private final IOPeon ioPeon;
    private final int sizePer;
    private final CompressionFactory.LongEncodingWriter writer;
    private final GenericIndexedWriter<ResourceHolder<ByteBuffer>> flattener;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final String metaFile;
    private long metaCount = 0L;
    private int numInserted = 0;
    private ByteBuffer endBuffer = null;

    public BlockLayoutLongSupplierSerializer(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressionFactory.LongEncodingWriter writer, CompressedObjectStrategy.CompressionStrategy compression) {
        this.ioPeon = ioPeon;
        this.sizePer = writer.getBlockSize(65536);
        this.flattener = new GenericIndexedWriter<ResourceHolder<ByteBuffer>>(ioPeon, filenameBase, VSizeCompressedObjectStrategy.getBufferForOrder(order, compression, writer.getNumBytes(this.sizePer)));
        this.metaFile = filenameBase + ".format";
        this.writer = writer;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    @Override
    public void add(long value) throws IOException {
        if (this.numInserted % this.sizePer == 0) {
            if (this.endBuffer != null) {
                this.writer.flush();
                this.endBuffer.limit(this.endBuffer.position());
                this.endBuffer.rewind();
                this.flattener.write((ResourceHolder<ByteBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            }
            this.endBuffer = ByteBuffer.allocate(this.writer.getNumBytes(this.sizePer));
            this.writer.setBuffer(this.endBuffer);
        }
        this.writer.write(value);
        ++this.numInserted;
    }

    @Override
    public void closeAndConsolidate(ByteSink consolidatedOut) throws IOException {
        this.close();
        try (OutputStream out = consolidatedOut.openStream();
             InputStream meta = this.ioPeon.makeInputStream(this.metaFile);){
            ByteStreams.copy((InputStream)meta, (OutputStream)out);
            ByteStreams.copy(this.flattener.combineStreams(), (OutputStream)out);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.endBuffer != null) {
            this.writer.flush();
            this.endBuffer.limit(this.endBuffer.position());
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<ByteBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
        }
        this.endBuffer = null;
        this.flattener.close();
        try (CountingOutputStream metaOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.metaFile));){
            metaOut.write(2);
            metaOut.write(Ints.toByteArray((int)this.numInserted));
            metaOut.write(Ints.toByteArray((int)this.sizePer));
            this.writer.putMeta((OutputStream)metaOut, this.compression);
            metaOut.close();
            this.metaCount = metaOut.getCount();
        }
    }

    @Override
    public long getSerializedSize() {
        return this.metaCount + this.flattener.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        try (InputStream meta = this.ioPeon.makeInputStream(this.metaFile);
             InputStream input = (InputStream)this.flattener.combineStreams().getInput();){
            ByteStreams.copy((ReadableByteChannel)Channels.newChannel(meta), (WritableByteChannel)channel);
            ReadableByteChannel from = Channels.newChannel(input);
            ByteStreams.copy((ReadableByteChannel)from, (WritableByteChannel)channel);
        }
    }
}

