/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import com.metamx.common.logger.Logger;
import io.druid.segment.DimensionHandler;
import io.druid.segment.DimensionIndexer;
import io.druid.segment.DimensionMergerLegacy;
import io.druid.segment.DimensionMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.SegmentValidationException;
import io.druid.segment.StringDimensionIndexer;
import io.druid.segment.StringDimensionMergerLegacy;
import io.druid.segment.StringDimensionMergerV9;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public class StringDimensionHandler
implements DimensionHandler<Integer, int[], String> {
    private static final Logger log = new Logger(StringDimensionHandler.class);
    private final String dimensionName;
    public static final Function<Object, String> STRING_TRANSFORMER = new Function<Object, String>(){

        public String apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                return (String)o;
            }
            return o.toString();
        }
    };
    public static final Comparator<Integer> ENCODED_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    public static final Comparator<String> UNENCODED_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    public StringDimensionHandler(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public int getLengthFromEncodedArray(int[] dimVals) {
        return dimVals.length;
    }

    @Override
    public int compareSortedEncodedArrays(int[] lhs, int[] rhs) {
        int lhsLen = lhs.length;
        int rhsLen = rhs.length;
        int retVal = Ints.compare((int)lhsLen, (int)rhsLen);
        for (int valsIndex = 0; retVal == 0 && valsIndex < lhsLen; ++valsIndex) {
            retVal = Ints.compare((int)lhs[valsIndex], (int)rhs[valsIndex]);
        }
        return retVal;
    }

    @Override
    public void validateSortedEncodedArrays(int[] lhs, int[] rhs, Indexed<String> lhsEncodings, Indexed<String> rhsEncodings) throws SegmentValidationException {
        int rhsLen;
        if (lhs == null || rhs == null) {
            if (lhs != rhs) {
                throw new SegmentValidationException("Expected nulls, found %s and %s", Arrays.toString(lhs), Arrays.toString(rhs));
            }
            return;
        }
        int lhsLen = Array.getLength(lhs);
        if (lhsLen != (rhsLen = Array.getLength(rhs))) {
            if (lhsLen == 0 && rhsLen == 1) {
                String dimValName = rhsEncodings.get(rhs[0]);
                if (dimValName == null) {
                    return;
                }
                throw new SegmentValidationException("Dim [%s] value [%s] is not null", this.dimensionName, dimValName);
            }
            if (rhsLen == 0 && lhsLen == 1) {
                String dimValName = lhsEncodings.get(lhs[0]);
                if (dimValName == null) {
                    return;
                }
                throw new SegmentValidationException("Dim [%s] value [%s] is not null", this.dimensionName, dimValName);
            }
            throw new SegmentValidationException("Dim [%s] value lengths not equal. Expected %d found %d", this.dimensionName, lhsLen, rhsLen);
        }
        for (int j = 0; j < Math.max(lhsLen, rhsLen); ++j) {
            String dim2ValName;
            int dIdex1 = lhsLen <= j ? -1 : lhs[j];
            int dIdex2 = rhsLen <= j ? -1 : rhs[j];
            String dim1ValName = dIdex1 < 0 ? null : lhsEncodings.get(dIdex1);
            String string = dim2ValName = dIdex2 < 0 ? null : rhsEncodings.get(dIdex2);
            if (dim1ValName == null || dim2ValName == null) {
                if (dim1ValName == null && dim2ValName == null) continue;
                throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, dim1ValName, dim2ValName);
            }
            if (dim1ValName.equals(dim2ValName)) continue;
            throw new SegmentValidationException("Dim [%s] value not equal. Expected [%s] found [%s]", this.dimensionName, dim1ValName, dim2ValName);
        }
    }

    @Override
    public Closeable getSubColumn(Column column) {
        return column.getDictionaryEncoding();
    }

    @Override
    public Object getRowValueArrayFromColumn(Closeable column, int currRow) {
        int[] theVals;
        DictionaryEncodedColumn dict = (DictionaryEncodedColumn)column;
        if (dict.hasMultipleValues()) {
            IndexedInts dimVals = dict.getMultiValueRow(currRow);
            theVals = new int[dimVals.size()];
            for (int i = 0; i < theVals.length; ++i) {
                theVals[i] = dimVals.get(i);
            }
        } else {
            theVals = new int[]{dict.getSingleValueRow(currRow)};
        }
        return theVals;
    }

    @Override
    public DimensionIndexer<Integer, int[], String> makeIndexer() {
        return new StringDimensionIndexer();
    }

    @Override
    public DimensionMergerV9 makeMerger(IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        return new StringDimensionMergerV9(this.dimensionName, indexSpec, outDir, ioPeon, capabilities, progress);
    }

    @Override
    public DimensionMergerLegacy makeLegacyMerger(IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        return new StringDimensionMergerLegacy(this.dimensionName, indexSpec, outDir, ioPeon, capabilities, progress);
    }
}

