/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import io.druid.common.utils.SerializerUtils;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.FloatSupplierSerializer;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedFloats;
import io.druid.segment.data.IndexedLongs;
import io.druid.segment.data.LongSupplierSerializer;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class MetricHolder {
    private static final byte[] version = new byte[]{0};
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private final String name;
    private final String typeName;
    private final MetricType type;
    CompressedLongsIndexedSupplier longType = null;
    CompressedFloatsIndexedSupplier floatType = null;
    Indexed complexType = null;

    public static MetricHolder floatMetric(String name, CompressedFloatsIndexedSupplier column) {
        MetricHolder retVal = new MetricHolder(name, "float");
        retVal.floatType = column;
        return retVal;
    }

    public static MetricHolder complexMetric(String name, String typeName, Indexed column) {
        MetricHolder retVal = new MetricHolder(name, typeName);
        retVal.complexType = column;
        return retVal;
    }

    public static void writeComplexMetric(OutputSupplier<? extends OutputStream> outSupplier, String name, String typeName, GenericIndexedWriter column) throws IOException {
        try (OutputStream out = (OutputStream)outSupplier.getOutput();){
            out.write(version);
            serializerUtils.writeString(out, name);
            serializerUtils.writeString(out, typeName);
            InputSupplier<InputStream> supplier = column.combineStreams();
            try (InputStream in = (InputStream)supplier.getInput();){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    public static void writeFloatMetric(ByteSink outSupplier, String name, FloatSupplierSerializer column) throws IOException {
        outSupplier.write(version);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), name);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), "float");
        column.closeAndConsolidate(outSupplier);
    }

    public static void writeLongMetric(ByteSink outSupplier, String name, LongSupplierSerializer column) throws IOException {
        outSupplier.write(version);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), name);
        serializerUtils.writeString(MetricHolder.toOutputSupplier(outSupplier), "long");
        column.closeAndConsolidate(outSupplier);
    }

    public static void writeToChannel(MetricHolder holder, WritableByteChannel out) throws IOException {
        out.write(ByteBuffer.wrap(version));
        serializerUtils.writeString(out, holder.name);
        serializerUtils.writeString(out, holder.typeName);
        switch (holder.type) {
            case FLOAT: {
                holder.floatType.writeToChannel(out);
                break;
            }
            case COMPLEX: {
                if (holder.complexType instanceof GenericIndexed) {
                    ((GenericIndexed)holder.complexType).writeToChannel(out);
                    break;
                }
                throw new IAE("Cannot serialize out MetricHolder for complex type that is not a GenericIndexed", new Object[0]);
            }
        }
    }

    public static MetricHolder fromByteBuffer(ByteBuffer buf) throws IOException {
        return MetricHolder.fromByteBuffer(buf, null);
    }

    public static MetricHolder fromByteBuffer(ByteBuffer buf, ObjectStrategy strategy) throws IOException {
        byte ver = buf.get();
        if (version[0] != ver) {
            throw new ISE("Unknown version[%s] of MetricHolder", new Object[]{ver});
        }
        String metricName = serializerUtils.readString(buf);
        String typeName = serializerUtils.readString(buf);
        MetricHolder holder = new MetricHolder(metricName, typeName);
        switch (holder.type) {
            case LONG: {
                holder.longType = CompressedLongsIndexedSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder());
                break;
            }
            case FLOAT: {
                holder.floatType = CompressedFloatsIndexedSupplier.fromByteBuffer(buf, ByteOrder.nativeOrder());
                break;
            }
            case COMPLEX: {
                if (strategy != null) {
                    holder.complexType = GenericIndexed.read(buf, strategy);
                    break;
                }
                ComplexMetricSerde serdeForType = ComplexMetrics.getSerdeForType(holder.getTypeName());
                if (serdeForType == null) {
                    throw new ISE("Unknown type[%s], cannot load.", new Object[]{holder.getTypeName()});
                }
                holder.complexType = GenericIndexed.read(buf, serdeForType.getObjectStrategy());
            }
        }
        return holder;
    }

    private static OutputSupplier<? extends OutputStream> toOutputSupplier(final ByteSink sink) {
        return new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return sink.openStream();
            }
        };
    }

    private MetricHolder(String name, String typeName) {
        this.name = name;
        this.typeName = typeName;
        this.type = MetricType.determineType(typeName);
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public MetricType getType() {
        return this.type;
    }

    public IndexedLongs getLongType() {
        this.assertType(MetricType.LONG);
        return this.longType.get();
    }

    public IndexedFloats getFloatType() {
        this.assertType(MetricType.FLOAT);
        return this.floatType.get();
    }

    public Indexed getComplexType() {
        this.assertType(MetricType.COMPLEX);
        return this.complexType;
    }

    private void assertType(MetricType type) {
        if (this.type != type) {
            throw new IAE("type[%s] cannot be cast to [%s]", new Object[]{this.typeName, type});
        }
    }

    public static enum MetricType {
        LONG,
        FLOAT,
        COMPLEX;


        static MetricType determineType(String typeName) {
            if ("long".equalsIgnoreCase(typeName)) {
                return LONG;
            }
            if ("float".equalsIgnoreCase(typeName)) {
                return FLOAT;
            }
            return COMPLEX;
        }
    }
}

