/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.metamx.common.ISE;
import com.metamx.common.Pair;
import io.druid.collections.StupidPool;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorUtil;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.DimValHolder;
import io.druid.query.topn.PooledTopNAlgorithm;
import io.druid.query.topn.TopNAlgorithm;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AggregateTopNMetricFirstAlgorithm
implements TopNAlgorithm<int[], TopNParams> {
    private final Capabilities capabilities;
    private final TopNQuery query;
    private final StupidPool<ByteBuffer> bufferPool;

    public AggregateTopNMetricFirstAlgorithm(Capabilities capabilities, TopNQuery query, StupidPool<ByteBuffer> bufferPool) {
        this.capabilities = capabilities;
        this.query = query;
        this.bufferPool = bufferPool;
    }

    @Override
    public TopNParams makeInitParams(DimensionSelector dimSelector, Cursor cursor) {
        return new TopNParams(dimSelector, cursor, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TopNParams params, TopNResultBuilder resultBuilder, int[] ints) {
        String metric = this.query.getTopNMetricSpec().getMetricName(this.query.getDimensionSpec());
        Pair<List<AggregatorFactory>, List<PostAggregator>> condensedAggPostAggPair = AggregatorUtil.condensedAggregators(this.query.getAggregatorSpecs(), this.query.getPostAggregatorSpecs(), metric);
        if (((List)condensedAggPostAggPair.lhs).isEmpty() && ((List)condensedAggPostAggPair.rhs).isEmpty()) {
            throw new ISE("WTF! Can't find the metric to do topN over?", new Object[0]);
        }
        TopNQuery singleMetricQuery = new TopNQueryBuilder().copy(this.query).aggregators((List)condensedAggPostAggPair.lhs).postAggregators((List)condensedAggPostAggPair.rhs).build();
        TopNResultBuilder singleMetricResultBuilder = BaseTopNAlgorithm.makeResultBuilder(params, singleMetricQuery);
        PooledTopNAlgorithm singleMetricAlgo = new PooledTopNAlgorithm(this.capabilities, singleMetricQuery, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams singleMetricParam = null;
        int[] dimValSelector = null;
        try {
            singleMetricParam = singleMetricAlgo.makeInitParams(params.getDimSelector(), params.getCursor());
            singleMetricAlgo.run(singleMetricParam, singleMetricResultBuilder, null);
            dimValSelector = this.getDimValSelectorForTopNMetric(singleMetricParam, singleMetricResultBuilder);
            singleMetricAlgo.cleanup(singleMetricParam);
        }
        catch (Throwable throwable) {
            singleMetricAlgo.cleanup(singleMetricParam);
            throw throwable;
        }
        PooledTopNAlgorithm allMetricAlgo = new PooledTopNAlgorithm(this.capabilities, this.query, this.bufferPool);
        PooledTopNAlgorithm.PooledTopNParams allMetricsParam = null;
        try {
            allMetricsParam = allMetricAlgo.makeInitParams(params.getDimSelector(), params.getCursor());
            allMetricAlgo.run(allMetricsParam, resultBuilder, dimValSelector);
            allMetricAlgo.cleanup(allMetricsParam);
        }
        catch (Throwable throwable) {
            allMetricAlgo.cleanup(allMetricsParam);
            throw throwable;
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }

    private int[] getDimValSelectorForTopNMetric(TopNParams params, TopNResultBuilder resultBuilder) {
        int[] dimValSelector = new int[params.getCardinality()];
        Arrays.fill(dimValSelector, -2);
        Iterator<DimValHolder> dimValIter = resultBuilder.getTopNIterator();
        while (dimValIter.hasNext()) {
            int dimValIndex = (Integer)dimValIter.next().getDimValIndex();
            dimValSelector[dimValIndex] = -1;
        }
        return dimValSelector;
    }
}

