/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.common.utils.JodaUtils;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Collections;
import java.util.List;
import org.joda.time.Interval;

public class MultipleIntervalSegmentSpec
implements QuerySegmentSpec {
    private final List<Interval> intervals;

    @JsonCreator
    public MultipleIntervalSegmentSpec(@JsonProperty(value="intervals") List<Interval> intervals) {
        this.intervals = Collections.unmodifiableList(JodaUtils.condenseIntervals(intervals));
    }

    @Override
    @JsonProperty(value="intervals")
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @Override
    public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
        return walker.getQueryRunnerForIntervals(query, this.intervals);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{intervals=" + this.intervals + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleIntervalSegmentSpec that = (MultipleIntervalSegmentSpec)o;
        return !(this.intervals != null ? !this.intervals.equals(that.intervals) : that.intervals != null);
    }

    public int hashCode() {
        return this.intervals != null ? this.intervals.hashCode() : 0;
    }
}

