/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.LongSumAggregator;
import io.druid.query.aggregation.LongSumBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class LongSumAggregatorFactory
extends AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 1;
    private final String fieldName;
    private final String name;

    @JsonCreator
    public LongSumAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new LongSumAggregator(this.name, metricFactory.makeLongColumnSelector(this.fieldName));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new LongSumBufferAggregator(metricFactory.makeLongColumnSelector(this.fieldName));
    }

    @Override
    public Comparator getComparator() {
        return LongSumAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return LongSumAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongSumAggregatorFactory(this.name, this.name);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new LongSumAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)1).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return 0;
    }

    public String toString() {
        return "LongSumAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongSumAggregatorFactory that = (LongSumAggregatorFactory)o;
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

