/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.ResourceClosingSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.BaseQuery;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.segment.incremental.IncrementalIndex;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GroupByMergedQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(GroupByMergedQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ListeningExecutorService exec;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final QueryWatcher queryWatcher;
    private final StupidPool<ByteBuffer> bufferPool;

    public GroupByMergedQueryRunner(ExecutorService exec, Supplier<GroupByQueryConfig> configSupplier, QueryWatcher queryWatcher, StupidPool<ByteBuffer> bufferPool, Iterable<QueryRunner<T>> queryables) {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
        this.configSupplier = configSupplier;
        this.bufferPool = bufferPool;
    }

    @Override
    public Sequence<T> run(final Query<T> queryParam, final Map<String, Object> responseContext) {
        final GroupByQuery query = (GroupByQuery)queryParam;
        GroupByQueryConfig querySpecificConfig = ((GroupByQueryConfig)this.configSupplier.get()).withOverrides(query);
        final boolean isSingleThreaded = querySpecificConfig.isSingleThreaded();
        final Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, querySpecificConfig, this.bufferPool);
        final Pair bySegmentAccumulatorPair = GroupByQueryHelper.createBySegmentAccumulatorPair();
        final boolean bySegment = BaseQuery.getContextBySegment(query, false);
        final int priority = BaseQuery.getContextPriority(query, 0);
        ListenableFuture futures = Futures.allAsList((Iterable)Lists.newArrayList((Iterable)Iterables.transform(this.queryables, (Function)new Function<QueryRunner<T>, ListenableFuture<Void>>(){

            public ListenableFuture<Void> apply(final QueryRunner<T> input) {
                if (input == null) {
                    throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                }
                ListenableFuture future = GroupByMergedQueryRunner.this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(priority){

                    @Override
                    public Void call() throws Exception {
                        try {
                            if (bySegment) {
                                input.run(queryParam, responseContext).accumulate(bySegmentAccumulatorPair.lhs, (Accumulator)bySegmentAccumulatorPair.rhs);
                            } else {
                                input.run(queryParam, responseContext).accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
                            }
                            return null;
                        }
                        catch (QueryInterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (Exception e) {
                            log.error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
                if (isSingleThreaded) {
                    GroupByMergedQueryRunner.this.waitForFutureCompletion(query, future, (IncrementalIndex)indexAccumulatorPair.lhs);
                }
                return future;
            }
        })));
        if (!isSingleThreaded) {
            this.waitForFutureCompletion(query, futures, (IncrementalIndex)indexAccumulatorPair.lhs);
        }
        if (bySegment) {
            return Sequences.simple((Iterable)((Iterable)bySegmentAccumulatorPair.lhs));
        }
        return new ResourceClosingSequence(Sequences.simple((Iterable)Iterables.transform(((IncrementalIndex)indexAccumulatorPair.lhs).iterableWithPostAggregations(null, query.isDescending()), (Function)new Function<Row, T>(){

            public T apply(Row input) {
                return input;
            }
        })), (Closeable)indexAccumulatorPair.lhs);
    }

    private void waitForFutureCompletion(GroupByQuery query, ListenableFuture<?> future, IncrementalIndex<?> closeOnFailure) {
        try {
            this.queryWatcher.registerQuery(query, future);
            Number timeout = query.getContextValue("timeout", null);
            if (timeout == null) {
                future.get();
            } else {
                future.get(timeout.longValue(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
            future.cancel(true);
            closeOnFailure.close();
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            closeOnFailure.close();
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            closeOnFailure.close();
            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
            future.cancel(true);
            throw new QueryInterruptedException(e);
        }
        catch (ExecutionException e) {
            closeOnFailure.close();
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

