/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.BaseQuery;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class BySegmentQueryRunner<T>
implements QueryRunner<T> {
    private final String segmentIdentifier;
    private final DateTime timestamp;
    private final QueryRunner<T> base;

    public BySegmentQueryRunner(String segmentIdentifier, DateTime timestamp, QueryRunner<T> base) {
        this.segmentIdentifier = segmentIdentifier;
        this.timestamp = timestamp;
        this.base = base;
    }

    @Override
    public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
        if (BaseQuery.getContextBySegment(query, false)) {
            Sequence<T> baseSequence = this.base.run(query, responseContext);
            List results = Sequences.toList(baseSequence, (List)Lists.newArrayList());
            return Sequences.simple(Arrays.asList(new Result(this.timestamp, new BySegmentResultValueClass(results, this.segmentIdentifier, query.getIntervals().get(0)))));
        }
        return this.base.run(query, responseContext);
    }
}

