/*
 * Licensed to Metamarkets Group Inc. (Metamarkets) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. Metamarkets licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package io.druid.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;

public class StringComparatorModule extends SimpleModule
{
  public StringComparatorModule()
  {
    super("StringComparatorModule");

    setMixInAnnotation(StringComparator.class, StringComparatorMixin.class);
    registerSubtypes(
        new NamedType(StringComparators.LexicographicComparator.class, StringComparators.LEXICOGRAPHIC_NAME),
        new NamedType(StringComparators.AlphanumericComparator.class, StringComparators.ALPHANUMERIC_NAME),
        new NamedType(StringComparators.StrlenComparator.class, StringComparators.STRLEN_NAME),
        new NamedType(StringComparators.NumericComparator.class, StringComparators.NUMERIC_NAME)
    );
  }

  @JsonTypeInfo(use= JsonTypeInfo.Id.NAME, property = "type", defaultImpl = StringComparator.class)
  public static interface StringComparatorMixin {}
}
