/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.IAE;
import io.druid.segment.CompressedVSizeIndexedSupplier;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerde;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferSerializer;
import io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedMultivalue;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import io.druid.segment.data.WritableSupplier;
import io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    private static final int NO_FLAGS = 0;
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final ByteOrder byteOrder;
    private final GenericIndexed<String> dictionary;
    private final WritableSupplier<IndexedInts> singleValuedColumn;
    private final WritableSupplier<IndexedMultivalue<IndexedInts>> multiValuedColumn;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final ImmutableRTree spatialIndex;
    private final int flags;
    private final VERSION version;
    private final long size;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public DictionaryEncodedColumnPartSerde(@Nullable @JsonProperty(value="bitmapSerdeFactory") BitmapSerdeFactory bitmapSerdeFactory, @NotNull @JsonProperty(value="byteOrder") ByteOrder byteOrder) {
        this.bitmapSerdeFactory = bitmapSerdeFactory == null ? new BitmapSerde.LegacyBitmapSerdeFactory() : bitmapSerdeFactory;
        this.byteOrder = byteOrder;
        this.dictionary = null;
        this.singleValuedColumn = null;
        this.multiValuedColumn = null;
        this.bitmaps = null;
        this.spatialIndex = null;
        this.size = -1L;
        this.flags = 0;
        this.version = VERSION.COMPRESSED;
    }

    private DictionaryEncodedColumnPartSerde(VERSION version, int flags, GenericIndexed<String> dictionary, WritableSupplier<IndexedInts> singleValuedColumn, WritableSupplier<IndexedMultivalue<IndexedInts>> multiValuedColumn, BitmapSerdeFactory bitmapSerdeFactory, GenericIndexed<ImmutableBitmap> bitmaps, ImmutableRTree spatialIndex, ByteOrder byteOrder) {
        Preconditions.checkArgument((version.compareTo(VERSION.COMPRESSED) <= 0 ? 1 : 0) != 0, (String)"Unsupported version[%s]", (Object[])new Object[]{version});
        this.bitmapSerdeFactory = bitmapSerdeFactory;
        this.byteOrder = byteOrder;
        this.version = version;
        this.flags = flags;
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.bitmaps = bitmaps;
        this.spatialIndex = spatialIndex;
        long size = dictionary.getSerializedSize();
        size = Feature.MULTI_VALUE.isSet(flags) ? (size += multiValuedColumn.getSerializedSize()) : (size += singleValuedColumn.getSerializedSize());
        size += bitmaps.getSerializedSize();
        if (spatialIndex != null) {
            size += (long)(spatialIndex.size() + 4);
        }
        this.size = size;
    }

    @JsonProperty
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{this.version.asByte()}));
        if (this.version.compareTo(VERSION.COMPRESSED) >= 0) {
            channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.flags)));
        }
        if (this.dictionary != null) {
            this.dictionary.writeToChannel(channel);
        }
        if (Feature.MULTI_VALUE.isSet(this.flags)) {
            if (this.multiValuedColumn != null) {
                this.multiValuedColumn.writeToChannel(channel);
            }
        } else if (this.singleValuedColumn != null) {
            this.singleValuedColumn.writeToChannel(channel);
        }
        if (this.bitmaps != null) {
            this.bitmaps.writeToChannel(channel);
        }
        if (this.spatialIndex != null) {
            ByteBufferSerializer.writeToChannel(this.spatialIndex, new IndexedRTree.ImmutableRTreeObjectStrategy(this.bitmapSerdeFactory.getBitmapFactory()), channel);
        }
    }

    @Override
    public ColumnPartSerde read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        WritableSupplier<IndexedInts> rSingleValuedColumn;
        WritableSupplier<IndexedMultivalue<IndexedInts>> rMultiValuedColumn;
        VERSION rVersion = VERSION.fromByte(buffer.get());
        int rFlags = rVersion.compareTo(VERSION.COMPRESSED) >= 0 ? buffer.getInt() : (rVersion.equals((Object)VERSION.UNCOMPRESSED_MULTI_VALUE) ? Feature.MULTI_VALUE.getMask() : 0);
        boolean hasMultipleValues = Feature.MULTI_VALUE.isSet(rFlags);
        GenericIndexed<String> rDictionary = GenericIndexed.read(buffer, GenericIndexed.STRING_STRATEGY);
        builder.setType(ValueType.STRING);
        if (hasMultipleValues) {
            rMultiValuedColumn = this.readMultiValuedColum(rVersion, buffer);
            rSingleValuedColumn = null;
        } else {
            rSingleValuedColumn = this.readSingleValuedColumn(rVersion, buffer);
            rMultiValuedColumn = null;
        }
        builder.setHasMultipleValues(hasMultipleValues).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(rDictionary, rSingleValuedColumn, rMultiValuedColumn, columnConfig.columnCacheSizeBytes()));
        GenericIndexed<ImmutableBitmap> rBitmaps = GenericIndexed.read(buffer, this.bitmapSerdeFactory.getObjectStrategy());
        builder.setBitmapIndex(new BitmapIndexColumnPartSupplier(this.bitmapSerdeFactory.getBitmapFactory(), rBitmaps, rDictionary));
        ImmutableRTree rSpatialIndex = null;
        if (buffer.hasRemaining()) {
            rSpatialIndex = ByteBufferSerializer.read(buffer, new IndexedRTree.ImmutableRTreeObjectStrategy(this.bitmapSerdeFactory.getBitmapFactory()));
            builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(rSpatialIndex));
        }
        return new DictionaryEncodedColumnPartSerde(rVersion, rFlags, rDictionary, rSingleValuedColumn, rMultiValuedColumn, this.bitmapSerdeFactory, rBitmaps, rSpatialIndex, this.byteOrder);
    }

    private WritableSupplier<IndexedInts> readSingleValuedColumn(VERSION version, ByteBuffer buffer) {
        switch (version) {
            case UNCOMPRESSED_SINGLE_VALUE: {
                return VSizeIndexedInts.readFromByteBuffer(buffer).asWritableSupplier();
            }
            case COMPRESSED: {
                return CompressedVSizeIntsIndexedSupplier.fromByteBuffer(buffer, this.byteOrder);
            }
        }
        throw new IAE("Unsupported single-value version[%s]", new Object[]{version});
    }

    private WritableSupplier<IndexedMultivalue<IndexedInts>> readMultiValuedColum(VERSION version, ByteBuffer buffer) {
        switch (version) {
            case UNCOMPRESSED_MULTI_VALUE: {
                return VSizeIndexed.readFromByteBuffer(buffer).asWritableSupplier();
            }
            case COMPRESSED: {
                return CompressedVSizeIndexedSupplier.fromByteBuffer(buffer, this.byteOrder);
            }
        }
        throw new IAE("Unsupported multi-value version[%s]", new Object[]{version});
    }

    @Override
    public long numBytes() {
        return (long)(1 + (this.version.compareTo(VERSION.COMPRESSED) >= 0 ? 4 : 0)) + this.size;
    }

    public static class Builder {
        private VERSION version = null;
        private int flags = 0;
        private GenericIndexed<String> dictionary = null;
        private WritableSupplier<IndexedInts> singleValuedColumn = null;
        private WritableSupplier<IndexedMultivalue<IndexedInts>> multiValuedColumn = null;
        private BitmapSerdeFactory bitmapSerdeFactory = null;
        private GenericIndexed<ImmutableBitmap> bitmaps = null;
        private ImmutableRTree spatialIndex = null;
        private ByteOrder byteOrder = null;

        private Builder() {
        }

        public Builder withDictionary(GenericIndexed<String> dictionary) {
            this.dictionary = dictionary;
            return this;
        }

        public Builder withBitmapSerdeFactory(BitmapSerdeFactory bitmapSerdeFactory) {
            this.bitmapSerdeFactory = bitmapSerdeFactory;
            return this;
        }

        public Builder withBitmaps(GenericIndexed<ImmutableBitmap> bitmaps) {
            this.bitmaps = bitmaps;
            return this;
        }

        public Builder withSpatialIndex(ImmutableRTree spatialIndex) {
            this.spatialIndex = spatialIndex;
            return this;
        }

        public Builder withByteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public Builder withSingleValuedColumn(VSizeIndexedInts singleValuedColumn) {
            Preconditions.checkState((this.multiValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both singleValuedColumn and multiValuedColumn");
            this.version = VERSION.UNCOMPRESSED_SINGLE_VALUE;
            this.singleValuedColumn = singleValuedColumn.asWritableSupplier();
            return this;
        }

        public Builder withSingleValuedColumn(CompressedVSizeIntsIndexedSupplier singleValuedColumn) {
            Preconditions.checkState((this.multiValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both singleValuedColumn and multiValuedColumn");
            this.version = VERSION.COMPRESSED;
            this.singleValuedColumn = singleValuedColumn;
            return this;
        }

        public Builder withMultiValuedColumn(VSizeIndexed multiValuedColumn) {
            Preconditions.checkState((this.singleValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both multiValuedColumn and singleValuedColumn");
            this.version = VERSION.UNCOMPRESSED_MULTI_VALUE;
            this.flags |= Feature.MULTI_VALUE.getMask();
            this.multiValuedColumn = multiValuedColumn.asWritableSupplier();
            return this;
        }

        public Builder withMultiValuedColumn(CompressedVSizeIndexedSupplier multiValuedColumn) {
            Preconditions.checkState((this.singleValuedColumn == null ? 1 : 0) != 0, (Object)"Cannot set both singleValuedColumn and multiValuedColumn");
            this.version = VERSION.COMPRESSED;
            this.flags |= Feature.MULTI_VALUE.getMask();
            this.multiValuedColumn = multiValuedColumn;
            return this;
        }

        public DictionaryEncodedColumnPartSerde build() {
            Preconditions.checkArgument((boolean)(this.singleValuedColumn != null ^ this.multiValuedColumn != null), (String)"Exactly one of singleValCol[%s] or multiValCol[%s] must be set", (Object[])new Object[]{this.singleValuedColumn, this.multiValuedColumn});
            return new DictionaryEncodedColumnPartSerde(this.version, this.flags, this.dictionary, this.singleValuedColumn, this.multiValuedColumn, this.bitmapSerdeFactory, this.bitmaps, this.spatialIndex, this.byteOrder);
        }
    }

    static enum VERSION {
        UNCOMPRESSED_SINGLE_VALUE,
        UNCOMPRESSED_MULTI_VALUE,
        COMPRESSED;


        public static VERSION fromByte(byte b) {
            VERSION[] values = VERSION.values();
            Preconditions.checkArgument((b < values.length ? 1 : 0) != 0, (String)"Unsupported dictionary column version[%s]", (Object[])new Object[]{b});
            return values[b];
        }

        public byte asByte() {
            return (byte)this.ordinal();
        }
    }

    static enum Feature {
        MULTI_VALUE;


        public boolean isSet(int flags) {
            return (this.getMask() & flags) != 0;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

