/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.metamx.collections.spatial.search.Bound;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.granularity.QueryGranularity;
import io.druid.query.QueryInterruptedException;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.NullDimensionSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.SingleScanTimeDimSelector;
import io.druid.segment.StorageAdapter;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.filter.BooleanValueMatcher;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IncrementalIndexStorageAdapter
implements StorageAdapter {
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private static final NullDimensionSelector NULL_DIMENSION_SELECTOR = new NullDimensionSelector();
    private final IncrementalIndex index;

    public IncrementalIndexStorageAdapter(IncrementalIndex index) {
        this.index = index;
    }

    @Override
    public String getSegmentIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval() {
        return this.index.getInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return new ListIndexed<String>(this.index.getDimensions(), String.class);
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        return this.index.getMetricNames();
    }

    @Override
    public int getDimensionCardinality(String dimension) {
        if (dimension.equals("__time")) {
            return Integer.MAX_VALUE;
        }
        IncrementalIndex.DimDim dimDim = this.index.getDimension(dimension);
        if (dimDim == null) {
            return 0;
        }
        return dimDim.size();
    }

    @Override
    public DateTime getMinTime() {
        return this.index.getMinTime();
    }

    @Override
    public DateTime getMaxTime() {
        return this.index.getMaxTime();
    }

    @Override
    public Capabilities getCapabilities() {
        return Capabilities.builder().dimensionValuesSorted(false).build();
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.index.getMaxIngestedEventTime();
    }

    @Override
    public Sequence<Cursor> makeCursors(final Filter filter, Interval interval, final QueryGranularity gran) {
        if (this.index.isEmpty()) {
            return Sequences.empty();
        }
        Interval actualIntervalTmp = interval;
        Interval dataInterval = new Interval(this.getMinTime().getMillis(), gran.next(gran.truncate(this.getMaxTime().getMillis())));
        if (!actualIntervalTmp.overlaps((ReadableInterval)dataInterval)) {
            return Sequences.empty();
        }
        if (actualIntervalTmp.getStart().isBefore((ReadableInstant)dataInterval.getStart())) {
            actualIntervalTmp = actualIntervalTmp.withStart((ReadableInstant)dataInterval.getStart());
        }
        if (actualIntervalTmp.getEnd().isAfter((ReadableInstant)dataInterval.getEnd())) {
            actualIntervalTmp = actualIntervalTmp.withEnd((ReadableInstant)dataInterval.getEnd());
        }
        final Interval actualInterval = actualIntervalTmp;
        return Sequences.map((Sequence)Sequences.simple(gran.iterable(actualInterval.getStartMillis(), actualInterval.getEndMillis())), (Function)new Function<Long, Cursor>(){
            EntryHolder currEntry = new EntryHolder();
            private final ValueMatcher filterMatcher = IncrementalIndexStorageAdapter.access$100(IncrementalIndexStorageAdapter.this, filter, this.currEntry);

            public Cursor apply(final @Nullable Long input) {
                final long timeStart = Math.max(input, actualInterval.getStartMillis());
                return new Cursor(){
                    private Iterator<Map.Entry<IncrementalIndex.TimeAndDims, Integer>> baseIter;
                    private ConcurrentNavigableMap<IncrementalIndex.TimeAndDims, Integer> cursorMap;
                    final DateTime time;
                    int numAdvanced = -1;
                    boolean done;
                    {
                        this.cursorMap = IncrementalIndexStorageAdapter.this.index.getSubMap(new IncrementalIndex.TimeAndDims(timeStart, new String[0][]), new IncrementalIndex.TimeAndDims(Math.min(actualInterval.getEndMillis(), gran.next(input)), new String[0][]));
                        this.time = gran.toDateTime(input);
                        this.reset();
                    }

                    @Override
                    public DateTime getTime() {
                        return this.time;
                    }

                    @Override
                    public void advance() {
                        if (!this.baseIter.hasNext()) {
                            this.done = true;
                            return;
                        }
                        while (this.baseIter.hasNext()) {
                            if (Thread.interrupted()) {
                                throw new QueryInterruptedException();
                            }
                            currEntry.set(this.baseIter.next());
                            if (!filterMatcher.matches()) continue;
                            return;
                        }
                        if (!filterMatcher.matches()) {
                            this.done = true;
                        }
                    }

                    @Override
                    public void advanceTo(int offset) {
                        for (int count = 0; count < offset && !this.isDone(); ++count) {
                            this.advance();
                        }
                    }

                    @Override
                    public boolean isDone() {
                        return this.done;
                    }

                    @Override
                    public void reset() {
                        this.baseIter = this.cursorMap.entrySet().iterator();
                        if (this.numAdvanced == -1) {
                            this.numAdvanced = 0;
                        } else {
                            Iterators.advance(this.baseIter, (int)this.numAdvanced);
                        }
                        if (Thread.interrupted()) {
                            throw new QueryInterruptedException();
                        }
                        boolean foundMatched = false;
                        while (this.baseIter.hasNext()) {
                            currEntry.set(this.baseIter.next());
                            if (filterMatcher.matches()) {
                                foundMatched = true;
                                break;
                            }
                            ++this.numAdvanced;
                        }
                        this.done = !foundMatched && (this.cursorMap.size() == 0 || !this.baseIter.hasNext());
                    }

                    @Override
                    public DimensionSelector makeDimensionSelector(String dimension, final @Nullable ExtractionFn extractionFn) {
                        if (dimension.equals("__time")) {
                            return new SingleScanTimeDimSelector(this.makeLongColumnSelector(dimension), extractionFn);
                        }
                        final IncrementalIndex.DimDim dimValLookup = IncrementalIndexStorageAdapter.this.index.getDimension(dimension);
                        if (dimValLookup == null) {
                            return NULL_DIMENSION_SELECTOR;
                        }
                        final int maxId = dimValLookup.size();
                        final int dimIndex = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension);
                        return new DimensionSelector(){

                            @Override
                            public IndexedInts getRow() {
                                int id;
                                String[] dimVals;
                                final ArrayList vals = Lists.newArrayList();
                                if (dimIndex < currEntry.getKey().getDims().length && (dimVals = currEntry.getKey().getDims()[dimIndex]) != null) {
                                    for (String dimVal : dimVals) {
                                        int id2 = dimValLookup.getId(dimVal);
                                        if (id2 >= maxId) continue;
                                        vals.add(id2);
                                    }
                                }
                                if (vals.isEmpty() && dimValLookup.contains(null) && (id = dimValLookup.getId(null)) < maxId) {
                                    vals.add(id);
                                }
                                return new IndexedInts(){

                                    @Override
                                    public int size() {
                                        return vals.size();
                                    }

                                    @Override
                                    public int get(int index) {
                                        return (Integer)vals.get(index);
                                    }

                                    @Override
                                    public Iterator<Integer> iterator() {
                                        return vals.iterator();
                                    }

                                    @Override
                                    public void fill(int index, int[] toFill) {
                                        throw new UnsupportedOperationException("fill not supported");
                                    }

                                    @Override
                                    public void close() throws IOException {
                                    }
                                };
                            }

                            @Override
                            public int getValueCardinality() {
                                return maxId;
                            }

                            @Override
                            public String lookupName(int id) {
                                String value = dimValLookup.getValue(id);
                                return extractionFn == null ? value : extractionFn.apply(value);
                            }

                            @Override
                            public int lookupId(String name) {
                                if (extractionFn != null) {
                                    throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                                }
                                return dimValLookup.getId(name);
                            }
                        };
                    }

                    @Override
                    public FloatColumnSelector makeFloatColumnSelector(String columnName) {
                        Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(columnName);
                        if (metricIndexInt == null) {
                            return new FloatColumnSelector(){

                                @Override
                                public float get() {
                                    return 0.0f;
                                }
                            };
                        }
                        final int metricIndex = metricIndexInt;
                        return new FloatColumnSelector(){

                            @Override
                            public float get() {
                                return IncrementalIndexStorageAdapter.this.index.getMetricFloatValue(currEntry.getValue(), metricIndex);
                            }
                        };
                    }

                    @Override
                    public LongColumnSelector makeLongColumnSelector(String columnName) {
                        if (columnName.equals("__time")) {
                            return new LongColumnSelector(){

                                @Override
                                public long get() {
                                    return currEntry.getKey().getTimestamp();
                                }
                            };
                        }
                        Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(columnName);
                        if (metricIndexInt == null) {
                            return new LongColumnSelector(){

                                @Override
                                public long get() {
                                    return 0L;
                                }
                            };
                        }
                        final int metricIndex = metricIndexInt;
                        return new LongColumnSelector(){

                            @Override
                            public long get() {
                                return IncrementalIndexStorageAdapter.this.index.getMetricLongValue(currEntry.getValue(), metricIndex);
                            }
                        };
                    }

                    @Override
                    public ObjectColumnSelector makeObjectColumnSelector(String column) {
                        if (column.equals("__time")) {
                            return new ObjectColumnSelector<Long>(){

                                @Override
                                public Class classOfObject() {
                                    return Long.TYPE;
                                }

                                @Override
                                public Long get() {
                                    return currEntry.getKey().getTimestamp();
                                }
                            };
                        }
                        Integer metricIndexInt = IncrementalIndexStorageAdapter.this.index.getMetricIndex(column);
                        if (metricIndexInt != null) {
                            final int metricIndex = metricIndexInt;
                            final ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(IncrementalIndexStorageAdapter.this.index.getMetricType(column));
                            return new ObjectColumnSelector(){

                                public Class classOfObject() {
                                    return serde.getObjectStrategy().getClazz();
                                }

                                public Object get() {
                                    return IncrementalIndexStorageAdapter.this.index.getMetricObjectValue(currEntry.getValue(), metricIndex);
                                }
                            };
                        }
                        Integer dimensionIndexInt = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(column);
                        if (dimensionIndexInt != null) {
                            final int dimensionIndex = dimensionIndexInt;
                            return new ObjectColumnSelector<Object>(){

                                @Override
                                public Class classOfObject() {
                                    return Object.class;
                                }

                                @Override
                                public Object get() {
                                    IncrementalIndex.TimeAndDims key = currEntry.getKey();
                                    if (key == null) {
                                        return null;
                                    }
                                    String[][] dims = key.getDims();
                                    if (dimensionIndex >= dims.length) {
                                        return null;
                                    }
                                    String[] dimVals = dims[dimensionIndex];
                                    if (dimVals == null || dimVals.length == 0) {
                                        return null;
                                    }
                                    if (dimVals.length == 1) {
                                        return dimVals[0];
                                    }
                                    return dimVals;
                                }
                            };
                        }
                        return null;
                    }
                };
            }
        });
    }

    private ValueMatcher makeFilterMatcher(Filter filter, EntryHolder holder) {
        return filter == null ? new BooleanValueMatcher(true) : filter.makeMatcher(new EntryHolderValueMatcherFactory(holder));
    }

    static /* synthetic */ ValueMatcher access$100(IncrementalIndexStorageAdapter x0, Filter x1, EntryHolder x2) {
        return x0.makeFilterMatcher(x1, x2);
    }

    private class EntryHolderValueMatcherFactory
    implements ValueMatcherFactory {
        private final EntryHolder holder;

        public EntryHolderValueMatcherFactory(EntryHolder holder) {
            this.holder = holder;
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, final String value) {
            Integer dimIndexObject = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension);
            if (dimIndexObject == null) {
                return new BooleanValueMatcher(Strings.isNullOrEmpty((String)value));
            }
            final IncrementalIndex.DimDim dimDim = IncrementalIndexStorageAdapter.this.index.getDimension(dimension);
            if (!dimDim.contains(value)) {
                if (Strings.isNullOrEmpty((String)value)) {
                    final int dimIndex = dimIndexObject;
                    return new ValueMatcher(){

                        @Override
                        public boolean matches() {
                            String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                            return dimIndex >= dims.length || dims[dimIndex] == null;
                        }
                    };
                }
                return new BooleanValueMatcher(false);
            }
            final int dimIndex = dimIndexObject;
            final String id = dimDim.get(value);
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                    if (dimIndex >= dims.length || dims[dimIndex] == null) {
                        return Strings.isNullOrEmpty((String)value);
                    }
                    for (String dimVal : dims[dimIndex]) {
                        if (!dimDim.compareCannonicalValues(id, dimVal)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, final Predicate<String> predicate) {
            Integer dimIndexObject = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension);
            if (dimIndexObject == null) {
                return new BooleanValueMatcher(false);
            }
            final int dimIndex = dimIndexObject;
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                    if (dimIndex >= dims.length || dims[dimIndex] == null) {
                        return predicate.apply(null);
                    }
                    for (String dimVal : dims[dimIndex]) {
                        if (!predicate.apply((Object)dimVal)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ValueMatcher makeValueMatcher(String dimension, final Bound bound) {
            Integer dimIndexObject = IncrementalIndexStorageAdapter.this.index.getDimensionIndex(dimension);
            if (dimIndexObject == null) {
                return new BooleanValueMatcher(false);
            }
            final int dimIndex = dimIndexObject;
            return new ValueMatcher(){

                @Override
                public boolean matches() {
                    String[][] dims = EntryHolderValueMatcherFactory.this.holder.getKey().getDims();
                    if (dimIndex >= dims.length || dims[dimIndex] == null) {
                        return false;
                    }
                    for (String dimVal : dims[dimIndex]) {
                        ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                        float[] coords = new float[stringCoords.size()];
                        for (int j = 0; j < coords.length; ++j) {
                            coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                        }
                        if (!bound.contains(coords)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    private static class EntryHolder {
        Map.Entry<IncrementalIndex.TimeAndDims, Integer> currEntry = null;

        private EntryHolder() {
        }

        public Map.Entry<IncrementalIndex.TimeAndDims, Integer> get() {
            return this.currEntry;
        }

        public void set(Map.Entry<IncrementalIndex.TimeAndDims, Integer> currEntry) {
            this.currEntry = currEntry;
        }

        public IncrementalIndex.TimeAndDims getKey() {
            return this.currEntry.getKey();
        }

        public Integer getValue() {
            return this.currEntry.getValue();
        }
    }
}

