/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.SpatialDimensionRowTransformer;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class IncrementalIndex<AggregatorType>
implements Iterable<Row>,
Closeable {
    private volatile DateTime maxIngestedEventTime;
    private final long minTimestamp;
    private final QueryGranularity gran;
    private final List<Function<InputRow, InputRow>> rowTransformers;
    private final AggregatorFactory[] metrics;
    private final Map<String, Integer> metricIndexes;
    private final Map<String, String> metricTypes;
    private final ImmutableList<String> metricNames;
    private final LinkedHashMap<String, Integer> dimensionOrder;
    private final AggregatorType[] aggs;
    private final DimensionHolder dimValues;
    private final Map<String, ColumnCapabilitiesImpl> columnCapabilities;
    private final boolean deserializeComplexMetrics;
    protected final CopyOnWriteArrayList<String> dimensions;
    private volatile AtomicInteger numEntries = new AtomicInteger();
    private ThreadLocal<InputRow> in = new ThreadLocal();
    private Supplier<InputRow> rowSupplier = new Supplier<InputRow>(){

        public InputRow get() {
            return (InputRow)IncrementalIndex.this.in.get();
        }
    };

    public static ColumnSelectorFactory makeColumnSelectorFactory(final AggregatorFactory agg, final Supplier<InputRow> in, final boolean deserializeComplexMetrics) {
        return new ColumnSelectorFactory(){

            @Override
            public LongColumnSelector makeLongColumnSelector(final String columnName) {
                if (columnName.equals("__time")) {
                    return new LongColumnSelector(){

                        @Override
                        public long get() {
                            return ((InputRow)in.get()).getTimestampFromEpoch();
                        }
                    };
                }
                return new LongColumnSelector(){

                    @Override
                    public long get() {
                        return ((InputRow)in.get()).getLongMetric(columnName);
                    }
                };
            }

            @Override
            public FloatColumnSelector makeFloatColumnSelector(final String columnName) {
                return new FloatColumnSelector(){

                    @Override
                    public float get() {
                        return ((InputRow)in.get()).getFloatMetric(columnName);
                    }
                };
            }

            @Override
            public ObjectColumnSelector makeObjectColumnSelector(final String column) {
                String typeName = agg.getTypeName();
                ObjectColumnSelector<Object> rawColumnSelector = new ObjectColumnSelector<Object>(){

                    @Override
                    public Class classOfObject() {
                        return Object.class;
                    }

                    @Override
                    public Object get() {
                        return ((InputRow)in.get()).getRaw(column);
                    }
                };
                if (!deserializeComplexMetrics) {
                    return rawColumnSelector;
                }
                if (typeName.equals("float")) {
                    return rawColumnSelector;
                }
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                if (serde == null) {
                    throw new ISE("Don't know how to handle type[%s]", new Object[]{typeName});
                }
                final ComplexMetricExtractor extractor = serde.getExtractor();
                return new ObjectColumnSelector(){

                    public Class classOfObject() {
                        return extractor.extractedClass();
                    }

                    public Object get() {
                        return extractor.extractValue((InputRow)in.get(), column);
                    }
                };
            }

            @Override
            public DimensionSelector makeDimensionSelector(final String dimension, final ExtractionFn extractionFn) {
                return new DimensionSelector(){

                    @Override
                    public IndexedInts getRow() {
                        List dimensionValues = ((InputRow)in.get()).getDimension(dimension);
                        final ArrayList vals = Lists.newArrayList();
                        if (dimensionValues != null) {
                            for (int i = 0; i < dimensionValues.size(); ++i) {
                                vals.add(i);
                            }
                        }
                        return new IndexedInts(){

                            @Override
                            public int size() {
                                return vals.size();
                            }

                            @Override
                            public int get(int index) {
                                return (Integer)vals.get(index);
                            }

                            @Override
                            public Iterator<Integer> iterator() {
                                return vals.iterator();
                            }

                            @Override
                            public void close() throws IOException {
                            }

                            @Override
                            public void fill(int index, int[] toFill) {
                                throw new UnsupportedOperationException("fill not supported");
                            }
                        };
                    }

                    @Override
                    public int getValueCardinality() {
                        throw new UnsupportedOperationException("value cardinality is unknown in incremental index");
                    }

                    @Override
                    public String lookupName(int id) {
                        String value = (String)((InputRow)in.get()).getDimension(dimension).get(id);
                        return extractionFn == null ? value : extractionFn.apply(value);
                    }

                    @Override
                    public int lookupId(String name) {
                        if (extractionFn != null) {
                            throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                        }
                        return ((InputRow)in.get()).getDimension(dimension).indexOf(name);
                    }
                };
            }
        };
    }

    public IncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics) {
        ColumnCapabilitiesImpl capabilities;
        this.minTimestamp = incrementalIndexSchema.getMinTimestamp();
        this.gran = incrementalIndexSchema.getGran();
        this.metrics = incrementalIndexSchema.getMetrics();
        this.rowTransformers = new CopyOnWriteArrayList<Function<InputRow, InputRow>>();
        this.deserializeComplexMetrics = deserializeComplexMetrics;
        ImmutableList.Builder metricNamesBuilder = ImmutableList.builder();
        ImmutableMap.Builder metricIndexesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder metricTypesBuilder = ImmutableMap.builder();
        this.aggs = this.initAggs(this.metrics, this.rowSupplier, deserializeComplexMetrics);
        for (int i = 0; i < this.metrics.length; ++i) {
            String metricName = this.metrics[i].getName();
            metricNamesBuilder.add((Object)metricName);
            metricIndexesBuilder.put((Object)metricName, (Object)i);
            metricTypesBuilder.put((Object)metricName, (Object)this.metrics[i].getTypeName());
        }
        this.metricNames = metricNamesBuilder.build();
        this.metricIndexes = metricIndexesBuilder.build();
        this.metricTypes = metricTypesBuilder.build();
        this.dimensionOrder = Maps.newLinkedHashMap();
        this.dimensions = new CopyOnWriteArrayList(incrementalIndexSchema.getDimensionsSpec().getDimensions());
        List spatialDimensions = incrementalIndexSchema.getDimensionsSpec().getSpatialDimensions();
        if (!spatialDimensions.isEmpty()) {
            this.rowTransformers.add(new SpatialDimensionRowTransformer(spatialDimensions));
        }
        this.columnCapabilities = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.metricTypes.entrySet()) {
            ValueType type = entry.getValue().equalsIgnoreCase("float") ? ValueType.FLOAT : (entry.getValue().equalsIgnoreCase("long") ? ValueType.LONG : ValueType.COMPLEX);
            ColumnCapabilitiesImpl capabilities2 = new ColumnCapabilitiesImpl();
            capabilities2.setType(type);
            this.columnCapabilities.put(entry.getKey(), capabilities2);
        }
        this.dimValues = new DimensionHolder();
        for (String dimension : this.dimensions) {
            capabilities = new ColumnCapabilitiesImpl();
            capabilities.setType(ValueType.STRING);
            this.columnCapabilities.put(dimension, capabilities);
            this.dimensionOrder.put(dimension, this.dimensionOrder.size());
            this.dimValues.add(dimension);
        }
        for (SpatialDimensionSchema spatialDimension : spatialDimensions) {
            capabilities = new ColumnCapabilitiesImpl();
            capabilities.setType(ValueType.STRING);
            capabilities.setHasSpatialIndexes(true);
            this.columnCapabilities.put(spatialDimension.getDimName(), capabilities);
        }
    }

    public abstract ConcurrentNavigableMap<TimeAndDims, Integer> getFacts();

    public abstract boolean canAppendRow();

    public abstract String getOutOfRowsReason();

    protected abstract DimDim makeDimDim(String var1);

    protected abstract AggregatorType[] initAggs(AggregatorFactory[] var1, Supplier<InputRow> var2, boolean var3);

    protected abstract Integer addToFacts(AggregatorFactory[] var1, boolean var2, InputRow var3, AtomicInteger var4, TimeAndDims var5, ThreadLocal<InputRow> var6, Supplier<InputRow> var7) throws IndexSizeExceededException;

    protected abstract AggregatorType[] getAggsForRow(int var1);

    protected abstract Object getAggVal(AggregatorType var1, int var2, int var3);

    protected abstract float getMetricFloatValue(int var1, int var2);

    protected abstract long getMetricLongValue(int var1, int var2);

    protected abstract Object getMetricObjectValue(int var1, int var2);

    @Override
    public void close() {
    }

    public InputRow formatRow(InputRow row) {
        for (Function<InputRow, InputRow> rowTransformer : this.rowTransformers) {
            row = (InputRow)rowTransformer.apply((Object)row);
        }
        if (row == null) {
            throw new IAE("Row is null? How can this be?!", new Object[0]);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(InputRow row) throws IndexSizeExceededException {
        String[][] dims;
        if ((row = this.formatRow(row)).getTimestampFromEpoch() < this.minTimestamp) {
            throw new IAE("Cannot add row[%s] because it is below the minTimestamp[%s]", new Object[]{row, new DateTime(this.minTimestamp)});
        }
        List rowDimensions = row.getDimensions();
        List overflow = null;
        LinkedHashMap<String, Integer> linkedHashMap = this.dimensionOrder;
        synchronized (linkedHashMap) {
            dims = new String[this.dimensionOrder.size()][];
            for (String dimension : rowDimensions) {
                Integer index;
                List dimensionValues = row.getDimension(dimension);
                ColumnCapabilitiesImpl capabilities = this.columnCapabilities.get(dimension);
                if (capabilities == null) {
                    capabilities = new ColumnCapabilitiesImpl();
                    capabilities.setType(ValueType.STRING);
                    this.columnCapabilities.put(dimension, capabilities);
                }
                if (dimensionValues.size() > 1) {
                    capabilities.setHasMultipleValues(true);
                }
                if ((index = this.dimensionOrder.get(dimension)) == null) {
                    this.dimensionOrder.put(dimension, this.dimensionOrder.size());
                    this.dimensions.add(dimension);
                    if (overflow == null) {
                        overflow = Lists.newArrayList();
                    }
                    overflow.add(this.getDimVals(this.dimValues.add(dimension), dimensionValues));
                    continue;
                }
                dims[index.intValue()] = this.getDimVals(this.dimValues.get(dimension), dimensionValues);
            }
        }
        if (overflow != null) {
            String[][] newDims = new String[dims.length + overflow.size()][];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            for (int i = 0; i < overflow.size(); ++i) {
                newDims[dims.length + i] = (String[])overflow.get(i);
            }
            dims = newDims;
        }
        TimeAndDims key = new TimeAndDims(Math.max(this.gran.truncate(row.getTimestampFromEpoch()), this.minTimestamp), dims);
        Integer rv = this.addToFacts(this.metrics, this.deserializeComplexMetrics, row, this.numEntries, key, this.in, this.rowSupplier);
        this.updateMaxIngestedTime(row.getTimestamp());
        return rv;
    }

    public synchronized void updateMaxIngestedTime(DateTime eventTime) {
        if (this.maxIngestedEventTime == null || this.maxIngestedEventTime.isBefore((ReadableInstant)eventTime)) {
            this.maxIngestedEventTime = eventTime;
        }
    }

    public boolean isEmpty() {
        return this.numEntries.get() == 0;
    }

    public int size() {
        return this.numEntries.get();
    }

    private long getMinTimeMillis() {
        return ((TimeAndDims)this.getFacts().firstKey()).getTimestamp();
    }

    private long getMaxTimeMillis() {
        return ((TimeAndDims)this.getFacts().lastKey()).getTimestamp();
    }

    private String[] getDimVals(DimDim dimLookup, List<String> dimValues) {
        Object[] retVal = new String[dimValues.size()];
        if (dimValues.size() == 0) {
            if (!dimLookup.contains(null)) {
                dimLookup.add(null);
            }
            return null;
        }
        int count = 0;
        for (String dimValue : dimValues) {
            String canonicalDimValue = dimLookup.get(dimValue);
            if (!dimLookup.contains(canonicalDimValue)) {
                dimLookup.add(dimValue);
            }
            retVal[count] = canonicalDimValue;
            ++count;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    public AggregatorType[] getAggs() {
        return this.aggs;
    }

    public AggregatorFactory[] getMetricAggs() {
        return this.metrics;
    }

    public DimensionHolder getDimValues() {
        return this.dimValues;
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public String getMetricType(String metric) {
        return this.metricTypes.get(metric);
    }

    public Interval getInterval() {
        return new Interval(this.minTimestamp, this.isEmpty() ? this.minTimestamp : this.gran.next(this.getMaxTimeMillis()));
    }

    public DateTime getMinTime() {
        return this.isEmpty() ? null : new DateTime(this.getMinTimeMillis());
    }

    public DateTime getMaxTime() {
        return this.isEmpty() ? null : new DateTime(this.getMaxTimeMillis());
    }

    public DimDim getDimension(String dimension) {
        return this.isEmpty() ? null : this.dimValues.get(dimension);
    }

    public Integer getDimensionIndex(String dimension) {
        return this.dimensionOrder.get(dimension);
    }

    public List<String> getMetricNames() {
        return this.metricNames;
    }

    public Integer getMetricIndex(String metricName) {
        return this.metricIndexes.get(metricName);
    }

    public ColumnCapabilities getCapabilities(String column) {
        return this.columnCapabilities.get(column);
    }

    public ConcurrentNavigableMap<TimeAndDims, Integer> getSubMap(TimeAndDims start, TimeAndDims end) {
        return this.getFacts().subMap((Object)start, (Object)end);
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterableWithPostAggregations(null).iterator();
    }

    public Iterable<Row> iterableWithPostAggregations(final List<PostAggregator> postAggs) {
        return new Iterable<Row>(){

            @Override
            public Iterator<Row> iterator() {
                return Iterators.transform(IncrementalIndex.this.getFacts().entrySet().iterator(), (Function)new Function<Map.Entry<TimeAndDims, Integer>, Row>(){

                    public Row apply(Map.Entry<TimeAndDims, Integer> input) {
                        TimeAndDims timeAndDims = input.getKey();
                        int rowOffset = input.getValue();
                        String[][] theDims = timeAndDims.getDims();
                        LinkedHashMap theVals = Maps.newLinkedHashMap();
                        for (int i = 0; i < theDims.length; ++i) {
                            String[] dim = theDims[i];
                            if (dim != null && dim.length != 0) {
                                theVals.put(IncrementalIndex.this.dimensions.get(i), dim.length == 1 ? dim[0] : Arrays.asList(dim));
                                continue;
                            }
                            theVals.put(IncrementalIndex.this.dimensions.get(i), null);
                        }
                        AggregatorType[] aggs = IncrementalIndex.this.getAggsForRow(rowOffset);
                        for (int i = 0; i < aggs.length; ++i) {
                            theVals.put(IncrementalIndex.this.metrics[i].getName(), IncrementalIndex.this.getAggVal(aggs[i], rowOffset, i));
                        }
                        if (postAggs != null) {
                            for (PostAggregator postAgg : postAggs) {
                                theVals.put(postAgg.getName(), postAgg.compute(theVals));
                            }
                        }
                        return new MapBasedRow(timeAndDims.getTimestamp(), (Map)theVals);
                    }
                });
            }
        };
    }

    public DateTime getMaxIngestedEventTime() {
        return this.maxIngestedEventTime;
    }

    static class TimeAndDims
    implements Comparable<TimeAndDims> {
        private final long timestamp;
        private final String[][] dims;

        TimeAndDims(long timestamp, String[][] dims) {
            this.timestamp = timestamp;
            this.dims = dims;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        String[][] getDims() {
            return this.dims;
        }

        @Override
        public int compareTo(TimeAndDims rhs) {
            int retVal = Longs.compare((long)this.timestamp, (long)rhs.timestamp);
            if (retVal == 0) {
                retVal = Ints.compare((int)this.dims.length, (int)rhs.dims.length);
            }
            int index = 0;
            while (retVal == 0 && index < this.dims.length) {
                String[] lhsVals = this.dims[index];
                String[] rhsVals = rhs.dims[index];
                if (lhsVals == null) {
                    if (rhsVals == null) {
                        ++index;
                        continue;
                    }
                    return -1;
                }
                if (rhsVals == null) {
                    return 1;
                }
                retVal = Ints.compare((int)lhsVals.length, (int)rhsVals.length);
                for (int valsIndex = 0; retVal == 0 && valsIndex < lhsVals.length; ++valsIndex) {
                    retVal = lhsVals[valsIndex].compareTo(rhsVals[valsIndex]);
                }
                ++index;
            }
            return retVal;
        }

        public String toString() {
            return "TimeAndDims{timestamp=" + new DateTime(this.timestamp) + ", dims=" + Lists.transform(Arrays.asList(this.dims), (Function)new Function<String[], Object>(){

                public Object apply(@Nullable String[] input) {
                    if (input == null || input.length == 0) {
                        return Arrays.asList("null");
                    }
                    return Arrays.asList(input);
                }
            }) + '}';
        }
    }

    static class NullValueConverterDimDim
    implements DimDim {
        private final DimDim delegate;

        NullValueConverterDimDim(DimDim delegate) {
            this.delegate = delegate;
        }

        @Override
        public String get(String value) {
            return this.delegate.get(Strings.nullToEmpty((String)value));
        }

        @Override
        public int getId(String value) {
            return this.delegate.getId(Strings.nullToEmpty((String)value));
        }

        @Override
        public String getValue(int id) {
            return Strings.emptyToNull((String)this.delegate.getValue(id));
        }

        @Override
        public boolean contains(String value) {
            return this.delegate.contains(Strings.nullToEmpty((String)value));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public int add(String value) {
            return this.delegate.add(Strings.nullToEmpty((String)value));
        }

        @Override
        public int getSortedId(String value) {
            return this.delegate.getSortedId(Strings.nullToEmpty((String)value));
        }

        @Override
        public String getSortedValue(int index) {
            return Strings.emptyToNull((String)this.delegate.getSortedValue(index));
        }

        @Override
        public void sort() {
            this.delegate.sort();
        }

        @Override
        public boolean compareCannonicalValues(String s1, String s2) {
            return this.delegate.compareCannonicalValues(Strings.nullToEmpty((String)s1), Strings.nullToEmpty((String)s2));
        }
    }

    static interface DimDim {
        public String get(String var1);

        public int getId(String var1);

        public String getValue(int var1);

        public boolean contains(String var1);

        public int size();

        public int add(String var1);

        public int getSortedId(String var1);

        public String getSortedValue(int var1);

        public void sort();

        public boolean compareCannonicalValues(String var1, String var2);
    }

    class DimensionHolder {
        private final Map<String, DimDim> dimensions = Maps.newConcurrentMap();

        DimensionHolder() {
        }

        DimDim add(String dimension) {
            DimDim holder = this.dimensions.get(dimension);
            if (holder != null) {
                throw new ISE("dimension[%s] already existed even though add() was called!?", new Object[]{dimension});
            }
            holder = new NullValueConverterDimDim(IncrementalIndex.this.makeDimDim(dimension));
            this.dimensions.put(dimension, holder);
            return holder;
        }

        DimDim get(String dimension) {
            return this.dimensions.get(dimension);
        }
    }
}

