/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.collect.Lists;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.util.ArrayList;
import java.util.List;

public class OrFilter
implements Filter {
    private final List<Filter> filters;

    public OrFilter(List<Filter> filters) {
        if (filters.size() == 0) {
            throw new IllegalArgumentException("Can't construct empty OrFilter (the universe does not exist)");
        }
        this.filters = filters;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(BitmapIndexSelector selector) {
        if (this.filters.size() == 1) {
            return this.filters.get(0).getBitmapIndex(selector);
        }
        ArrayList bitmaps = Lists.newArrayList();
        for (int i = 0; i < this.filters.size(); ++i) {
            bitmaps.add(this.filters.get(i).getBitmapIndex(selector));
        }
        return selector.getBitmapFactory().union((Iterable)bitmaps);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return this.makeMatcher(matchers);
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        for (int i = 0; i < this.filters.size(); ++i) {
            matchers[i] = this.filters.get(i).makeMatcher(factory);
        }
        return this.makeMatcher(matchers);
    }

    private ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                for (ValueMatcher matcher : baseMatchers) {
                    if (!matcher.matches()) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

