/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import com.metamx.common.StringUtils;
import com.metamx.common.guava.CloseQuietly;
import io.druid.segment.data.CacheableObjectStrategy;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.ObjectStrategy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;

public class GenericIndexed<T>
implements Indexed<T> {
    private static final byte version = 1;
    private int indexOffset;
    private final ByteBuffer theBuffer;
    private final ObjectStrategy<T> strategy;
    private final boolean allowReverseLookup;
    private final int size;
    private final int valuesOffset;
    private final BufferIndexed bufferIndexed;
    public static final ObjectStrategy<String> STRING_STRATEGY = new CacheableObjectStrategy<String>(){

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public String fromByteBuffer(ByteBuffer buffer, int numBytes) {
            return StringUtils.fromUtf8((ByteBuffer)buffer, (int)numBytes);
        }

        @Override
        public byte[] toBytes(String val) {
            if (val == null) {
                return new byte[0];
            }
            return StringUtils.toUtf8((String)val);
        }

        @Override
        public int compare(String o1, String o2) {
            return Ordering.natural().nullsFirst().compare((Object)o1, (Object)o2);
        }
    };

    public static <T> GenericIndexed<T> fromArray(T[] objects, ObjectStrategy<T> strategy) {
        return GenericIndexed.fromIterable(Arrays.asList(objects), strategy);
    }

    public static <T> GenericIndexed<T> fromIterable(Iterable<T> objectsIterable, ObjectStrategy<T> strategy) {
        Iterator<T> objects = objectsIterable.iterator();
        if (!objects.hasNext()) {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(0);
            buffer.flip();
            return new GenericIndexed<T>(buffer, strategy, true);
        }
        boolean allowReverseLookup = true;
        int count = 1;
        T prevVal = objects.next();
        while (objects.hasNext()) {
            T next = objects.next();
            if (strategy.compare(prevVal, next) >= 0) {
                allowReverseLookup = false;
            }
            if (prevVal instanceof Closeable) {
                CloseQuietly.close((Closeable)((Closeable)prevVal));
            }
            prevVal = next;
            ++count;
        }
        if (prevVal instanceof Closeable) {
            CloseQuietly.close((Closeable)((Closeable)prevVal));
        }
        ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(4 + count * 4);
        ByteArrayOutputStream valueBytes = new ByteArrayOutputStream();
        int offset = 0;
        try {
            headerBytes.write(Ints.toByteArray((int)count));
            for (T object : objectsIterable) {
                byte[] bytes = strategy.toBytes(object);
                headerBytes.write(Ints.toByteArray((int)(offset += 4 + bytes.length)));
                valueBytes.write(Ints.toByteArray((int)bytes.length));
                valueBytes.write(bytes);
                if (!(object instanceof Closeable)) continue;
                CloseQuietly.close((Closeable)((Closeable)object));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer theBuffer = ByteBuffer.allocate(headerBytes.size() + valueBytes.size());
        theBuffer.put(headerBytes.toByteArray());
        theBuffer.put(valueBytes.toByteArray());
        theBuffer.flip();
        return new GenericIndexed<T>(theBuffer.asReadOnlyBuffer(), strategy, allowReverseLookup);
    }

    @Override
    public Class<? extends T> getClazz() {
        return this.bufferIndexed.getClazz();
    }

    @Override
    public int size() {
        return this.bufferIndexed.size();
    }

    @Override
    public T get(int index) {
        return this.bufferIndexed.get(index);
    }

    @Override
    public int indexOf(T value) {
        return this.bufferIndexed.indexOf(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.bufferIndexed.iterator();
    }

    GenericIndexed(ByteBuffer buffer, ObjectStrategy<T> strategy, boolean allowReverseLookup) {
        this.theBuffer = buffer;
        this.strategy = strategy;
        this.allowReverseLookup = allowReverseLookup;
        this.size = this.theBuffer.getInt();
        this.indexOffset = this.theBuffer.position();
        this.valuesOffset = this.theBuffer.position() + (this.size << 2);
        this.bufferIndexed = new BufferIndexed();
    }

    public long getSerializedSize() {
        return this.theBuffer.remaining() + 2 + 4 + 4;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1, this.allowReverseLookup ? (byte)1 : 0}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)(this.theBuffer.remaining() + 4))));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.size)));
        channel.write(this.theBuffer.asReadOnlyBuffer());
    }

    public BufferIndexed singleThreaded() {
        final ByteBuffer copyBuffer = this.theBuffer.asReadOnlyBuffer();
        return new BufferIndexed(){

            @Override
            public T get(int index) {
                return this._get(copyBuffer, index);
            }
        };
    }

    public static <T> GenericIndexed<T> read(ByteBuffer buffer, ObjectStrategy<T> strategy) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            boolean allowReverseLookup = buffer.get() == 1;
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new GenericIndexed<T>(bufferToUse, strategy, allowReverseLookup);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    class BufferIndexed
    implements Indexed<T> {
        int lastReadSize;

        BufferIndexed() {
        }

        @Override
        public Class<? extends T> getClazz() {
            return GenericIndexed.this.strategy.getClazz();
        }

        @Override
        public int size() {
            return GenericIndexed.this.size;
        }

        @Override
        public T get(int index) {
            return this._get(GenericIndexed.this.theBuffer.asReadOnlyBuffer(), index);
        }

        protected T _get(ByteBuffer copyBuffer, int index) {
            int size;
            int endOffset;
            int startOffset;
            if (index < 0) {
                throw new IAE("Index[%s] < 0", new Object[]{index});
            }
            if (index >= GenericIndexed.this.size) {
                throw new IAE(String.format("Index[%s] >= size[%s]", index, GenericIndexed.this.size), new Object[0]);
            }
            if (index == 0) {
                startOffset = 4;
                endOffset = copyBuffer.getInt(GenericIndexed.this.indexOffset);
            } else {
                copyBuffer.position(GenericIndexed.this.indexOffset + (index - 1) * 4);
                startOffset = copyBuffer.getInt() + 4;
                endOffset = copyBuffer.getInt();
            }
            if (startOffset == endOffset) {
                return null;
            }
            copyBuffer.position(GenericIndexed.this.valuesOffset + startOffset);
            this.lastReadSize = size = endOffset - startOffset;
            Object value = GenericIndexed.this.strategy.fromByteBuffer(copyBuffer, size);
            return value;
        }

        public int getLastValueSize() {
            return this.lastReadSize;
        }

        @Override
        public int indexOf(T value) {
            if (!GenericIndexed.this.allowReverseLookup) {
                throw new UnsupportedOperationException("Reverse lookup not allowed.");
            }
            value = value != null && value.equals("") ? null : value;
            int minIndex = 0;
            int maxIndex = GenericIndexed.this.size - 1;
            while (minIndex <= maxIndex) {
                int currIndex = minIndex + maxIndex >>> 1;
                Object currValue = this.get(currIndex);
                int comparison = GenericIndexed.this.strategy.compare(currValue, value);
                if (comparison == 0) {
                    return currIndex;
                }
                if (comparison < 0) {
                    minIndex = currIndex + 1;
                    continue;
                }
                maxIndex = currIndex - 1;
            }
            return -(minIndex + 1);
        }

        @Override
        public Iterator<T> iterator() {
            return IndexedIterable.create(this).iterator();
        }
    }
}

