/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.druid.segment.IndexIO;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.CompressedObjectStrategy;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;

public class IndexSpec {
    public static final String UNCOMPRESSED = "uncompressed";
    public static final String DEFAULT_METRIC_COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY.name().toLowerCase();
    public static final String DEFAULT_DIMENSION_COMPRESSION = CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY.name().toLowerCase();
    private static final Set<String> COMPRESSION_NAMES = Sets.newHashSet((Iterable)Iterables.transform(Arrays.asList(CompressedObjectStrategy.CompressionStrategy.values()), (Function)new Function<CompressedObjectStrategy.CompressionStrategy, String>(){

        @Nullable
        public String apply(CompressedObjectStrategy.CompressionStrategy input) {
            return input.name().toLowerCase();
        }
    }));
    private final BitmapSerdeFactory bitmapSerdeFactory;
    private final String dimensionCompression;
    private final String metricCompression;

    public IndexSpec() {
        this(null, null, null);
    }

    @JsonCreator
    public IndexSpec(@JsonProperty(value="bitmap") BitmapSerdeFactory bitmapSerdeFactory, @JsonProperty(value="dimensionCompression") String dimensionCompression, @JsonProperty(value="metricCompression") String metricCompression) {
        Preconditions.checkArgument((dimensionCompression == null || dimensionCompression.equals(UNCOMPRESSED) || COMPRESSION_NAMES.contains(dimensionCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{dimensionCompression});
        Preconditions.checkArgument((metricCompression == null || COMPRESSION_NAMES.contains(metricCompression) ? 1 : 0) != 0, (String)"Unknown compression type[%s]", (Object[])new Object[]{metricCompression});
        this.bitmapSerdeFactory = bitmapSerdeFactory != null ? bitmapSerdeFactory : IndexIO.CONFIGURED_BITMAP_SERDE_FACTORY;
        this.metricCompression = metricCompression;
        this.dimensionCompression = dimensionCompression;
    }

    @JsonProperty(value="bitmap")
    public BitmapSerdeFactory getBitmapSerdeFactory() {
        return this.bitmapSerdeFactory;
    }

    @JsonProperty(value="dimensionCompression")
    public String getDimensionCompression() {
        return this.dimensionCompression;
    }

    @JsonProperty(value="metricCompression")
    public String getMetricCompression() {
        return this.metricCompression;
    }

    public CompressedObjectStrategy.CompressionStrategy getMetricCompressionStrategy() {
        return CompressedObjectStrategy.CompressionStrategy.valueOf((this.metricCompression == null ? DEFAULT_METRIC_COMPRESSION : this.metricCompression).toUpperCase());
    }

    public CompressedObjectStrategy.CompressionStrategy getDimensionCompressionStrategy() {
        return this.dimensionCompression == null ? IndexSpec.dimensionCompressionStrategyForName(DEFAULT_DIMENSION_COMPRESSION) : IndexSpec.dimensionCompressionStrategyForName(this.dimensionCompression);
    }

    private static CompressedObjectStrategy.CompressionStrategy dimensionCompressionStrategyForName(String compression) {
        return compression.equals(UNCOMPRESSED) ? null : CompressedObjectStrategy.CompressionStrategy.valueOf(compression.toUpperCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSpec indexSpec = (IndexSpec)o;
        if (this.bitmapSerdeFactory != null ? !this.bitmapSerdeFactory.equals(indexSpec.bitmapSerdeFactory) : indexSpec.bitmapSerdeFactory != null) {
            return false;
        }
        if (this.dimensionCompression != null ? !this.dimensionCompression.equals(indexSpec.dimensionCompression) : indexSpec.dimensionCompression != null) {
            return false;
        }
        return !(this.metricCompression == null ? indexSpec.metricCompression != null : !this.metricCompression.equals(indexSpec.metricCompression));
    }

    public int hashCode() {
        int result = this.bitmapSerdeFactory != null ? this.bitmapSerdeFactory.hashCode() : 0;
        result = 31 * result + (this.dimensionCompression != null ? this.dimensionCompression.hashCode() : 0);
        result = 31 * result + (this.metricCompression != null ? this.metricCompression.hashCode() : 0);
        return result;
    }
}

