/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.MergeIterable;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.common.io.smoosh.Smoosh;
import com.metamx.common.logger.Logger;
import io.druid.collections.CombiningIterable;
import io.druid.common.guava.FileOutputSupplier;
import io.druid.common.guava.GuavaUtils;
import io.druid.common.utils.JodaUtils;
import io.druid.common.utils.SerializerUtils;
import io.druid.guice.GuiceInjectors;
import io.druid.guice.JsonConfigProvider;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.BaseProgressIndicator;
import io.druid.segment.FloatMetricColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.LongMetricColumnSerializer;
import io.druid.segment.MetricColumnSerializer;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferWriter;
import io.druid.segment.data.CompressedLongsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.TmpFileIOPeon;
import io.druid.segment.data.VSizeIndexedWriter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.serde.ComplexMetricColumnSerializer;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMerger {
    private static final Logger log = new Logger(IndexMerger.class);
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private static final int INVALID_ROW = -1;
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private static final ObjectMapper mapper;

    public static File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMerger.persist(index, index.getInterval(), outDir, indexSpec);
    }

    public static File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMerger.persist(index, dataInterval, outDir, indexSpec, new BaseProgressIndicator());
    }

    public static File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        long firstTimestamp = index.getMinTime().getMillis();
        long lastTimestamp = index.getMaxTime().getMillis();
        if (!dataInterval.contains(firstTimestamp) || !dataInterval.contains(lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", new Object[]{dataInterval, new DateTime(firstTimestamp), new DateTime(lastTimestamp)});
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new ISE("Can only persist to directories, [%s] wasn't a directory", new Object[]{outDir});
        }
        log.info("Starting persist for interval[%s], rows[%,d]", new Object[]{dataInterval, index.size()});
        return IndexMerger.merge(Arrays.asList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), index.getMetricAggs(), outDir, indexSpec, progress);
    }

    public static File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMerger.mergeQueryableIndex(indexes, metricAggs, outDir, indexSpec, new BaseProgressIndicator());
    }

    public static File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        return IndexMerger.merge(Lists.transform(indexes, (Function)new Function<QueryableIndex, IndexableAdapter>(){

            public IndexableAdapter apply(QueryableIndex input) {
                return new QueryableIndexIndexableAdapter(input);
            }
        }), metricAggs, outDir, indexSpec, progress);
    }

    public static File merge(List<IndexableAdapter> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMerger.merge(indexes, metricAggs, outDir, indexSpec, new BaseProgressIndicator());
    }

    public static File merge(List<IndexableAdapter> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        int i;
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", new Object[]{outDir});
        }
        ArrayList<String> mergedDimensions = IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
        List mergedMetrics = Lists.transform(IndexMerger.mergeIndexed(Lists.newArrayList((Iterable)FunctionalIterable.create(indexes).transform((Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getMetricNames();
            }
        }).concat(new Iterable[]{Arrays.asList(new AggFactoryStringIndexed(metricAggs))}))), (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return input;
            }
        });
        if (mergedMetrics.size() != metricAggs.length) {
            throw new IAE("Bad number of metrics[%d], expected [%d]", new Object[]{mergedMetrics.size(), metricAggs.length});
        }
        final AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (i = 0; i < metricAggs.length; ++i) {
            AggregatorFactory metricAgg;
            sortedMetricAggs[mergedMetrics.indexOf((Object)metricAgg.getName())] = metricAgg = metricAggs[i];
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", new Object[]{i, metricAggs[i].getName(), mergedMetrics.get(i)});
        }
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                return CombiningIterable.create((Iterable)new MergeIterable((Comparator)Ordering.natural().nullsFirst(), boats), (Comparator)Ordering.natural().nullsFirst(), (BinaryFn)new RowboatMergeFunction(sortedMetricAggs));
            }
        };
        return IndexMerger.makeIndexFiles(indexes, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    public static File convert(File inDir, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMerger.convert(inDir, outDir, indexSpec, new BaseProgressIndicator());
    }

    public static File convert(File inDir, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        try (QueryableIndex index = IndexIO.loadIndex(inDir);){
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
            File file = IndexMerger.makeIndexFiles((List<IndexableAdapter>)ImmutableList.of((Object)adapter), outDir, progress, Lists.newArrayList(adapter.getDimensionNames()), Lists.newArrayList(adapter.getMetricNames()), new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

                @Nullable
                public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> input) {
                    return input.get(0);
                }
            }, indexSpec);
            return file;
        }
    }

    public static File append(List<IndexableAdapter> indexes, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMerger.append(indexes, outDir, indexSpec, new BaseProgressIndicator());
    }

    public static File append(List<IndexableAdapter> indexes, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", new Object[]{outDir});
        }
        ArrayList<String> mergedDimensions = IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return Iterables.transform(input.getDimensionNames(), (Function)new Function<String, String>(){

                    public String apply(@Nullable String input) {
                        return input;
                    }
                });
            }
        }));
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return Iterables.transform(input.getMetricNames(), (Function)new Function<String, String>(){

                    public String apply(@Nullable String input) {
                        return input;
                    }
                });
            }
        }));
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                return new MergeIterable((Comparator)Ordering.natural().nullsFirst(), boats);
            }
        };
        return IndexMerger.makeIndexFiles(indexes, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File makeIndexFiles(List<IndexableAdapter> indexes, File outDir, ProgressIndicator progress, final List<String> mergedDimensions, final List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec) throws IOException {
        Interval dataInterval;
        TreeMap valueTypes = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
        TreeMap metricTypeNames = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
        HashMap columnCapabilities = Maps.newHashMap();
        for (IndexableAdapter adapter : indexes) {
            ColumnCapabilities capabilities;
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(dimension);
                capabilities = adapter.getCapabilities(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                    mergedCapabilities.setType(ValueType.STRING);
                }
                columnCapabilities.put(dimension, mergedCapabilities.merge(capabilities));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(metric);
                capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                columnCapabilities.put(metric, mergedCapabilities.merge(capabilities));
                valueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        File v8OutDir = new File(outDir, "v8-tmp");
        v8OutDir.mkdirs();
        progress.progress();
        long startTime = System.currentTimeMillis();
        File indexFile = new File(v8OutDir, "index.drd");
        FileOutputStream fileOutputStream = null;
        FileChannel channel = null;
        try {
            fileOutputStream = new FileOutputStream(indexFile);
            channel = fileOutputStream.getChannel();
            channel.write(ByteBuffer.wrap(new byte[]{8}));
            GenericIndexed.fromIterable(mergedDimensions, GenericIndexed.STRING_STRATEGY).writeToChannel(channel);
            GenericIndexed.fromIterable(mergedMetrics, GenericIndexed.STRING_STRATEGY).writeToChannel(channel);
            DateTime minTime = new DateTime(0x3FFFFFFFFFFFFFFFL);
            DateTime maxTime = new DateTime(-4611686018427387904L);
            for (IndexableAdapter index : indexes) {
                minTime = JodaUtils.minDateTime((DateTime[])new DateTime[]{minTime, index.getDataInterval().getStart()});
                maxTime = JodaUtils.maxDateTime((DateTime[])new DateTime[]{maxTime, index.getDataInterval().getEnd()});
            }
            dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
            serializerUtils.writeString((WritableByteChannel)channel, String.format("%s/%s", minTime, maxTime));
            serializerUtils.writeString((WritableByteChannel)channel, mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory()));
        }
        catch (Throwable throwable) {
            CloseQuietly.close(channel);
            channel = null;
            CloseQuietly.close((Closeable)fileOutputStream);
            fileOutputStream = null;
            throw throwable;
        }
        CloseQuietly.close((Closeable)channel);
        channel = null;
        CloseQuietly.close((Closeable)fileOutputStream);
        fileOutputStream = null;
        IndexIO.checkFileSize(indexFile);
        log.info("outDir[%s] completed index.drd in %,d millis.", new Object[]{v8OutDir, System.currentTimeMillis() - startTime});
        progress.progress();
        startTime = System.currentTimeMillis();
        TmpFileIOPeon ioPeon = new TmpFileIOPeon();
        ArrayList dimOuts = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
        HashMap dimensionCardinalities = Maps.newHashMap();
        ArrayList dimConversions = Lists.newArrayListWithCapacity((int)indexes.size());
        for (IndexableAdapter index : indexes) {
            dimConversions.add(Maps.newHashMap());
        }
        for (String dimension : mergedDimensions) {
            GenericIndexedWriter<String> writer = new GenericIndexedWriter<String>(ioPeon, dimension, GenericIndexed.STRING_STRATEGY);
            writer.open();
            ArrayList dimValueLookups = Lists.newArrayListWithCapacity((int)indexes.size());
            DimValueConverter[] converters = new DimValueConverter[indexes.size()];
            for (int i = 0; i < indexes.size(); ++i) {
                Indexed<String> dimValues = indexes.get(i).getDimValueLookup(dimension);
                if (IndexMerger.isNullColumn(dimValues)) continue;
                dimValueLookups.add(dimValues);
                converters[i] = new DimValueConverter(dimValues);
            }
            CombiningIterable dimensionValues = CombiningIterable.createSplatted((Iterable)Iterables.transform((Iterable)dimValueLookups, (Function)new Function<Indexed<String>, Iterable<String>>(){

                public Iterable<String> apply(@Nullable Indexed<String> indexed) {
                    return Iterables.transform(indexed, (Function)new Function<String, String>(){

                        public String apply(@Nullable String input) {
                            return input == null ? "" : input;
                        }
                    });
                }
            }), (Comparator)Ordering.natural().nullsFirst());
            int count = 0;
            for (String value : dimensionValues) {
                value = value == null ? "" : value;
                writer.write(value);
                for (int i = 0; i < indexes.size(); ++i) {
                    DimValueConverter converter = converters[i];
                    if (converter == null) continue;
                    converter.convert(value, count);
                }
                ++count;
            }
            dimensionCardinalities.put(dimension, count);
            FileOutputSupplier dimOut = new FileOutputSupplier(IndexIO.makeDimFile(v8OutDir, dimension), true);
            dimOuts.add(dimOut);
            writer.close();
            serializerUtils.writeString((OutputSupplier)dimOut, dimension);
            ByteStreams.copy(writer.combineStreams(), (OutputSupplier)dimOut);
            for (int i = 0; i < indexes.size(); ++i) {
                DimValueConverter converter = converters[i];
                if (converter == null) continue;
                ((Map)dimConversions.get(i)).put(dimension, converters[i].getConversionBuffer());
            }
            ioPeon.cleanup();
        }
        log.info("outDir[%s] completed dim conversions in %,d millis.", new Object[]{v8OutDir, System.currentTimeMillis() - startTime});
        progress.progress();
        startTime = System.currentTimeMillis();
        ArrayList boats = Lists.newArrayListWithCapacity((int)indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            final int[] dimLookup = new int[mergedDimensions.size()];
            int count = 0;
            for (String dim : adapter.getDimensionNames()) {
                dimLookup[count] = mergedDimensions.indexOf(dim);
                ++count;
            }
            final int[] metricLookup = new int[mergedMetrics.size()];
            count = 0;
            for (String metric : adapter.getMetricNames()) {
                metricLookup[count] = mergedMetrics.indexOf(metric);
                ++count;
            }
            boats.add(new MMappedIndexRowIterable(Iterables.transform(indexes.get(i).getRows(), (Function)new Function<Rowboat, Rowboat>(){

                public Rowboat apply(@Nullable Rowboat input) {
                    int[][] newDims = new int[mergedDimensions.size()][];
                    int j = 0;
                    for (int[] dim : input.getDims()) {
                        newDims[dimLookup[j]] = dim;
                        ++j;
                    }
                    Object[] newMetrics = new Object[mergedMetrics.size()];
                    j = 0;
                    Object[] arr$ = input.getMetrics();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Object met;
                        newMetrics[metricLookup[j]] = met = arr$[i$];
                        ++j;
                    }
                    return new Rowboat(input.getTimestamp(), newDims, newMetrics, input.getRowNum());
                }
            }), mergedDimensions, (Map)dimConversions.get(i), i));
        }
        Iterable theRows = (Iterable)rowMergerFn.apply((Object)boats);
        CompressedLongsSupplierSerializer timeWriter = CompressedLongsSupplierSerializer.create(ioPeon, "little_end_time", IndexIO.BYTE_ORDER, CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY);
        timeWriter.open();
        ArrayList forwardDimWriters = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
        for (String dimension : mergedDimensions) {
            VSizeIndexedWriter writer = new VSizeIndexedWriter(ioPeon, dimension, (Integer)dimensionCardinalities.get(dimension));
            writer.open();
            forwardDimWriters.add(writer);
        }
        ArrayList metWriters = Lists.newArrayListWithCapacity((int)mergedMetrics.size());
        block21: for (String metric : mergedMetrics) {
            ValueType type = (ValueType)((Object)valueTypes.get(metric));
            switch (type) {
                case LONG: {
                    metWriters.add(new LongMetricColumnSerializer(metric, v8OutDir, ioPeon));
                    continue block21;
                }
                case FLOAT: {
                    metWriters.add(new FloatMetricColumnSerializer(metric, v8OutDir, ioPeon));
                    continue block21;
                }
                case COMPLEX: {
                    String typeName = (String)metricTypeNames.get(metric);
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", new Object[]{typeName});
                    }
                    metWriters.add(new ComplexMetricColumnSerializer(metric, v8OutDir, ioPeon, serde));
                    continue block21;
                }
            }
            throw new ISE("Unknown type[%s]", new Object[]{type});
        }
        for (MetricColumnSerializer metWriter : metWriters) {
            metWriter.open();
        }
        int rowCount = 0;
        long time = System.currentTimeMillis();
        ArrayList rowNumConversions = Lists.newArrayListWithCapacity((int)indexes.size());
        for (IndexableAdapter index : indexes) {
            int[] arr = new int[index.getNumRows()];
            Arrays.fill(arr, -1);
            rowNumConversions.add(IntBuffer.wrap(arr));
        }
        for (Rowboat theRow : theRows) {
            progress.progress();
            timeWriter.add(theRow.getTimestamp());
            Object[] metrics = theRow.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                ((MetricColumnSerializer)metWriters.get(i)).serialize(metrics[i]);
            }
            int[][] dims = theRow.getDims();
            for (int i = 0; i < dims.length; ++i) {
                List listToWrite = i >= dims.length || dims[i] == null ? null : Ints.asList((int[])dims[i]);
                ((VSizeIndexedWriter)forwardDimWriters.get(i)).write(listToWrite);
            }
            for (Map.Entry<Integer, TreeSet<Integer>> comprisedRow : theRow.getComprisedRows().entrySet()) {
                IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(comprisedRow.getKey());
                for (Integer rowNum : comprisedRow.getValue()) {
                    while (conversionBuffer.position() < rowNum) {
                        conversionBuffer.put(-1);
                    }
                    conversionBuffer.put(rowCount);
                }
            }
            if (++rowCount % 500000 != 0) continue;
            log.info("outDir[%s] walked 500,000/%,d rows in %,d millis.", new Object[]{v8OutDir, rowCount, System.currentTimeMillis() - time});
            time = System.currentTimeMillis();
        }
        for (IntBuffer rowNumConversion : rowNumConversions) {
            rowNumConversion.rewind();
        }
        File timeFile = IndexIO.makeTimeFile(v8OutDir, IndexIO.BYTE_ORDER);
        timeFile.delete();
        OutputSupplier out = Files.newOutputStreamSupplier((File)timeFile, (boolean)true);
        timeWriter.closeAndConsolidate((OutputSupplier<? extends OutputStream>)out);
        IndexIO.checkFileSize(timeFile);
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            ((VSizeIndexedWriter)forwardDimWriters.get(i)).close();
            ByteStreams.copy(((VSizeIndexedWriter)forwardDimWriters.get(i)).combineStreams(), (OutputSupplier)((OutputSupplier)dimOuts.get(i)));
        }
        for (MetricColumnSerializer metWriter : metWriters) {
            metWriter.close();
        }
        ioPeon.cleanup();
        log.info("outDir[%s] completed walk through of %,d rows in %,d millis.", new Object[]{v8OutDir, rowCount, System.currentTimeMillis() - startTime});
        startTime = System.currentTimeMillis();
        File invertedFile = new File(v8OutDir, "inverted.drd");
        Files.touch((File)invertedFile);
        out = Files.newOutputStreamSupplier((File)invertedFile, (boolean)true);
        File geoFile = new File(v8OutDir, "spatial.drd");
        Files.touch((File)geoFile);
        OutputSupplier spatialOut = Files.newOutputStreamSupplier((File)geoFile, (boolean)true);
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            File dimOutFile;
            MappedByteBuffer dimValsMapped;
            long dimStartTime = System.currentTimeMillis();
            String dimension = mergedDimensions.get(i);
            if (!dimension.equals(serializerUtils.readString((ByteBuffer)(dimValsMapped = Files.map((File)(dimOutFile = ((FileOutputSupplier)dimOuts.get(i)).getFile())))))) {
                throw new ISE("dimensions[%s] didn't equate!?  This is a major WTF moment.", new Object[]{dimension});
            }
            GenericIndexed<String> dimVals = GenericIndexed.read(dimValsMapped, GenericIndexed.STRING_STRATEGY);
            log.info("Starting dimension[%s] with cardinality[%,d]", new Object[]{dimension, dimVals.size()});
            BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
            GenericIndexedWriter<ImmutableBitmap> writer = new GenericIndexedWriter<ImmutableBitmap>(ioPeon, dimension, bitmapSerdeFactory.getObjectStrategy());
            writer.open();
            boolean isSpatialDim = ((ColumnCapabilitiesImpl)columnCapabilities.get(dimension)).hasSpatialIndexes();
            ByteBufferWriter<ImmutableRTree> spatialWriter = null;
            RTree tree = null;
            TmpFileIOPeon spatialIoPeon = new TmpFileIOPeon();
            if (isSpatialDim) {
                BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
                spatialWriter = new ByteBufferWriter<ImmutableRTree>(spatialIoPeon, dimension, new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapFactory));
                spatialWriter.open();
                tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, bitmapFactory), bitmapFactory);
            }
            for (String dimVal : IndexedIterable.create(dimVals)) {
                progress.progress();
                ArrayList convertedInverteds = Lists.newArrayListWithCapacity((int)indexes.size());
                for (int j = 0; j < indexes.size(); ++j) {
                    convertedInverteds.add(new ConvertingIndexedInts(indexes.get(j).getBitmapIndex(dimension, dimVal), (IntBuffer)rowNumConversions.get(j)));
                }
                MutableBitmap bitset = bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
                for (Integer row : CombiningIterable.createSplatted((Iterable)convertedInverteds, (Comparator)Ordering.natural().nullsFirst())) {
                    if (row == -1) continue;
                    bitset.add(row.intValue());
                }
                writer.write(bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(bitset));
                if (!isSpatialDim || dimVal == null) continue;
                ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                float[] coords = new float[stringCoords.size()];
                for (int j = 0; j < coords.length; ++j) {
                    coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                }
                tree.insert(coords, bitset);
            }
            writer.close();
            serializerUtils.writeString(out, dimension);
            ByteStreams.copy(writer.combineStreams(), (OutputSupplier)out);
            ioPeon.cleanup();
            log.info("Completed dimension[%s] in %,d millis.", new Object[]{dimension, System.currentTimeMillis() - dimStartTime});
            if (!isSpatialDim) continue;
            spatialWriter.write(ImmutableRTree.newImmutableFromMutable((RTree)tree));
            spatialWriter.close();
            serializerUtils.writeString(spatialOut, dimension);
            ByteStreams.copy(spatialWriter.combineStreams(), (OutputSupplier)spatialOut);
            spatialIoPeon.cleanup();
        }
        log.info("outDir[%s] completed inverted.drd in %,d millis.", new Object[]{v8OutDir, System.currentTimeMillis() - startTime});
        ArrayList expectedFiles = Lists.newArrayList((Iterable)Iterables.concat(Arrays.asList("index.drd", "inverted.drd", "spatial.drd", String.format("time_%s.drd", IndexIO.BYTE_ORDER)), (Iterable)Iterables.transform(mergedDimensions, (Function)GuavaUtils.formatFunction((String)"dim_%s.drd")), (Iterable)Iterables.transform(mergedMetrics, (Function)GuavaUtils.formatFunction((String)String.format("met_%%s_%s.drd", IndexIO.BYTE_ORDER)))));
        LinkedHashMap files = Maps.newLinkedHashMap();
        for (String fileName : expectedFiles) {
            files.put(fileName, new File(v8OutDir, fileName));
        }
        File smooshDir = new File(v8OutDir, "smoosher");
        smooshDir.mkdir();
        for (Map.Entry entry : Smoosh.smoosh((File)v8OutDir, (File)smooshDir, (Map)files).entrySet()) {
            ((File)entry.getValue()).delete();
        }
        for (File file : smooshDir.listFiles()) {
            Files.move((File)file, (File)new File(v8OutDir, file.getName()));
        }
        if (!smooshDir.delete()) {
            log.info("Unable to delete temporary dir[%s], contains[%s]", new Object[]{smooshDir, Arrays.asList(smooshDir.listFiles())});
            throw new IOException(String.format("Unable to delete temporary dir[%s]", smooshDir));
        }
        IndexMerger.createIndexDrdFile((byte)8, v8OutDir, GenericIndexed.fromIterable(mergedDimensions, GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable(mergedMetrics, GenericIndexed.STRING_STRATEGY), dataInterval, indexSpec.getBitmapSerdeFactory());
        IndexIO.DefaultIndexIOHandler.convertV8toV9(v8OutDir, outDir, indexSpec);
        FileUtils.deleteDirectory((File)v8OutDir);
        return outDir;
    }

    private static <T extends Comparable> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet retVal = Sets.newTreeSet((Comparator)Ordering.natural().nullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList((Iterable)retVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createIndexDrdFile(byte versionId, File inDir, GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, BitmapSerdeFactory bitmapSerdeFactory) throws IOException {
        File indexFile = new File(inDir, "index.drd");
        FileChannel channel = null;
        try {
            channel = new FileOutputStream(indexFile).getChannel();
            channel.write(ByteBuffer.wrap(new byte[]{versionId}));
            availableDimensions.writeToChannel(channel);
            availableMetrics.writeToChannel(channel);
            serializerUtils.writeString((WritableByteChannel)channel, String.format("%s/%s", dataInterval.getStart(), dataInterval.getEnd()));
            serializerUtils.writeString((WritableByteChannel)channel, mapper.writeValueAsString((Object)bitmapSerdeFactory));
        }
        catch (Throwable throwable) {
            CloseQuietly.close(channel);
            channel = null;
            throw throwable;
        }
        CloseQuietly.close((Closeable)channel);
        channel = null;
        IndexIO.checkFileSize(indexFile);
    }

    static boolean isNullColumn(Iterable<String> dimValues) {
        if (dimValues == null) {
            return true;
        }
        for (String val : dimValues) {
            if (val == null) continue;
            return false;
        }
        return true;
    }

    static {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable<? extends Module>)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.processing.bitmap", BitmapSerdeFactory.class);
            }
        }));
        mapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    private static class RowboatMergeFunction
    implements BinaryFn<Rowboat, Rowboat, Rowboat> {
        private final AggregatorFactory[] metricAggs;

        public RowboatMergeFunction(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        public Rowboat apply(Rowboat lhs, Rowboat rhs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            Object[] metrics = new Object[this.metricAggs.length];
            Object[] lhsMetrics = lhs.getMetrics();
            Object[] rhsMetrics = rhs.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                metrics[i] = this.metricAggs[i].combine(lhsMetrics[i], rhsMetrics[i]);
            }
            Rowboat retVal = new Rowboat(lhs.getTimestamp(), lhs.getDims(), metrics, lhs.getRowNum());
            for (Rowboat rowboat : Arrays.asList(lhs, rhs)) {
                for (Map.Entry<Integer, TreeSet<Integer>> entry : rowboat.getComprisedRows().entrySet()) {
                    for (Integer rowNum : entry.getValue()) {
                        retVal.addRow(entry.getKey(), rowNum);
                    }
                }
            }
            return retVal;
        }
    }

    private static class AggFactoryStringIndexed
    implements Indexed<String> {
        private final AggregatorFactory[] metricAggs;

        public AggFactoryStringIndexed(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public int size() {
            return this.metricAggs.length;
        }

        @Override
        public String get(int index) {
            return this.metricAggs[index].getName();
        }

        @Override
        public int indexOf(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return IndexedIterable.create(this).iterator();
        }
    }

    private static class MMappedIndexRowIterable
    implements Iterable<Rowboat> {
        private final Iterable<Rowboat> index;
        private final List<String> convertedDims;
        private final Map<String, IntBuffer> converters;
        private final int indexNumber;

        MMappedIndexRowIterable(Iterable<Rowboat> index, List<String> convertedDims, Map<String, IntBuffer> converters, int indexNumber) {
            this.index = index;
            this.convertedDims = convertedDims;
            this.converters = converters;
            this.indexNumber = indexNumber;
        }

        public Iterable<Rowboat> getIndex() {
            return this.index;
        }

        public List<String> getConvertedDims() {
            return this.convertedDims;
        }

        public Map<String, IntBuffer> getConverters() {
            return this.converters;
        }

        public int getIndexNumber() {
            return this.indexNumber;
        }

        @Override
        public Iterator<Rowboat> iterator() {
            return Iterators.transform(this.index.iterator(), (Function)new Function<Rowboat, Rowboat>(){
                int rowCount = 0;

                public Rowboat apply(@Nullable Rowboat input) {
                    int[][] dims = input.getDims();
                    int[][] newDims = new int[MMappedIndexRowIterable.this.convertedDims.size()][];
                    for (int i = 0; i < MMappedIndexRowIterable.this.convertedDims.size(); ++i) {
                        IntBuffer converter = (IntBuffer)MMappedIndexRowIterable.this.converters.get(MMappedIndexRowIterable.this.convertedDims.get(i));
                        if (converter == null || i >= dims.length || dims[i] == null) continue;
                        newDims[i] = new int[dims[i].length];
                        for (int j = 0; j < dims[i].length; ++j) {
                            if (!converter.hasRemaining()) {
                                log.error("Converter mismatch! wtfbbq!", new Object[0]);
                            }
                            newDims[i][j] = converter.get(dims[i][j]);
                        }
                    }
                    Rowboat retVal = new Rowboat(input.getTimestamp(), newDims, input.getMetrics(), input.getRowNum());
                    retVal.addRow(MMappedIndexRowIterable.this.indexNumber, input.getRowNum());
                    return retVal;
                }
            });
        }
    }

    private static class ConvertingIndexedInts
    implements Iterable<Integer> {
        private final IndexedInts baseIndex;
        private final IntBuffer conversionBuffer;

        public ConvertingIndexedInts(IndexedInts baseIndex, IntBuffer conversionBuffer) {
            this.baseIndex = baseIndex;
            this.conversionBuffer = conversionBuffer;
        }

        public int size() {
            return this.baseIndex.size();
        }

        public int get(int index) {
            return this.conversionBuffer.get(this.baseIndex.get(index));
        }

        @Override
        public Iterator<Integer> iterator() {
            return Iterators.transform(this.baseIndex.iterator(), (Function)new Function<Integer, Integer>(){

                public Integer apply(@Nullable Integer input) {
                    return ConvertingIndexedInts.this.conversionBuffer.get(input);
                }
            });
        }
    }

    private static class DimValueConverter {
        private final Indexed<String> dimSet;
        private final IntBuffer conversionBuf;
        private int currIndex;
        private String lastVal = null;

        DimValueConverter(Indexed<String> dimSet) {
            this.dimSet = dimSet;
            this.conversionBuf = ByteBuffer.allocateDirect(dimSet.size() * 4).asIntBuffer();
            this.currIndex = 0;
        }

        public void convert(String value, int index) {
            if (this.dimSet.size() == 0) {
                return;
            }
            if (this.lastVal != null) {
                if (value.compareTo(this.lastVal) <= 0) {
                    throw new ISE("Value[%s] is less than the last value[%s] I have, cannot be.", new Object[]{value, this.lastVal});
                }
                return;
            }
            String currValue = this.dimSet.get(this.currIndex);
            while (currValue == null) {
                this.conversionBuf.position(this.conversionBuf.position() + 1);
                ++this.currIndex;
                if (this.currIndex == this.dimSet.size()) {
                    this.lastVal = value;
                    return;
                }
                currValue = this.dimSet.get(this.currIndex);
            }
            if (Objects.equal((Object)currValue, (Object)value)) {
                this.conversionBuf.put(index);
                ++this.currIndex;
                if (this.currIndex == this.dimSet.size()) {
                    this.lastVal = value;
                }
            } else if (currValue.compareTo(value) < 0) {
                throw new ISE("Skipped currValue[%s], currIndex[%,d]; incoming value[%s], index[%,d]", new Object[]{currValue, this.currIndex, value, index});
            }
        }

        public IntBuffer getConversionBuffer() {
            if (this.currIndex != this.conversionBuf.limit() || this.conversionBuf.hasRemaining()) {
                throw new ISE("Asked for incomplete buffer.  currIndex[%,d] != buf.limit[%,d]", new Object[]{this.currIndex, this.conversionBuf.limit()});
            }
            return (IntBuffer)this.conversionBuf.asReadOnlyBuffer().rewind();
        }
    }
}

