/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.MergeIterable;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.common.io.smoosh.FileSmoosher;
import com.metamx.common.io.smoosh.SmooshedWriter;
import com.metamx.common.logger.Logger;
import io.druid.collections.CombiningIterable;
import io.druid.common.utils.JodaUtils;
import io.druid.common.utils.SerializerUtils;
import io.druid.guice.GuiceInjectors;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.BaseProgressIndicator;
import io.druid.segment.CompressedVSizeIndexedSupplier;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.LoggingProgressIndicator;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ColumnDescriptor;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.ComplexColumnPartSerde;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import io.druid.segment.serde.FloatGenericColumnPartSerde;
import io.druid.segment.serde.LongGenericColumnPartSerde;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMaker {
    private static final Logger log = new Logger(IndexMaker.class);
    private static final SerializerUtils serializerUtils = new SerializerUtils();
    private static final int INVALID_ROW = -1;
    private static final Splitter SPLITTER = Splitter.on((String)",");
    private static final ObjectMapper mapper;

    public static File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMaker.persist(index, index.getInterval(), outDir, indexSpec);
    }

    public static File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMaker.persist(index, dataInterval, outDir, indexSpec, new LoggingProgressIndicator(outDir.toString()));
    }

    public static File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        long firstTimestamp = index.getMinTime().getMillis();
        long lastTimestamp = index.getMaxTime().getMillis();
        if (!dataInterval.contains(firstTimestamp) || !dataInterval.contains(lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", new Object[]{dataInterval, new DateTime(firstTimestamp), new DateTime(lastTimestamp)});
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new ISE("Can only persist to directories, [%s] wasn't a directory", new Object[]{outDir});
        }
        log.info("Starting persist for interval[%s], rows[%,d]", new Object[]{dataInterval, index.size()});
        return IndexMaker.merge(Arrays.asList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), index.getMetricAggs(), outDir, indexSpec, progress);
    }

    public static File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMaker.mergeQueryableIndex(indexes, metricAggs, outDir, indexSpec, new LoggingProgressIndicator(outDir.toString()));
    }

    public static File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        return IndexMaker.merge(Lists.transform(indexes, (Function)new Function<QueryableIndex, IndexableAdapter>(){

            public IndexableAdapter apply(QueryableIndex input) {
                return new QueryableIndexIndexableAdapter(input);
            }
        }), metricAggs, outDir, indexSpec, progress);
    }

    public static File merge(List<IndexableAdapter> adapters, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMaker.merge(adapters, metricAggs, outDir, indexSpec, new LoggingProgressIndicator(outDir.toString()));
    }

    public static File merge(List<IndexableAdapter> adapters, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        int i;
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", new Object[]{outDir});
        }
        ArrayList<String> mergedDimensions = IndexMaker.mergeIndexed(Lists.transform(adapters, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
        List mergedMetrics = Lists.transform(IndexMaker.mergeIndexed(Lists.newArrayList((Iterable)FunctionalIterable.create(adapters).transform((Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(IndexableAdapter input) {
                return input.getMetricNames();
            }
        }).concat(new Iterable[]{Arrays.asList(new AggFactoryStringIndexed(metricAggs))}))), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input;
            }
        });
        if (mergedMetrics.size() != metricAggs.length) {
            throw new IAE("Bad number of metrics[%d], expected [%d]", new Object[]{mergedMetrics.size(), metricAggs.length});
        }
        final AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (i = 0; i < metricAggs.length; ++i) {
            AggregatorFactory metricAgg;
            sortedMetricAggs[mergedMetrics.indexOf((Object)metricAgg.getName())] = metricAgg = metricAggs[i];
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", new Object[]{i, metricAggs[i].getName(), mergedMetrics.get(i)});
        }
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> boats) {
                return CombiningIterable.create((Iterable)new MergeIterable((Comparator)Ordering.natural().nullsFirst(), boats), (Comparator)Ordering.natural().nullsFirst(), (BinaryFn)new RowboatMergeFunction(sortedMetricAggs));
            }
        };
        return IndexMaker.makeIndexFiles(adapters, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    public static File convert(File inDir, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMaker.convert(inDir, outDir, indexSpec, new BaseProgressIndicator());
    }

    public static File convert(File inDir, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        try (QueryableIndex index = IndexIO.loadIndex(inDir);){
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
            File file = IndexMaker.makeIndexFiles((List<IndexableAdapter>)ImmutableList.of((Object)adapter), outDir, progress, Lists.newArrayList(adapter.getDimensionNames()), Lists.newArrayList(adapter.getMetricNames()), new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

                @Nullable
                public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> input) {
                    return input.get(0);
                }
            }, indexSpec);
            return file;
        }
    }

    public static File append(List<IndexableAdapter> adapters, File outDir, IndexSpec indexSpec) throws IOException {
        return IndexMaker.append(adapters, outDir, new LoggingProgressIndicator(outDir.toString()), indexSpec);
    }

    public static File append(List<IndexableAdapter> adapters, File outDir, ProgressIndicator progress, IndexSpec indexSpec) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", new Object[]{outDir});
        }
        ArrayList<String> mergedDimensions = IndexMaker.mergeIndexed(Lists.transform(adapters, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(IndexableAdapter input) {
                return Iterables.transform(input.getDimensionNames(), (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return input;
                    }
                });
            }
        }));
        ArrayList<String> mergedMetrics = IndexMaker.mergeIndexed(Lists.transform(adapters, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(IndexableAdapter input) {
                return Iterables.transform(input.getMetricNames(), (Function)new Function<String, String>(){

                    public String apply(String input) {
                        return input;
                    }
                });
            }
        }));
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> boats) {
                return new MergeIterable((Comparator)Ordering.natural().nullsFirst(), boats);
            }
        };
        return IndexMaker.makeIndexFiles(adapters, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    private static File makeIndexFiles(List<IndexableAdapter> adapters, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec) throws IOException {
        progress.start();
        progress.progress();
        TreeMap valueTypes = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
        TreeMap metricTypeNames = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
        HashMap columnCapabilities = Maps.newHashMap();
        for (IndexableAdapter adapter : adapters) {
            ColumnCapabilities capabilities;
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(dimension);
                capabilities = adapter.getCapabilities(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                    mergedCapabilities.setType(ValueType.STRING);
                }
                columnCapabilities.put(dimension, mergedCapabilities.merge(capabilities));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(metric);
                capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                columnCapabilities.put(metric, mergedCapabilities.merge(capabilities));
                valueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        outDir.mkdirs();
        FileSmoosher v9Smoosher = new FileSmoosher(outDir);
        ByteStreams.write((byte[])Ints.toByteArray((int)9), (OutputSupplier)Files.newOutputStreamSupplier((File)new File(outDir, "version.bin")));
        HashMap dimIndexes = Maps.newHashMap();
        HashMap dimensionValuesLookup = Maps.newHashMap();
        ArrayList dimConversions = Lists.newArrayListWithCapacity((int)adapters.size());
        HashSet skippedDimensions = Sets.newHashSet();
        ArrayList rowNumConversions = Lists.newArrayListWithCapacity((int)adapters.size());
        progress.progress();
        IndexMaker.setupDimConversion(adapters, progress, mergedDimensions, dimConversions, dimIndexes, skippedDimensions, dimensionValuesLookup);
        progress.progress();
        Iterable<Rowboat> theRows = IndexMaker.makeRowIterable(adapters, mergedDimensions, mergedMetrics, dimConversions, rowMergerFn);
        progress.progress();
        int rowCount = IndexMaker.convertDims(adapters, progress, theRows, rowNumConversions);
        progress.progress();
        IndexMaker.makeTimeColumn(v9Smoosher, progress, theRows, rowCount);
        progress.progress();
        IndexMaker.makeDimColumns(v9Smoosher, adapters, progress, mergedDimensions, skippedDimensions, theRows, columnCapabilities, dimensionValuesLookup, rowNumConversions, indexSpec);
        progress.progress();
        IndexMaker.makeMetricColumns(v9Smoosher, progress, theRows, mergedMetrics, valueTypes, metricTypeNames, rowCount, indexSpec);
        progress.progress();
        IndexMaker.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, mergedMetrics, skippedDimensions, progress, indexSpec);
        v9Smoosher.close();
        progress.stop();
        return outDir;
    }

    private static void setupDimConversion(List<IndexableAdapter> adapters, ProgressIndicator progress, List<String> mergedDimensions, List<Map<String, IntBuffer>> dimConversions, Map<String, Integer> dimIndexes, Set<String> skippedDimensions, Map<String, Iterable<String>> dimensionValuesLookup) {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (IndexableAdapter adapter : adapters) {
            dimConversions.add(Maps.newHashMap());
        }
        int dimIndex = 0;
        for (String dimension : mergedDimensions) {
            dimIndexes.put(dimension, dimIndex++);
            ArrayList dimValueLookups = Lists.newArrayListWithCapacity((int)adapters.size());
            DimValueConverter[] converters = new DimValueConverter[adapters.size()];
            for (int i = 0; i < adapters.size(); ++i) {
                Indexed<String> dimValues = adapters.get(i).getDimValueLookup(dimension);
                if (IndexMerger.isNullColumn(dimValues)) continue;
                dimValueLookups.add(dimValues);
                converters[i] = new DimValueConverter(dimValues);
            }
            CombiningIterable dimensionValues = CombiningIterable.createSplatted((Iterable)Iterables.transform((Iterable)dimValueLookups, (Function)new Function<Indexed<String>, Iterable<String>>(){

                public Iterable<String> apply(Indexed<String> indexed) {
                    return Iterables.transform(indexed, (Function)new Function<String, String>(){

                        public String apply(@Nullable String input) {
                            return input == null ? "" : input;
                        }
                    });
                }
            }), (Comparator)Ordering.natural());
            int cardinality = 0;
            for (String value : dimensionValues) {
                for (int i = 0; i < adapters.size(); ++i) {
                    DimValueConverter converter = converters[i];
                    if (converter == null) continue;
                    converter.convert(value, cardinality);
                }
                ++cardinality;
            }
            if (cardinality == 0) {
                log.info("Skipping [%s], it is empty!", new Object[]{dimension});
                skippedDimensions.add(dimension);
                continue;
            }
            dimensionValuesLookup.put(dimension, (Iterable<String>)dimensionValues);
            for (int i = 0; i < adapters.size(); ++i) {
                DimValueConverter converter = converters[i];
                if (converter == null) continue;
                dimConversions.get(i).put(dimension, converters[i].getConversionBuffer());
            }
        }
        progress.stopSection("setup dimension conversions");
    }

    private static Iterable<Rowboat> makeRowIterable(List<IndexableAdapter> adapters, final List<String> mergedDimensions, final List<String> mergedMetrics, ArrayList<Map<String, IntBuffer>> dimConversions, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn) {
        ArrayList boats = Lists.newArrayListWithCapacity((int)adapters.size());
        for (int i = 0; i < adapters.size(); ++i) {
            IndexableAdapter adapter = adapters.get(i);
            final int[] dimLookup = new int[mergedDimensions.size()];
            int count = 0;
            for (String dim : adapter.getDimensionNames()) {
                dimLookup[count] = mergedDimensions.indexOf(dim);
                ++count;
            }
            final int[] metricLookup = new int[mergedMetrics.size()];
            count = 0;
            for (String metric : adapter.getMetricNames()) {
                metricLookup[count] = mergedMetrics.indexOf(metric);
                ++count;
            }
            boats.add(new MMappedIndexRowIterable(Iterables.transform(adapters.get(i).getRows(), (Function)new Function<Rowboat, Rowboat>(){

                public Rowboat apply(Rowboat input) {
                    int[][] newDims = new int[mergedDimensions.size()][];
                    int j = 0;
                    for (int[] dim : input.getDims()) {
                        newDims[dimLookup[j]] = dim;
                        ++j;
                    }
                    Object[] newMetrics = new Object[mergedMetrics.size()];
                    j = 0;
                    Object[] arr$ = input.getMetrics();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Object met;
                        newMetrics[metricLookup[j]] = met = arr$[i$];
                        ++j;
                    }
                    return new Rowboat(input.getTimestamp(), newDims, newMetrics, input.getRowNum());
                }
            }), mergedDimensions, dimConversions.get(i), i));
        }
        return (Iterable)rowMergerFn.apply((Object)boats);
    }

    private static int convertDims(List<IndexableAdapter> adapters, ProgressIndicator progress, Iterable<Rowboat> theRows, List<IntBuffer> rowNumConversions) throws IOException {
        String section = "convert dims";
        progress.startSection("convert dims");
        for (IndexableAdapter index : adapters) {
            int[] arr = new int[index.getNumRows()];
            Arrays.fill(arr, -1);
            rowNumConversions.add(IntBuffer.wrap(arr));
        }
        int rowCount = 0;
        for (Rowboat theRow : theRows) {
            for (Map.Entry<Integer, TreeSet<Integer>> comprisedRow : theRow.getComprisedRows().entrySet()) {
                IntBuffer conversionBuffer = rowNumConversions.get(comprisedRow.getKey());
                for (Integer rowNum : comprisedRow.getValue()) {
                    while (conversionBuffer.position() < rowNum) {
                        conversionBuffer.put(-1);
                    }
                    conversionBuffer.put(rowCount);
                }
            }
            if (++rowCount % 500000 != 0) continue;
            progress.progressSection("convert dims", String.format("Walked 500,000/%,d rows", rowCount));
        }
        for (IntBuffer rowNumConversion : rowNumConversions) {
            rowNumConversion.rewind();
        }
        progress.stopSection("convert dims");
        return rowCount;
    }

    private static void makeTimeColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, Iterable<Rowboat> theRows, int rowCount) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long[] longs = new long[rowCount];
        int rowNum = 0;
        for (Rowboat theRow : theRows) {
            longs[rowNum++] = theRow.getTimestamp();
        }
        CompressedLongsIndexedSupplier timestamps = CompressedLongsIndexedSupplier.fromLongBuffer(LongBuffer.wrap(longs), IndexIO.BYTE_ORDER, CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY);
        ColumnDescriptor.Builder timeBuilder = ColumnDescriptor.builder();
        timeBuilder.setValueType(ValueType.LONG);
        IndexMaker.writeColumn(v9Smoosher, new LongGenericColumnPartSerde(timestamps, IndexIO.BYTE_ORDER), timeBuilder, "__time");
        progress.stopSection("make time column");
    }

    private static void makeDimColumns(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, ProgressIndicator progress, List<String> mergedDimensions, Set<String> skippedDimensions, Iterable<Rowboat> theRows, Map<String, ColumnCapabilitiesImpl> columnCapabilities, Map<String, Iterable<String>> dimensionValuesLookup, List<IntBuffer> rowNumConversions, IndexSpec indexSpec) throws IOException {
        String dimSection = "make dimension columns";
        progress.startSection("make dimension columns");
        int dimIndex = 0;
        for (String dimension : mergedDimensions) {
            if (skippedDimensions.contains(dimension)) {
                ++dimIndex;
                continue;
            }
            IndexMaker.makeDimColumn(v9Smoosher, adapters, progress, theRows, dimIndex, dimension, columnCapabilities, dimensionValuesLookup, rowNumConversions, indexSpec.getBitmapSerdeFactory(), indexSpec.getDimensionCompressionStrategy());
            ++dimIndex;
        }
        progress.stopSection("make dimension columns");
    }

    private static void makeDimColumn(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, ProgressIndicator progress, Iterable<Rowboat> theRows, int dimIndex, String dimension, Map<String, ColumnCapabilitiesImpl> columnCapabilities, Map<String, Iterable<String>> dimensionValuesLookup, List<IntBuffer> rowNumConversions, BitmapSerdeFactory bitmapSerdeFactory, CompressedObjectStrategy.CompressionStrategy compressionStrategy) throws IOException {
        GenericIndexed<ImmutableBitmap> bitmaps;
        VSizeIndexed multiValCol;
        AbstractList<Integer> singleValCol;
        List<Object> vals;
        String section = String.format("make %s", dimension);
        progress.startSection(section);
        ColumnDescriptor.Builder dimBuilder = ColumnDescriptor.builder();
        dimBuilder.setValueType(ValueType.STRING);
        ArrayList outParts = Lists.newArrayList();
        ByteArrayOutputStream nameBAOS = new ByteArrayOutputStream();
        serializerUtils.writeString((OutputStream)nameBAOS, dimension);
        outParts.add(ByteBuffer.wrap(nameBAOS.toByteArray()));
        boolean hasMultipleValues = columnCapabilities.get(dimension).hasMultipleValues();
        dimBuilder.setHasMultipleValues(hasMultipleValues);
        ColumnDictionaryEntryStore adder = hasMultipleValues ? new MultiValColumnDictionaryEntryStore() : new SingleValColumnDictionaryEntryStore();
        final BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
        MutableBitmap nullSet = null;
        int rowCount = 0;
        for (Rowboat theRow : theRows) {
            if (dimIndex > theRow.getDims().length) {
                if (nullSet == null) {
                    nullSet = bitmapFactory.makeEmptyMutableBitmap();
                }
                nullSet.add(rowCount);
                adder.add(null);
            } else {
                int[] dimVals = theRow.getDims()[dimIndex];
                if (dimVals == null || dimVals.length == 0) {
                    if (nullSet == null) {
                        nullSet = bitmapFactory.makeEmptyMutableBitmap();
                    }
                    nullSet.add(rowCount);
                }
                adder.add(dimVals);
            }
            ++rowCount;
        }
        Iterable<String> dimensionValues = dimensionValuesLookup.get(dimension);
        GenericIndexed<String> dictionary = GenericIndexed.fromIterable(dimensionValues, GenericIndexed.STRING_STRATEGY);
        boolean bumpDictionary = false;
        if (hasMultipleValues) {
            int dictionarySize;
            vals = ((MultiValColumnDictionaryEntryStore)adder).get();
            if (nullSet != null) {
                log.info("Dimension[%s] has null rows.", new Object[]{dimension});
                if (Iterables.getFirst(dimensionValues, (Object)"") != null) {
                    bumpDictionary = true;
                    log.info("Dimension[%s] has no null value in the dictionary, expanding...", new Object[]{dimension});
                    dictionary = GenericIndexed.fromIterable(Iterables.concat(Collections.singleton(null), dimensionValues), GenericIndexed.STRING_STRATEGY);
                    dictionarySize = dictionary.size();
                    singleValCol = null;
                    multiValCol = VSizeIndexed.fromIterable(Iterables.transform(vals, (Function)new Function<List<Integer>, VSizeIndexedInts>(){

                        public VSizeIndexedInts apply(List<Integer> input) {
                            if (input == null) {
                                return VSizeIndexedInts.fromList((List<Integer>)ImmutableList.of((Object)0), dictionarySize);
                            }
                            return VSizeIndexedInts.fromList(new NullsAtZeroConvertingIntList(input, false), dictionarySize);
                        }
                    }));
                } else {
                    dictionarySize = dictionary.size();
                    singleValCol = null;
                    multiValCol = VSizeIndexed.fromIterable(Iterables.transform(vals, (Function)new Function<List<Integer>, VSizeIndexedInts>(){

                        public VSizeIndexedInts apply(List<Integer> input) {
                            if (input == null) {
                                return VSizeIndexedInts.fromList((List<Integer>)ImmutableList.of((Object)0), dictionarySize);
                            }
                            return VSizeIndexedInts.fromList(input, dictionarySize);
                        }
                    }));
                }
            } else {
                dictionarySize = dictionary.size();
                singleValCol = null;
                multiValCol = VSizeIndexed.fromIterable(Iterables.transform(vals, (Function)new Function<List<Integer>, VSizeIndexedInts>(){

                    public VSizeIndexedInts apply(List<Integer> input) {
                        return VSizeIndexedInts.fromList(input, dictionarySize);
                    }
                }));
            }
        } else {
            vals = ((SingleValColumnDictionaryEntryStore)adder).get();
            if (nullSet != null) {
                log.info("Dimension[%s] has null rows.", new Object[]{dimension});
                if (Iterables.getFirst(dimensionValues, (Object)"") != null) {
                    bumpDictionary = true;
                    log.info("Dimension[%s] has no null value in the dictionary, expanding...", new Object[]{dimension});
                    ArrayList nullList = Lists.newArrayList();
                    nullList.add(null);
                    dictionary = GenericIndexed.fromIterable(Iterables.concat((Iterable)nullList, dimensionValues), GenericIndexed.STRING_STRATEGY);
                    multiValCol = null;
                    singleValCol = new NullsAtZeroConvertingIntList(vals, false);
                } else {
                    multiValCol = null;
                    singleValCol = new NullsAtZeroConvertingIntList(vals, true);
                }
            } else {
                multiValCol = null;
                singleValCol = new AbstractList<Integer>(){

                    @Override
                    public Integer get(int index) {
                        return (Integer)vals.get(index);
                    }

                    @Override
                    public int size() {
                        return vals.size();
                    }
                };
            }
        }
        ArrayList mutableBitmaps = Lists.newArrayList();
        for (String dimVal : dimensionValues) {
            ArrayList convertedInverteds = Lists.newArrayListWithCapacity((int)adapters.size());
            for (int j = 0; j < adapters.size(); ++j) {
                convertedInverteds.add(new ConvertingIndexedInts(adapters.get(j).getBitmapIndex(dimension, dimVal), rowNumConversions.get(j)));
            }
            MutableBitmap bitset = bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
            for (Integer row : CombiningIterable.createSplatted((Iterable)convertedInverteds, (Comparator)Ordering.natural().nullsFirst())) {
                if (row == -1) continue;
                bitset.add(row.intValue());
            }
            mutableBitmaps.add(bitset);
        }
        if (nullSet != null) {
            ImmutableBitmap theNullSet = bitmapFactory.makeImmutableBitmap(nullSet);
            if (bumpDictionary) {
                bitmaps = GenericIndexed.fromIterable(Iterables.concat(Arrays.asList(theNullSet), (Iterable)Iterables.transform((Iterable)mutableBitmaps, (Function)new Function<MutableBitmap, ImmutableBitmap>(){

                    public ImmutableBitmap apply(MutableBitmap input) {
                        return bitmapFactory.makeImmutableBitmap(input);
                    }
                })), bitmapSerdeFactory.getObjectStrategy());
            } else {
                Iterable immutableBitmaps = Iterables.transform((Iterable)mutableBitmaps, (Function)new Function<MutableBitmap, ImmutableBitmap>(){

                    public ImmutableBitmap apply(MutableBitmap input) {
                        return bitmapFactory.makeImmutableBitmap(input);
                    }
                });
                bitmaps = GenericIndexed.fromIterable(Iterables.concat(Arrays.asList(theNullSet.union((ImmutableBitmap)Iterables.getFirst((Iterable)immutableBitmaps, null))), (Iterable)Iterables.skip((Iterable)immutableBitmaps, (int)1)), bitmapSerdeFactory.getObjectStrategy());
            }
        } else {
            bitmaps = GenericIndexed.fromIterable(Iterables.transform((Iterable)mutableBitmaps, (Function)new Function<MutableBitmap, ImmutableBitmap>(){

                public ImmutableBitmap apply(MutableBitmap input) {
                    return bitmapFactory.makeImmutableBitmap(input);
                }
            }), bitmapSerdeFactory.getObjectStrategy());
        }
        ImmutableRTree spatialIndex = null;
        boolean hasSpatialIndexes = columnCapabilities.get(dimension).hasSpatialIndexes();
        RTree tree = null;
        if (hasSpatialIndexes) {
            tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, bitmapSerdeFactory.getBitmapFactory()), bitmapSerdeFactory.getBitmapFactory());
        }
        int dimValIndex = 0;
        for (String dimVal : dimensionValuesLookup.get(dimension)) {
            if (!hasSpatialIndexes) continue;
            if (dimVal != null && !dimVal.isEmpty()) {
                ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                float[] coords = new float[stringCoords.size()];
                for (int j = 0; j < coords.length; ++j) {
                    coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                }
                tree.insert(coords, (MutableBitmap)mutableBitmaps.get(dimValIndex));
            }
            ++dimValIndex;
        }
        if (hasSpatialIndexes) {
            spatialIndex = ImmutableRTree.newImmutableFromMutable((RTree)tree);
        }
        log.info("Completed dimension[%s] with cardinality[%,d]. Starting write.", new Object[]{dimension, dictionary.size()});
        DictionaryEncodedColumnPartSerde.Builder dimPartBuilder = DictionaryEncodedColumnPartSerde.builder().withDictionary(dictionary).withBitmapSerdeFactory(bitmapSerdeFactory).withBitmaps(bitmaps).withSpatialIndex(spatialIndex).withByteOrder(IndexIO.BYTE_ORDER);
        if (singleValCol != null) {
            if (compressionStrategy != null) {
                dimPartBuilder.withSingleValuedColumn(CompressedVSizeIntsIndexedSupplier.fromList((List<Integer>)singleValCol, dictionary.size(), CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(dictionary.size()), IndexIO.BYTE_ORDER, compressionStrategy));
            } else {
                dimPartBuilder.withSingleValuedColumn(VSizeIndexedInts.fromList((List<Integer>)singleValCol, dictionary.size()));
            }
        } else if (compressionStrategy != null) {
            dimPartBuilder.withMultiValuedColumn(CompressedVSizeIndexedSupplier.fromIterable(multiValCol, dictionary.size(), IndexIO.BYTE_ORDER, compressionStrategy));
        } else {
            dimPartBuilder.withMultiValuedColumn(multiValCol);
        }
        IndexMaker.writeColumn(v9Smoosher, dimPartBuilder.build(), dimBuilder, dimension);
        progress.stopSection(section);
    }

    private static void makeMetricColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, Iterable<Rowboat> theRows, List<String> mergedMetrics, Map<String, ValueType> valueTypes, Map<String, String> metricTypeNames, int rowCount, IndexSpec indexSpec) throws IOException {
        String metSection = "make metric columns";
        progress.startSection("make metric columns");
        int metIndex = 0;
        for (String metric : mergedMetrics) {
            IndexMaker.makeMetricColumn(v9Smoosher, progress, theRows, metIndex, metric, valueTypes, metricTypeNames, rowCount, indexSpec.getMetricCompressionStrategy());
            ++metIndex;
        }
        progress.stopSection("make metric columns");
    }

    private static void makeMetricColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, Iterable<Rowboat> theRows, final int metricIndex, String metric, Map<String, ValueType> valueTypes, Map<String, String> metricTypeNames, int rowCount, CompressedObjectStrategy.CompressionStrategy compressionStrategy) throws IOException {
        String section = String.format("make column[%s]", metric);
        progress.startSection(section);
        ColumnDescriptor.Builder metBuilder = ColumnDescriptor.builder();
        ValueType type = valueTypes.get(metric);
        switch (type) {
            case FLOAT: {
                metBuilder.setValueType(ValueType.FLOAT);
                float[] arr = new float[rowCount];
                int rowNum = 0;
                for (Rowboat theRow : theRows) {
                    Object obj = theRow.getMetrics()[metricIndex];
                    arr[rowNum++] = obj == null ? 0.0f : ((Number)obj).floatValue();
                }
                CompressedFloatsIndexedSupplier compressedFloats = CompressedFloatsIndexedSupplier.fromFloatBuffer(FloatBuffer.wrap(arr), IndexIO.BYTE_ORDER, compressionStrategy);
                IndexMaker.writeColumn(v9Smoosher, new FloatGenericColumnPartSerde(compressedFloats, IndexIO.BYTE_ORDER), metBuilder, metric);
                break;
            }
            case LONG: {
                metBuilder.setValueType(ValueType.LONG);
                long[] arr = new long[rowCount];
                int rowNum = 0;
                for (Rowboat theRow : theRows) {
                    Object obj = theRow.getMetrics()[metricIndex];
                    arr[rowNum++] = obj == null ? 0L : ((Number)obj).longValue();
                }
                CompressedLongsIndexedSupplier compressedLongs = CompressedLongsIndexedSupplier.fromLongBuffer(LongBuffer.wrap(arr), IndexIO.BYTE_ORDER, compressionStrategy);
                IndexMaker.writeColumn(v9Smoosher, new LongGenericColumnPartSerde(compressedLongs, IndexIO.BYTE_ORDER), metBuilder, metric);
                break;
            }
            case COMPLEX: {
                String complexType = metricTypeNames.get(metric);
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(complexType);
                if (serde == null) {
                    throw new ISE("Unknown type[%s]", new Object[]{complexType});
                }
                GenericIndexed metricColumn = GenericIndexed.fromIterable(Iterables.transform(theRows, (Function)new Function<Rowboat, Object>(){

                    public Object apply(Rowboat input) {
                        return input.getMetrics()[metricIndex];
                    }
                }), serde.getObjectStrategy());
                metBuilder.setValueType(ValueType.COMPLEX);
                IndexMaker.writeColumn(v9Smoosher, new ComplexColumnPartSerde(metricColumn, complexType), metBuilder, metric);
                break;
            }
            default: {
                throw new ISE("Unknown type[%s]", new Object[]{type});
            }
        }
        progress.stopSection(section);
    }

    private static void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, List<String> mergedMetrics, final Set<String> skippedDimensions, ProgressIndicator progress, IndexSpec indexSpec) throws IOException {
        String section = "building index.drd";
        progress.startSection("building index.drd");
        TreeSet finalColumns = Sets.newTreeSet();
        finalColumns.addAll(mergedDimensions);
        finalColumns.addAll(mergedMetrics);
        finalColumns.removeAll(skippedDimensions);
        Iterable finalDimensions = Iterables.filter(mergedDimensions, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !skippedDimensions.contains(input);
            }
        });
        GenericIndexed<String> cols = GenericIndexed.fromIterable(finalColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> dims = GenericIndexed.fromIterable(finalDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory());
        long numBytes = cols.getSerializedSize() + dims.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(bitmapSerdeFactoryType);
        SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
        cols.writeToChannel((WritableByteChannel)writer);
        dims.writeToChannel((WritableByteChannel)writer);
        DateTime minTime = new DateTime(0x3FFFFFFFFFFFFFFFL);
        DateTime maxTime = new DateTime(-4611686018427387904L);
        for (IndexableAdapter index : adapters) {
            minTime = JodaUtils.minDateTime((DateTime[])new DateTime[]{minTime, index.getDataInterval().getStart()});
            maxTime = JodaUtils.maxDateTime((DateTime[])new DateTime[]{maxTime, index.getDataInterval().getEnd()});
        }
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
        serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getStartMillis());
        serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getEndMillis());
        serializerUtils.writeString((WritableByteChannel)writer, bitmapSerdeFactoryType);
        writer.close();
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        progress.stopSection("building index.drd");
    }

    private static void writeColumn(FileSmoosher v9Smoosher, ColumnPartSerde serde, ColumnDescriptor.Builder builder, String name) throws IOException {
        builder.addSerde(serde);
        ColumnDescriptor descriptor = builder.build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializerUtils.writeString((OutputStream)baos, mapper.writeValueAsString((Object)descriptor));
        byte[] specBytes = baos.toByteArray();
        SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(name, descriptor.numBytes() + (long)specBytes.length);
        channel.write(ByteBuffer.wrap(specBytes));
        descriptor.write((WritableByteChannel)channel);
        channel.close();
    }

    private static <T extends Comparable> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet retVal = Sets.newTreeSet((Comparator)Ordering.natural().nullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList((Iterable)retVal);
    }

    static {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable<? extends Module>)ImmutableList.of());
        mapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    private static class MultiValColumnDictionaryEntryStore
    implements ColumnDictionaryEntryStore {
        private final List<List<Integer>> data = Lists.newArrayList();

        private MultiValColumnDictionaryEntryStore() {
        }

        @Override
        public void add(int[] vals) {
            if (vals == null || vals.length == 0) {
                this.data.add(null);
            } else {
                this.data.add(Ints.asList((int[])vals));
            }
        }

        public List<List<Integer>> get() {
            return this.data;
        }
    }

    private static class SingleValColumnDictionaryEntryStore
    implements ColumnDictionaryEntryStore {
        private final List<Integer> data = Lists.newArrayList();

        private SingleValColumnDictionaryEntryStore() {
        }

        @Override
        public void add(int[] vals) {
            if (vals == null || vals.length == 0) {
                this.data.add(null);
            } else {
                this.data.add(vals[0]);
            }
        }

        public List<Integer> get() {
            return this.data;
        }
    }

    private static class RowboatMergeFunction
    implements BinaryFn<Rowboat, Rowboat, Rowboat> {
        private final AggregatorFactory[] metricAggs;

        public RowboatMergeFunction(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        public Rowboat apply(Rowboat lhs, Rowboat rhs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            Object[] metrics = new Object[this.metricAggs.length];
            Object[] lhsMetrics = lhs.getMetrics();
            Object[] rhsMetrics = rhs.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                metrics[i] = this.metricAggs[i].combine(lhsMetrics[i], rhsMetrics[i]);
            }
            Rowboat retVal = new Rowboat(lhs.getTimestamp(), lhs.getDims(), metrics, lhs.getRowNum());
            for (Rowboat rowboat : Arrays.asList(lhs, rhs)) {
                for (Map.Entry<Integer, TreeSet<Integer>> entry : rowboat.getComprisedRows().entrySet()) {
                    for (Integer rowNum : entry.getValue()) {
                        retVal.addRow(entry.getKey(), rowNum);
                    }
                }
            }
            return retVal;
        }
    }

    private static class AggFactoryStringIndexed
    implements Indexed<String> {
        private final AggregatorFactory[] metricAggs;

        public AggFactoryStringIndexed(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public int size() {
            return this.metricAggs.length;
        }

        @Override
        public String get(int index) {
            return this.metricAggs[index].getName();
        }

        @Override
        public int indexOf(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return IndexedIterable.create(this).iterator();
        }
    }

    private static class MMappedIndexRowIterable
    implements Iterable<Rowboat> {
        private final Iterable<Rowboat> index;
        private final List<String> convertedDims;
        private final Map<String, IntBuffer> converters;
        private final int indexNumber;

        MMappedIndexRowIterable(Iterable<Rowboat> index, List<String> convertedDims, Map<String, IntBuffer> converters, int indexNumber) {
            this.index = index;
            this.convertedDims = convertedDims;
            this.converters = converters;
            this.indexNumber = indexNumber;
        }

        public Iterable<Rowboat> getIndex() {
            return this.index;
        }

        public List<String> getConvertedDims() {
            return this.convertedDims;
        }

        public Map<String, IntBuffer> getConverters() {
            return this.converters;
        }

        public int getIndexNumber() {
            return this.indexNumber;
        }

        @Override
        public Iterator<Rowboat> iterator() {
            final IntBuffer[] converterArray = (IntBuffer[])FluentIterable.from(this.convertedDims).transform((Function)new Function<String, IntBuffer>(){

                public IntBuffer apply(String input) {
                    return (IntBuffer)MMappedIndexRowIterable.this.converters.get(input);
                }
            }).toArray(IntBuffer.class);
            return Iterators.transform(this.index.iterator(), (Function)new Function<Rowboat, Rowboat>(){

                public Rowboat apply(Rowboat input) {
                    int[][] dims = input.getDims();
                    int[][] newDims = new int[MMappedIndexRowIterable.this.convertedDims.size()][];
                    for (int i = 0; i < newDims.length; ++i) {
                        IntBuffer converter = converterArray[i];
                        if (converter == null || i >= dims.length || dims[i] == null) continue;
                        newDims[i] = new int[dims[i].length];
                        for (int j = 0; j < dims[i].length; ++j) {
                            if (!converter.hasRemaining()) {
                                throw new ISE("Converter mismatch! wtfbbq!", new Object[0]);
                            }
                            newDims[i][j] = converter.get(dims[i][j]);
                        }
                    }
                    Rowboat retVal = new Rowboat(input.getTimestamp(), newDims, input.getMetrics(), input.getRowNum());
                    retVal.addRow(MMappedIndexRowIterable.this.indexNumber, input.getRowNum());
                    return retVal;
                }
            });
        }
    }

    private static class ConvertingIndexedInts
    implements Iterable<Integer> {
        private final IndexedInts baseIndex;
        private final IntBuffer conversionBuffer;

        public ConvertingIndexedInts(IndexedInts baseIndex, IntBuffer conversionBuffer) {
            this.baseIndex = baseIndex;
            this.conversionBuffer = conversionBuffer;
        }

        public int size() {
            return this.baseIndex.size();
        }

        public int get(int index) {
            return this.conversionBuffer.get(this.baseIndex.get(index));
        }

        @Override
        public Iterator<Integer> iterator() {
            return Iterators.transform(this.baseIndex.iterator(), (Function)new Function<Integer, Integer>(){

                public Integer apply(Integer input) {
                    return ConvertingIndexedInts.this.conversionBuffer.get(input);
                }
            });
        }
    }

    private static class DimValueConverter {
        private final Indexed<String> dimSet;
        private final IntBuffer conversionBuf;
        private int currIndex;
        private String lastVal = null;

        DimValueConverter(Indexed<String> dimSet) {
            this.dimSet = dimSet;
            int bufferSize = dimSet.size() * 4;
            log.info("Allocating new dimension conversion buffer of size[%,d]", new Object[]{bufferSize});
            this.conversionBuf = ByteBuffer.allocateDirect(bufferSize).asIntBuffer();
            this.currIndex = 0;
        }

        public void convert(String value, int index) {
            if (this.dimSet.size() == 0) {
                return;
            }
            if (this.lastVal != null) {
                if (value.compareTo(this.lastVal) <= 0) {
                    throw new ISE("Value[%s] is less than the last value[%s] I have, cannot be.", new Object[]{value, this.lastVal});
                }
                return;
            }
            String currValue = this.dimSet.get(this.currIndex);
            while (currValue == null) {
                this.conversionBuf.position(this.conversionBuf.position() + 1);
                ++this.currIndex;
                if (this.currIndex == this.dimSet.size()) {
                    this.lastVal = value;
                    return;
                }
                currValue = this.dimSet.get(this.currIndex);
            }
            if (Objects.equal((Object)currValue, (Object)value)) {
                this.conversionBuf.put(index);
                ++this.currIndex;
                if (this.currIndex == this.dimSet.size()) {
                    this.lastVal = value;
                }
            } else if (currValue.compareTo(value) < 0) {
                throw new ISE("Skipped currValue[%s], currIndex[%,d]; incoming value[%s], index[%,d]", new Object[]{currValue, this.currIndex, value, index});
            }
        }

        public IntBuffer getConversionBuffer() {
            if (this.currIndex != this.conversionBuf.limit() || this.conversionBuf.hasRemaining()) {
                throw new ISE("Asked for incomplete buffer.  currIndex[%,d] != buf.limit[%,d]", new Object[]{this.currIndex, this.conversionBuf.limit()});
            }
            return (IntBuffer)this.conversionBuf.asReadOnlyBuffer().rewind();
        }
    }

    private static interface ColumnDictionaryEntryStore {
        public void add(int[] var1);
    }

    private static class NullsAtZeroConvertingIntList
    extends AbstractList<Integer> {
        private final List<Integer> delegate;
        private final boolean delegateHasNullAtZero;

        NullsAtZeroConvertingIntList(List<Integer> delegate, boolean delegateHasNullAtZero) {
            this.delegate = delegate;
            this.delegateHasNullAtZero = delegateHasNullAtZero;
        }

        @Override
        public Integer get(int index) {
            Integer val = this.delegate.get(index);
            if (val == null) {
                return 0;
            }
            return this.delegateHasNullAtZero ? val : val + 1;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

