/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BySegmentResultValue;
import io.druid.query.CacheStrategy;
import io.druid.query.DruidMetrics;
import io.druid.query.IntervalChunkingQueryRunnerDecorator;
import io.druid.query.Query;
import io.druid.query.QueryCacheHelper;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorUtil;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.topn.BySegmentTopNResultValue;
import io.druid.query.topn.DimensionAndMetricValueExtractor;
import io.druid.query.topn.TopNBinaryFn;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryEngine;
import io.druid.query.topn.TopNResultMerger;
import io.druid.query.topn.TopNResultValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class TopNQueryQueryToolChest
extends QueryToolChest<Result<TopNResultValue>, TopNQuery> {
    private static final byte TOPN_QUERY = 1;
    private static final TypeReference<Result<TopNResultValue>> TYPE_REFERENCE = new TypeReference<Result<TopNResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final TopNQueryConfig config;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;

    @Inject
    public TopNQueryQueryToolChest(TopNQueryConfig config, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this.config = config;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
    }

    protected static String[] extractFactoryName(List<AggregatorFactory> aggregatorFactories) {
        return Lists.transform(aggregatorFactories, (Function)new Function<AggregatorFactory, String>(){

            @Nullable
            public String apply(@Nullable AggregatorFactory input) {
                return input.getName();
            }
        }).toArray(new String[0]);
    }

    private static List<PostAggregator> prunePostAggregators(TopNQuery query) {
        return AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeResults(QueryRunner<Result<TopNResultValue>> runner) {
        return new ResultMergeQueryRunner<Result<TopNResultValue>>(runner){

            @Override
            protected Ordering<Result<TopNResultValue>> makeOrdering(Query<Result<TopNResultValue>> query) {
                return Ordering.from(new ResultGranularTimestampComparator(((TopNQuery)query).getGranularity()));
            }

            @Override
            protected BinaryFn<Result<TopNResultValue>, Result<TopNResultValue>, Result<TopNResultValue>> createMergeFn(Query<Result<TopNResultValue>> input) {
                TopNQuery query = (TopNQuery)input;
                return new TopNBinaryFn(TopNResultMerger.identity, query.getGranularity(), query.getDimensionSpec(), query.getTopNMetricSpec(), query.getThreshold(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
            }
        };
    }

    @Override
    public Sequence<Result<TopNResultValue>> mergeSequences(Sequence<Sequence<Result<TopNResultValue>>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public Sequence<Result<TopNResultValue>> mergeSequencesUnordered(Sequence<Sequence<Result<TopNResultValue>>> seqOfSequences) {
        return new MergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(TopNQuery query) {
        return DruidMetrics.makePartialQueryTimeMetric(query).setDimension("threshold", String.valueOf(query.getThreshold())).setDimension("dimension", query.getDimensionSpec().getDimension()).setDimension("numMetrics", String.valueOf(query.getAggregatorSpecs().size())).setDimension("numComplexMetrics", String.valueOf(DruidMetrics.findNumComplexAggs(query.getAggregatorSpecs())));
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePreComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            private final List<PostAggregator> prunedAggs;
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
                this.prunedAggs = TopNQueryQueryToolChest.prunePostAggregators(query);
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList serializedValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)result.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap values = Maps.newHashMapWithExpectedSize((int)(aggregatorFactories.length + prunedAggs.size() + 1));
                        for (int i = 0; i < aggregatorFactories.length; ++i) {
                            String aggName = aggFactoryNames[i];
                            values.put(aggName, fn.manipulate(aggregatorFactories[i], input.getMetric(aggName)));
                        }
                        for (PostAggregator postAgg : prunedAggs) {
                            String name = postAgg.getName();
                            Object calculatedPostAgg = input.getMetric(name);
                            if (calculatedPostAgg != null) {
                                values.put(name, calculatedPostAgg);
                                continue;
                            }
                            values.put(name, postAgg.compute(values));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePostComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            private final AggregatorFactory[] aggregatorFactories;
            private final String[] aggFactoryNames;
            private final PostAggregator[] postAggregators;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
                this.aggregatorFactories = query.getAggregatorSpecs().toArray(new AggregatorFactory[0]);
                this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                this.postAggregators = query.getPostAggregatorSpecs().toArray(new PostAggregator[0]);
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList serializedValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)result.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap values = Maps.newHashMapWithExpectedSize((int)(aggregatorFactories.length + query.getPostAggregatorSpecs().size() + 1));
                        for (int i = 0; i < aggFactoryNames.length; ++i) {
                            String name = aggFactoryNames[i];
                            values.put(name, input.getMetric(name));
                        }
                        for (PostAggregator postAgg : postAggregators) {
                            Object calculatedPostAgg = input.getMetric(postAgg.getName());
                            if (calculatedPostAgg != null) {
                                values.put(postAgg.getName(), calculatedPostAgg);
                                continue;
                            }
                            values.put(postAgg.getName(), postAgg.compute(values));
                        }
                        for (int i = 0; i < aggFactoryNames.length; ++i) {
                            String name = aggFactoryNames[i];
                            values.put(name, fn.manipulate(aggregatorFactories[i], input.getMetric(name)));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public TypeReference<Result<TopNResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TopNResultValue>, Object, TopNQuery> getCacheStrategy(final TopNQuery query) {
        return new CacheStrategy<Result<TopNResultValue>, Object, TopNQuery>(){
            private final List<AggregatorFactory> aggs;
            private final List<PostAggregator> postAggs;
            {
                this.aggs = Lists.newArrayList(query.getAggregatorSpecs());
                this.postAggs = AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
            }

            @Override
            public byte[] computeCacheKey(TopNQuery query2) {
                byte[] dimensionSpecBytes = query2.getDimensionSpec().getCacheKey();
                byte[] metricSpecBytes = query2.getTopNMetricSpec().getCacheKey();
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                return ByteBuffer.allocate(1 + dimensionSpecBytes.length + metricSpecBytes.length + 4 + granularityBytes.length + filterBytes.length + aggregatorBytes.length).put((byte)1).put(dimensionSpecBytes).put(metricSpecBytes).put(Ints.toByteArray((int)query2.getThreshold())).put(granularityBytes).put(filterBytes).put(aggregatorBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TopNResultValue>, Object> prepareForCache() {
                return new Function<Result<TopNResultValue>, Object>(){
                    private final String[] aggFactoryNames;
                    {
                        this.aggFactoryNames = TopNQueryQueryToolChest.extractFactoryName(query.getAggregatorSpecs());
                    }

                    public Object apply(Result<TopNResultValue> input) {
                        ArrayList results = Lists.newArrayList((Iterable)input.getValue());
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)(results.size() + 1));
                        retVal.add(input.getTimestamp().getMillis());
                        for (DimensionAndMetricValueExtractor result : results) {
                            ArrayList vals = Lists.newArrayListWithCapacity((int)(this.aggFactoryNames.length + 2));
                            vals.add(result.getStringDimensionValue(query.getDimensionSpec().getOutputName()));
                            for (String aggName : this.aggFactoryNames) {
                                vals.add(result.getMetric(aggName));
                            }
                            retVal.add(vals);
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TopNResultValue>> pullFromCache() {
                return new Function<Object, Result<TopNResultValue>>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TopNResultValue> apply(Object input) {
                        List results = (List)input;
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)results.size());
                        Iterator inputIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)inputIter.next()).longValue());
                        while (inputIter.hasNext()) {
                            List result = (List)inputIter.next();
                            LinkedHashMap vals = Maps.newLinkedHashMap();
                            Iterator aggIter = aggs.iterator();
                            Iterator resultIter = result.iterator();
                            vals.put(query.getDimensionSpec().getOutputName(), resultIter.next());
                            while (aggIter.hasNext() && resultIter.hasNext()) {
                                AggregatorFactory factory = (AggregatorFactory)aggIter.next();
                                vals.put(factory.getName(), factory.deserialize(resultIter.next()));
                            }
                            for (PostAggregator postAgg : postAggs) {
                                vals.put(postAgg.getName(), postAgg.compute(vals));
                            }
                            retVal.add(vals);
                        }
                        return new Result<TopNResultValue>(timestamp, new TopNResultValue(retVal));
                    }
                };
            }

            @Override
            public Sequence<Result<TopNResultValue>> mergeSequences(Sequence<Sequence<Result<TopNResultValue>>> seqOfSequences) {
                return new MergeSequence(TopNQueryQueryToolChest.this.getOrdering(), seqOfSequences);
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> preMergeQueryDecoration(final QueryRunner<Result<TopNResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(Query<Result<TopNResultValue>> query, Map<String, Object> responseContext) {
                if (!(query instanceof TopNQuery)) {
                    return runner.run(query, responseContext);
                }
                TopNQuery topNQuery = (TopNQuery)query;
                if (TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                    DimensionSpec dimensionSpec = topNQuery.getDimensionSpec();
                    return runner.run(topNQuery.withDimensionSpec(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName())), responseContext);
                }
                return runner.run(query, responseContext);
            }
        }, this);
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> postMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        final ThresholdAdjustingQueryRunner thresholdRunner = new ThresholdAdjustingQueryRunner(runner, this.config.getMinTopNThreshold());
        return new QueryRunner<Result<TopNResultValue>>(){

            @Override
            public Sequence<Result<TopNResultValue>> run(Query<Result<TopNResultValue>> query, Map<String, Object> responseContext) {
                Sequence<Result<TopNResultValue>> resultSequence = thresholdRunner.run(query, responseContext);
                final TopNQuery topNQuery = (TopNQuery)query;
                if (!TopNQueryEngine.canApplyExtractionInPost(topNQuery)) {
                    return resultSequence;
                }
                return Sequences.map(resultSequence, (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                    public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                        TopNResultValue resultValue = input.getValue();
                        return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.transform(resultValue.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, DimensionAndMetricValueExtractor>(){

                            public DimensionAndMetricValueExtractor apply(DimensionAndMetricValueExtractor input) {
                                String dimOutputName = topNQuery.getDimensionSpec().getOutputName();
                                String dimValue = input.getStringDimensionValue(dimOutputName);
                                Map<String, Object> map = input.getBaseObject();
                                map.put(dimOutputName, topNQuery.getDimensionSpec().getExtractionFn().apply(dimValue));
                                return input;
                            }
                        })));
                    }
                });
            }
        };
    }

    public Ordering<Result<TopNResultValue>> getOrdering() {
        return Ordering.natural();
    }

    private static class ThresholdAdjustingQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        private final int minTopNThreshold;

        public ThresholdAdjustingQueryRunner(QueryRunner<Result<TopNResultValue>> runner, int minTopNThreshold) {
            this.runner = runner;
            this.minTopNThreshold = minTopNThreshold;
        }

        @Override
        public Sequence<Result<TopNResultValue>> run(Query<Result<TopNResultValue>> input, Map<String, Object> responseContext) {
            if (!(input instanceof TopNQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", new Object[]{TopNQuery.class, input.getClass()});
            }
            final TopNQuery query = (TopNQuery)input;
            if (query.getThreshold() > this.minTopNThreshold) {
                return this.runner.run(query, responseContext);
            }
            final boolean isBySegment = query.getContextBySegment(false);
            return Sequences.map(this.runner.run(query.withThreshold(this.minTopNThreshold), responseContext), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                    if (isBySegment) {
                        BySegmentResultValue value = (BySegmentResultValue)((Object)input.getValue());
                        return new Result<TopNResultValue>(input.getTimestamp(), new BySegmentTopNResultValue(Lists.transform(value.getResults(), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                            public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                                return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                            }
                        }), value.getSegmentId(), value.getInterval()));
                    }
                    return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                }
            });
        }
    }
}

