/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.topn.LexicographicTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpecBuilder;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public class AlphaNumericTopNMetricSpec
extends LexicographicTopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 2;
    protected static Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String str1, String str2) {
            int[] pos = new int[]{0, 0};
            if (str1 == null) {
                return -1;
            }
            if (str2 == null) {
                return 1;
            }
            if (str1.length() == 0) {
                return str2.length() == 0 ? 0 : -1;
            }
            if (str2.length() == 0) {
                return 1;
            }
            while (pos[0] < str1.length() && pos[1] < str2.length()) {
                int ch1 = str1.codePointAt(pos[0]);
                int ch2 = str2.codePointAt(pos[1]);
                int result = 0;
                if (this.isDigit(ch1)) {
                    result = this.isDigit(ch2) ? this.compareNumbers(str1, str2, pos) : -1;
                } else {
                    int n = result = this.isDigit(ch2) ? 1 : this.compareNonNumeric(str1, str2, pos);
                }
                if (result == 0) continue;
                return result;
            }
            return str1.length() - str2.length();
        }

        private int compareNumbers(String str0, String str1, int[] pos) {
            int delta = 0;
            int zeroes0 = 0;
            int zeroes1 = 0;
            int ch0 = -1;
            int ch1 = -1;
            while (pos[0] < str0.length() && this.isZero(ch0 = str0.codePointAt(pos[0]))) {
                ++zeroes0;
                pos[0] = pos[0] + Character.charCount(ch0);
            }
            while (pos[1] < str1.length() && this.isZero(ch1 = str1.codePointAt(pos[1]))) {
                ++zeroes1;
                pos[1] = pos[1] + Character.charCount(ch1);
            }
            while (true) {
                boolean noMoreDigits1;
                boolean noMoreDigits0 = ch0 < 0 || !this.isDigit(ch0);
                boolean bl = noMoreDigits1 = ch1 < 0 || !this.isDigit(ch1);
                if (noMoreDigits0 && noMoreDigits1) {
                    return delta != 0 ? delta : zeroes0 - zeroes1;
                }
                if (noMoreDigits0) {
                    return -1;
                }
                if (noMoreDigits1) {
                    return 1;
                }
                if (delta == 0 && ch0 != ch1) {
                    delta = this.valueOf(ch0) - this.valueOf(ch1);
                }
                if (pos[0] < str0.length()) {
                    ch0 = str0.codePointAt(pos[0]);
                    if (this.isDigit(ch0)) {
                        pos[0] = pos[0] + Character.charCount(ch0);
                    } else {
                        ch0 = -1;
                    }
                } else {
                    ch0 = -1;
                }
                if (pos[1] < str1.length()) {
                    ch1 = str1.codePointAt(pos[1]);
                    if (this.isDigit(ch1)) {
                        pos[1] = pos[1] + Character.charCount(ch1);
                        continue;
                    }
                    ch1 = -1;
                    continue;
                }
                ch1 = -1;
            }
        }

        private boolean isDigit(int ch) {
            return ch >= 48 && ch <= 57 || ch >= 1632 && ch <= 1641 || ch >= 1776 && ch <= 1785 || ch >= 2406 && ch <= 2415 || ch >= 65296 && ch <= 65305;
        }

        private boolean isZero(int ch) {
            return ch == 48 || ch == 1632 || ch == 1776 || ch == 2406 || ch == 65296;
        }

        private int valueOf(int digit) {
            if (digit <= 57) {
                return digit - 48;
            }
            if (digit <= 1641) {
                return digit - 1632;
            }
            if (digit <= 1785) {
                return digit - 1776;
            }
            if (digit <= 2415) {
                return digit - 2406;
            }
            if (digit <= 65305) {
                return digit - 65296;
            }
            return digit;
        }

        private int compareNonNumeric(String str0, String str1, int[] pos) {
            int start0 = pos[0];
            int ch0 = str0.codePointAt(pos[0]);
            pos[0] = pos[0] + Character.charCount(ch0);
            while (pos[0] < str0.length() && !this.isDigit(ch0 = str0.codePointAt(pos[0]))) {
                pos[0] = pos[0] + Character.charCount(ch0);
            }
            int start1 = pos[1];
            int ch1 = str1.codePointAt(pos[1]);
            pos[1] = pos[1] + Character.charCount(ch1);
            while (pos[1] < str1.length() && !this.isDigit(ch1 = str1.codePointAt(pos[1]))) {
                pos[1] = pos[1] + Character.charCount(ch1);
            }
            return String.CASE_INSENSITIVE_ORDER.compare(str0.substring(start0, pos[0]), str1.substring(start1, pos[1]));
        }
    };

    @JsonCreator
    public AlphaNumericTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop) {
        super(previousStop);
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return comparator;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.getPreviousStop() == null ? new byte[]{} : StringUtils.toUtf8((String)this.getPreviousStop());
        return ByteBuffer.allocate(1 + previousStopBytes.length).put((byte)2).put(previousStopBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return builder;
    }

    @Override
    public String toString() {
        return "AlphaNumericTopNMetricSpec{previousStop='" + this.getPreviousStop() + '\'' + '}';
    }
}

