/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.ISE;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.EmittingLogger;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.filter.Filter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.segment.ColumnSelectorBitmapIndexSelector;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.filter.Filters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SearchQueryRunner
implements QueryRunner<Result<SearchResultValue>> {
    private static final EmittingLogger log = new EmittingLogger(SearchQueryRunner.class);
    private final Segment segment;

    public SearchQueryRunner(Segment segment) {
        this.segment = segment;
    }

    @Override
    public Sequence<Result<SearchResultValue>> run(Query<Result<SearchResultValue>> input, Map<String, Object> responseContext) {
        if (!(input instanceof SearchQuery)) {
            throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), SearchQuery.class});
        }
        SearchQuery query = (SearchQuery)input;
        Filter filter = Filters.convertDimensionFilters(query.getDimensionsFilter());
        List<String> dimensions = query.getDimensions();
        final SearchQuerySpec searchQuerySpec = query.getQuery();
        final int limit = query.getLimit();
        QueryableIndex index = this.segment.asQueryableIndex();
        if (index != null) {
            ImmutableBitmap baseFilter;
            TreeSet retVal = Sets.newTreeSet(query.getSort().getComparator());
            Iterable<String> dimsToSearch = dimensions == null || dimensions.isEmpty() ? index.getAvailableDimensions() : dimensions;
            BitmapFactory bitmapFactory = index.getBitmapFactoryForDimensions();
            if (filter == null) {
                baseFilter = bitmapFactory.complement(bitmapFactory.makeEmptyImmutableBitmap(), index.getNumRows());
            } else {
                ColumnSelectorBitmapIndexSelector selector = new ColumnSelectorBitmapIndexSelector(bitmapFactory, index);
                baseFilter = filter.getBitmapIndex(selector);
            }
            for (String dimension : dimsToSearch) {
                BitmapIndex bitmapIndex;
                Column column = index.getColumn(dimension);
                if (column == null || (bitmapIndex = column.getBitmapIndex()) == null) continue;
                for (int i = 0; i < bitmapIndex.getCardinality(); ++i) {
                    String dimVal = Strings.nullToEmpty((String)bitmapIndex.getValue(i));
                    if (!searchQuerySpec.accept(dimVal) || bitmapFactory.intersection(Arrays.asList(baseFilter, bitmapIndex.getBitmap(i))).size() <= 0) continue;
                    retVal.add(new SearchHit(dimension, dimVal));
                    if (retVal.size() < limit) continue;
                    return this.makeReturnResult(limit, retVal);
                }
            }
            return this.makeReturnResult(limit, retVal);
        }
        StorageAdapter adapter = this.segment.asStorageAdapter();
        if (adapter == null) {
            log.makeAlert("WTF!? Unable to process search query on segment.", new Object[0]).addData("segment", (Object)this.segment.getIdentifier()).addData("query", (Object)query).emit();
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        final Iterable<String> dimsToSearch = dimensions == null || dimensions.isEmpty() ? adapter.getAvailableDimensions() : dimensions;
        Sequence<Cursor> cursors = adapter.makeCursors(filter, this.segment.getDataInterval(), QueryGranularity.ALL);
        TreeSet retVal = (TreeSet)cursors.accumulate((Object)Sets.newTreeSet(query.getSort().getComparator()), (Accumulator)new Accumulator<TreeSet<SearchHit>, Cursor>(){

            public TreeSet<SearchHit> accumulate(TreeSet<SearchHit> set, Cursor cursor) {
                if (set.size() >= limit) {
                    return set;
                }
                HashMap dimSelectors = Maps.newHashMap();
                for (String string : dimsToSearch) {
                    dimSelectors.put(string, cursor.makeDimensionSelector(string, null));
                }
                while (!cursor.isDone()) {
                    for (Map.Entry entry : dimSelectors.entrySet()) {
                        DimensionSelector selector = (DimensionSelector)entry.getValue();
                        if (selector == null) continue;
                        IndexedInts vals = selector.getRow();
                        for (int i = 0; i < vals.size(); ++i) {
                            String dimVal = selector.lookupName(vals.get(i));
                            if (!searchQuerySpec.accept(dimVal)) continue;
                            set.add(new SearchHit((String)entry.getKey(), dimVal));
                            if (set.size() < limit) continue;
                            return set;
                        }
                    }
                    cursor.advance();
                }
                return set;
            }
        });
        return this.makeReturnResult(limit, retVal);
    }

    private Sequence<Result<SearchResultValue>> makeReturnResult(int limit, TreeSet<SearchHit> retVal) {
        return Sequences.simple((Iterable)ImmutableList.of(new Result<SearchResultValue>(this.segment.getDataInterval().getStart(), new SearchResultValue(Lists.newArrayList((Iterable)new FunctionalIterable(retVal).limit(limit))))));
    }
}

