/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ColumnAnalysis {
    private static final String ERROR_PREFIX = "error:";
    private final String type;
    private final long size;
    private final Integer cardinality;
    private final String errorMessage;

    public static ColumnAnalysis error(String reason) {
        return new ColumnAnalysis("STRING", -1L, null, ERROR_PREFIX + reason);
    }

    @JsonCreator
    public ColumnAnalysis(@JsonProperty(value="type") String type, @JsonProperty(value="size") long size, @JsonProperty(value="cardinality") Integer cardinality, @JsonProperty(value="errorMessage") String errorMessage) {
        this.type = type;
        this.size = size;
        this.cardinality = cardinality;
        this.errorMessage = errorMessage;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public Integer getCardinality() {
        return this.cardinality;
    }

    @JsonProperty
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isError() {
        return this.errorMessage != null && !this.errorMessage.isEmpty();
    }

    public ColumnAnalysis fold(ColumnAnalysis rhs) {
        if (rhs == null) {
            return this;
        }
        if (!this.type.equals(rhs.getType())) {
            return ColumnAnalysis.error("cannot_merge_diff_types");
        }
        Integer cardinality = this.getCardinality();
        Integer rhsCardinality = rhs.getCardinality();
        if (cardinality == null) {
            cardinality = rhsCardinality;
        } else if (rhsCardinality != null) {
            cardinality = Math.max(cardinality, rhsCardinality);
        }
        return new ColumnAnalysis(this.type, this.size + rhs.getSize(), cardinality, null);
    }

    public String toString() {
        return "ColumnAnalysis{type='" + this.type + '\'' + ", size=" + this.size + ", cardinality=" + this.cardinality + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnAnalysis that = (ColumnAnalysis)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.cardinality != null ? !this.cardinality.equals(that.cardinality) : that.cardinality != null) {
            return false;
        }
        return !(this.errorMessage == null ? that.errorMessage != null : !this.errorMessage.equals(that.errorMessage));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.cardinality != null ? this.cardinality.hashCode() : 0);
        result = 31 * result + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        return result;
    }
}

