/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.ConcatQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.metadata.SegmentAnalyzer;
import io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.segment.QueryableIndex;
import io.druid.segment.Segment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SegmentMetadataQueryRunnerFactory
implements QueryRunnerFactory<SegmentAnalysis, SegmentMetadataQuery> {
    private static final SegmentAnalyzer analyzer = new SegmentAnalyzer();
    private static final Logger log = new Logger(SegmentMetadataQueryRunnerFactory.class);
    private final SegmentMetadataQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SegmentMetadataQueryRunnerFactory(SegmentMetadataQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<SegmentAnalysis> createRunner(final Segment segment) {
        return new QueryRunner<SegmentAnalysis>(){

            @Override
            public Sequence<SegmentAnalysis> run(Query<SegmentAnalysis> inQ, Map<String, Object> responseContext) {
                SegmentMetadataQuery query = (SegmentMetadataQuery)inQ;
                QueryableIndex index = segment.asQueryableIndex();
                if (index == null) {
                    return Sequences.empty();
                }
                Map<String, ColumnAnalysis> analyzedColumns = analyzer.analyze(index);
                long totalSize = analyzedColumns.size() * index.getNumRows();
                TreeMap columns = Maps.newTreeMap();
                ColumnIncluderator includerator = query.getToInclude();
                for (Map.Entry<String, ColumnAnalysis> entry : analyzedColumns.entrySet()) {
                    String columnName = entry.getKey();
                    ColumnAnalysis column = entry.getValue();
                    if (!column.isError()) {
                        totalSize += column.getSize();
                    }
                    if (!includerator.include(columnName)) continue;
                    columns.put(columnName, column);
                }
                return Sequences.simple(Arrays.asList(new SegmentAnalysis(segment.getIdentifier(), Arrays.asList(segment.getDataInterval()), columns, totalSize)));
            }
        };
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeRunners(ExecutorService exec, Iterable<QueryRunner<SegmentAnalysis>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        return new ConcatQueryRunner<SegmentAnalysis>(Sequences.map((Sequence)Sequences.simple(queryRunners), (Function)new Function<QueryRunner<SegmentAnalysis>, QueryRunner<SegmentAnalysis>>(){

            public QueryRunner<SegmentAnalysis> apply(final QueryRunner<SegmentAnalysis> input) {
                return new QueryRunner<SegmentAnalysis>(){

                    @Override
                    public Sequence<SegmentAnalysis> run(final Query<SegmentAnalysis> query, final Map<String, Object> responseContext) {
                        int priority = query.getContextPriority(0);
                        ListenableFuture future = queryExecutor.submit((Callable)new AbstractPrioritizedCallable<Sequence<SegmentAnalysis>>(priority){

                            @Override
                            public Sequence<SegmentAnalysis> call() throws Exception {
                                return Sequences.simple((Iterable)Sequences.toList(input.run(query, responseContext), new ArrayList()));
                            }
                        });
                        try {
                            SegmentMetadataQueryRunnerFactory.this.queryWatcher.registerQuery(query, future);
                            Number timeout = query.getContextValue("timeout", null);
                            return timeout == null ? (Sequence)future.get() : (Sequence)future.get(timeout.longValue(), TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
                            future.cancel(true);
                            throw new QueryInterruptedException("Query interrupted");
                        }
                        catch (CancellationException e) {
                            throw new QueryInterruptedException("Query cancelled");
                        }
                        catch (TimeoutException e) {
                            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
                            future.cancel(true);
                            throw new QueryInterruptedException("Query timeout");
                        }
                        catch (ExecutionException e) {
                            throw Throwables.propagate((Throwable)e.getCause());
                        }
                    }
                };
            }
        }));
    }

    @Override
    public QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> getToolchest() {
        return this.toolChest;
    }
}

