/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.guice.annotations.Global;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.ConcatQueryRunner;
import io.druid.query.GroupByParallelQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.query.groupby.GroupByQueryQueryToolChest;
import io.druid.segment.Segment;
import io.druid.segment.StorageAdapter;
import io.druid.segment.incremental.IncrementalIndex;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<Row, GroupByQuery> {
    private static final Logger log = new Logger(GroupByQueryRunnerFactory.class);
    private final GroupByQueryEngine engine;
    private final QueryWatcher queryWatcher;
    private final Supplier<GroupByQueryConfig> config;
    private final GroupByQueryQueryToolChest toolChest;
    private final StupidPool<ByteBuffer> computationBufferPool;

    @Inject
    public GroupByQueryRunnerFactory(GroupByQueryEngine engine, QueryWatcher queryWatcher, Supplier<GroupByQueryConfig> config, GroupByQueryQueryToolChest toolChest, @Global StupidPool<ByteBuffer> computationBufferPool) {
        this.engine = engine;
        this.queryWatcher = queryWatcher;
        this.config = config;
        this.toolChest = toolChest;
        this.computationBufferPool = computationBufferPool;
    }

    @Override
    public QueryRunner<Row> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.engine);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        final ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)exec);
        if (((GroupByQueryConfig)this.config.get()).isSingleThreaded()) {
            return new ConcatQueryRunner<Row>(Sequences.map((Sequence)Sequences.simple(queryRunners), (Function)new Function<QueryRunner<Row>, QueryRunner<Row>>(){

                public QueryRunner<Row> apply(final QueryRunner<Row> input) {
                    return new QueryRunner<Row>(){

                        @Override
                        public Sequence<Row> run(final Query<Row> query, final Map<String, Object> responseContext) {
                            final GroupByQuery queryParam = (GroupByQuery)query;
                            final Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(queryParam, (GroupByQueryConfig)GroupByQueryRunnerFactory.this.config.get(), (StupidPool<ByteBuffer>)GroupByQueryRunnerFactory.this.computationBufferPool);
                            final Pair bySegmentAccumulatorPair = GroupByQueryHelper.createBySegmentAccumulatorPair();
                            int priority = query.getContextPriority(0);
                            final boolean bySegment = query.getContextBySegment(false);
                            ListenableFuture future = queryExecutor.submit((Callable)new AbstractPrioritizedCallable<Void>(priority){

                                @Override
                                public Void call() throws Exception {
                                    if (bySegment) {
                                        input.run(queryParam, responseContext).accumulate(bySegmentAccumulatorPair.lhs, (Accumulator)bySegmentAccumulatorPair.rhs);
                                    } else {
                                        input.run(query, responseContext).accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
                                    }
                                    return null;
                                }
                            });
                            try {
                                GroupByQueryRunnerFactory.this.queryWatcher.registerQuery(query, future);
                                Number timeout = query.getContextValue("timeout", null);
                                if (timeout == null) {
                                    future.get();
                                } else {
                                    future.get(timeout.longValue(), TimeUnit.MILLISECONDS);
                                }
                            }
                            catch (InterruptedException e) {
                                log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
                                future.cancel(true);
                                throw new QueryInterruptedException("Query interrupted");
                            }
                            catch (CancellationException e) {
                                throw new QueryInterruptedException("Query cancelled");
                            }
                            catch (TimeoutException e) {
                                log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
                                future.cancel(true);
                                throw new QueryInterruptedException("Query timeout");
                            }
                            catch (ExecutionException e) {
                                throw Throwables.propagate((Throwable)e.getCause());
                            }
                            if (bySegment) {
                                return Sequences.simple((Iterable)((Iterable)bySegmentAccumulatorPair.lhs));
                            }
                            return Sequences.simple(((IncrementalIndex)indexAccumulatorPair.lhs).iterableWithPostAggregations(null));
                        }
                    };
                }
            }));
        }
        return new GroupByParallelQueryRunner<Row>((ExecutorService)queryExecutor, this.config, this.queryWatcher, this.computationBufferPool, queryRunners);
    }

    @Override
    public QueryToolChest<Row, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    private static class GroupByQueryRunner
    implements QueryRunner<Row> {
        private final StorageAdapter adapter;
        private final GroupByQueryEngine engine;

        public GroupByQueryRunner(Segment segment, GroupByQueryEngine engine) {
            this.adapter = segment.asStorageAdapter();
            this.engine = engine;
        }

        @Override
        public Sequence<Row> run(Query<Row> input, Map<String, Object> responseContext) {
            if (!(input instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), GroupByQuery.class});
            }
            return this.engine.process((GroupByQuery)input, this.adapter);
        }
    }
}

