/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;

public class ExtractionDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public ExtractionDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @Deprecated @JsonProperty(value="dimExtractionFn") ExtractionFn dimExtractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value must not be null");
        Preconditions.checkArgument((extractionFn != null || dimExtractionFn != null ? 1 : 0) != 0, (Object)"extraction function must not be null");
        this.dimension = dimension;
        this.value = value;
        this.extractionFn = extractionFn != null ? extractionFn : dimExtractionFn;
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] valueBytes = StringUtils.toUtf8((String)this.value);
        return ByteBuffer.allocate(1 + dimensionBytes.length + valueBytes.length).put((byte)4).put(dimensionBytes).put(valueBytes).array();
    }

    public String toString() {
        return String.format("%s(%s) = %s", this.extractionFn, this.dimension, this.value);
    }
}

