/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.RegexDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import java.util.Arrays;
import java.util.List;

public class DimFilters {
    public static SelectorDimFilter dimEquals(String dimension, String value) {
        return new SelectorDimFilter(dimension, value);
    }

    public static AndDimFilter and(DimFilter ... filters) {
        return DimFilters.and(Arrays.asList(filters));
    }

    public static AndDimFilter and(List<DimFilter> filters) {
        return new AndDimFilter(filters);
    }

    public static OrDimFilter or(DimFilter ... filters) {
        return DimFilters.or(Arrays.asList(filters));
    }

    public static OrDimFilter or(List<DimFilter> filters) {
        return new OrDimFilter(filters);
    }

    public static NotDimFilter not(DimFilter filter) {
        return new NotDimFilter(filter);
    }

    public static RegexDimFilter regex(String dimension, String pattern) {
        return new RegexDimFilter(dimension, pattern);
    }

    public static DimFilter dimEquals(final String dimension, String ... values) {
        return DimFilters.or(Lists.transform(Arrays.asList(values), (Function)new Function<String, DimFilter>(){

            public DimFilter apply(String input) {
                return DimFilters.dimEquals(dimension, input);
            }
        }));
    }
}

