/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.LookupExtractor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="map")
public class MapLookupExtractor
implements LookupExtractor {
    private final Map<String, String> map;

    @JsonCreator
    public MapLookupExtractor(@JsonProperty(value="map") Map<String, String> map) {
        this.map = (Map)Preconditions.checkNotNull(map, (Object)"map");
    }

    @JsonProperty
    public Map<String, String> getMap() {
        return ImmutableMap.copyOf(this.map);
    }

    @Override
    @Nullable
    public String apply(@NotNull String val) {
        return this.map.get(val);
    }

    @Override
    public byte[] getCacheKey() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!Strings.isNullOrEmpty((String)key)) {
                    outputStream.write(StringUtils.toUtf8((String)key));
                }
                outputStream.write(-1);
                if (!Strings.isNullOrEmpty((String)val)) {
                    outputStream.write(StringUtils.toUtf8((String)val));
                }
                outputStream.write(-1);
            }
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }
}

