/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class HyperUniqueFinalizingPostAggregator
implements PostAggregator {
    private final String name;
    private final String fieldName;

    @JsonCreator
    public HyperUniqueFinalizingPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName, (Object)"fieldName is null");
        this.name = name == null ? fieldName : name;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        return HyperUniquesAggregatorFactory.estimateCardinality(combinedAggregators.get(this.fieldName));
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="fieldName")
    public String getFieldName() {
        return this.fieldName;
    }
}

