/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.primitives.Longs;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.LongColumnSelector;
import java.util.Comparator;

public class LongSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare((long)((Number)o).longValue(), (long)((Number)o1).longValue());
        }
    };
    private final LongColumnSelector selector;
    private final String name;
    private long sum;

    static long combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).longValue() + ((Number)rhs).longValue();
    }

    public LongSumAggregator(String name, LongColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.sum = 0L;
    }

    @Override
    public void aggregate() {
        this.sum += this.selector.get();
    }

    @Override
    public void reset() {
        this.sum = 0L;
    }

    @Override
    public Object get() {
        return this.sum;
    }

    @Override
    public float getFloat() {
        return this.sum;
    }

    @Override
    public long getLong() {
        return this.sum;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new LongSumAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

