/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.LongSumAggregator;
import io.druid.segment.LongColumnSelector;
import java.util.Comparator;

public class LongMinAggregator
implements Aggregator {
    static final Comparator COMPARATOR = LongSumAggregator.COMPARATOR;
    private final LongColumnSelector selector;
    private final String name;
    private long min;

    static long combineValues(Object lhs, Object rhs) {
        return Math.min(((Number)lhs).longValue(), ((Number)rhs).longValue());
    }

    public LongMinAggregator(String name, LongColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.reset();
    }

    @Override
    public void aggregate() {
        this.min = Math.min(this.min, this.selector.get());
    }

    @Override
    public void reset() {
        this.min = Long.MAX_VALUE;
    }

    @Override
    public Object get() {
        return this.min;
    }

    @Override
    public float getFloat() {
        return this.min;
    }

    @Override
    public long getLong() {
        return this.min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new LongMinAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

