/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.query.aggregation.JavaScriptAggregator;
import io.druid.query.aggregation.JavaScriptBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ObjectColumnSelector;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptAggregatorFactory
implements AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 6;
    private final String name;
    private final List<String> fieldNames;
    private final String fnAggregate;
    private final String fnReset;
    private final String fnCombine;
    private final JavaScriptAggregator.ScriptAggregator compiledScript;

    @JsonCreator
    public JavaScriptAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fnAggregate") String fnAggregate, @JsonProperty(value="fnReset") String fnReset, @JsonProperty(value="fnCombine") String fnCombine) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldNames, (Object)"Must have a valid, non-null fieldNames");
        Preconditions.checkNotNull((Object)fnAggregate, (Object)"Must have a valid, non-null fnAggregate");
        Preconditions.checkNotNull((Object)fnReset, (Object)"Must have a valid, non-null fnReset");
        Preconditions.checkNotNull((Object)fnCombine, (Object)"Must have a valid, non-null fnCombine");
        this.name = name;
        this.fieldNames = fieldNames;
        this.fnAggregate = fnAggregate;
        this.fnReset = fnReset;
        this.fnCombine = fnCombine;
        this.compiledScript = JavaScriptAggregatorFactory.compileScript(fnAggregate, fnReset, fnCombine);
    }

    @Override
    public Aggregator factorize(final ColumnSelectorFactory columnFactory) {
        return new JavaScriptAggregator(this.name, Lists.transform(this.fieldNames, (Function)new Function<String, ObjectColumnSelector>(){

            public ObjectColumnSelector apply(@Nullable String s) {
                return columnFactory.makeObjectColumnSelector(s);
            }
        }), this.compiledScript);
    }

    @Override
    public BufferAggregator factorizeBuffered(final ColumnSelectorFactory columnSelectorFactory) {
        return new JavaScriptBufferAggregator(Lists.transform(this.fieldNames, (Function)new Function<String, ObjectColumnSelector>(){

            public ObjectColumnSelector apply(@Nullable String s) {
                return columnSelectorFactory.makeObjectColumnSelector(s);
            }
        }), this.compiledScript);
    }

    @Override
    public Comparator getComparator() {
        return DoubleSumAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return this.compiledScript.combine(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new JavaScriptAggregatorFactory(this.name, Lists.newArrayList((Object[])new String[]{this.name}), this.fnCombine, this.fnReset, this.fnCombine);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Lists.transform(this.fieldNames, (Function)new Function<String, AggregatorFactory>(){

            public AggregatorFactory apply(String input) {
                return new JavaScriptAggregatorFactory(input, JavaScriptAggregatorFactory.this.fieldNames, JavaScriptAggregatorFactory.this.fnAggregate, JavaScriptAggregatorFactory.this.fnReset, JavaScriptAggregatorFactory.this.fnCombine);
            }
        });
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getFnAggregate() {
        return this.fnAggregate;
    }

    @JsonProperty
    public String getFnReset() {
        return this.fnReset;
    }

    @JsonProperty
    public String getFnCombine() {
        return this.fnCombine;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldNames;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] fieldNameBytes = StringUtils.toUtf8((String)Joiner.on((String)",").join(this.fieldNames));
            byte[] sha1 = md.digest(StringUtils.toUtf8((String)(this.fnAggregate + this.fnReset + this.fnCombine)));
            return ByteBuffer.allocate(1 + fieldNameBytes.length + sha1.length).put((byte)6).put(fieldNameBytes).put(sha1).array();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get SHA1 digest instance", e);
        }
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return this.compiledScript.reset();
    }

    public String toString() {
        return "JavaScriptAggregatorFactory{name='" + this.name + '\'' + ", fieldNames=" + this.fieldNames + ", fnAggregate='" + this.fnAggregate + '\'' + ", fnReset='" + this.fnReset + '\'' + ", fnCombine='" + this.fnCombine + '\'' + '}';
    }

    public static JavaScriptAggregator.ScriptAggregator compileScript(String aggregate, String reset, String combine) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fnAggregate = context.compileFunction((Scriptable)scope, aggregate, "aggregate", 1, null);
        final org.mozilla.javascript.Function fnReset = context.compileFunction((Scriptable)scope, reset, "reset", 1, null);
        final org.mozilla.javascript.Function fnCombine = context.compileFunction((Scriptable)scope, combine, "combine", 1, null);
        Context.exit();
        return new JavaScriptAggregator.ScriptAggregator(){

            @Override
            public double aggregate(double current, ObjectColumnSelector[] selectorList) {
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                    cx.getWrapFactory().setJavaPrimitiveWrap(false);
                }
                int size = selectorList.length;
                Object[] args = new Object[size + 1];
                args[0] = current;
                for (int i = 0; i < size; ++i) {
                    ObjectColumnSelector selector = selectorList[i];
                    if (selector == null) continue;
                    Object arg = selector.get();
                    if (arg != null && arg.getClass().isArray()) {
                        Object[] arrayAsObjectArray = new Object[Array.getLength(arg)];
                        for (int j = 0; j < Array.getLength(arg); ++j) {
                            arrayAsObjectArray[j] = Array.get(arg, j);
                        }
                        args[i + 1] = cx.newArray((Scriptable)scope, arrayAsObjectArray);
                        continue;
                    }
                    args[i + 1] = Context.javaToJS(arg, (Scriptable)scope);
                }
                Object res = fnAggregate.call(cx, (Scriptable)scope, (Scriptable)scope, args);
                return Context.toNumber((Object)res);
            }

            @Override
            public double combine(final double a, final double b) {
                Object res = contextFactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return fnCombine.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{a, b});
                    }
                });
                return Context.toNumber((Object)res);
            }

            @Override
            public double reset() {
                Object res = contextFactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return fnReset.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[0]);
                    }
                });
                return Context.toNumber((Object)res);
            }

            @Override
            public void close() {
                if (Context.getCurrentContext() != null) {
                    Context.exit();
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptAggregatorFactory that = (JavaScriptAggregatorFactory)o;
        if (this.compiledScript != null ? !this.compiledScript.equals(that.compiledScript) : that.compiledScript != null) {
            return false;
        }
        if (this.fieldNames != null ? !this.fieldNames.equals(that.fieldNames) : that.fieldNames != null) {
            return false;
        }
        if (this.fnAggregate != null ? !this.fnAggregate.equals(that.fnAggregate) : that.fnAggregate != null) {
            return false;
        }
        if (this.fnCombine != null ? !this.fnCombine.equals(that.fnCombine) : that.fnCombine != null) {
            return false;
        }
        if (this.fnReset != null ? !this.fnReset.equals(that.fnReset) : that.fnReset != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldNames != null ? this.fieldNames.hashCode() : 0);
        result = 31 * result + (this.fnAggregate != null ? this.fnAggregate.hashCode() : 0);
        result = 31 * result + (this.fnReset != null ? this.fnReset.hashCode() : 0);
        result = 31 * result + (this.fnCombine != null ? this.fnCombine.hashCode() : 0);
        result = 31 * result + (this.compiledScript != null ? this.compiledScript.hashCode() : 0);
        return result;
    }
}

