/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.Histogram;
import io.druid.query.aggregation.HistogramAggregator;
import io.druid.query.aggregation.HistogramBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class HistogramAggregatorFactory
implements AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 7;
    private final String name;
    private final String fieldName;
    private final List<Float> breaksList;
    private final float[] breaks;

    @JsonCreator
    public HistogramAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="breaks") List<Float> breaksList) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.breaksList = breaksList == null ? Lists.newArrayList() : breaksList;
        this.breaks = new float[this.breaksList.size()];
        for (int i = 0; i < this.breaksList.size(); ++i) {
            this.breaks[i] = this.breaksList.get(i).floatValue();
        }
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new HistogramAggregator(this.name, metricFactory.makeFloatColumnSelector(this.fieldName), this.breaks);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new HistogramBufferAggregator(metricFactory.makeFloatColumnSelector(this.fieldName), this.breaks);
    }

    @Override
    public Comparator getComparator() {
        return HistogramAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return HistogramAggregator.combineHistograms(lhs, rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HistogramAggregatorFactory(this.name, this.name, this.breaksList);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new HistogramAggregatorFactory(this.fieldName, this.fieldName, this.breaksList));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            return Histogram.fromBytes((byte[])object);
        }
        if (object instanceof ByteBuffer) {
            return Histogram.fromBytes((ByteBuffer)object);
        }
        if (object instanceof String) {
            byte[] bytes = Base64.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)));
            return Histogram.fromBytes(bytes);
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return ((Histogram)object).asVisual();
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public List<Float> getBreaks() {
        return this.breaksList;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        ByteBuffer buf = ByteBuffer.allocate(1 + fieldNameBytes.length + 4 * this.breaks.length).put((byte)7).put(fieldNameBytes).put((byte)-1);
        buf.asFloatBuffer().put(this.breaks);
        return buf.array();
    }

    @Override
    public String getTypeName() {
        return "histogram";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8 * (this.breaks.length + 1) + 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return new Histogram(this.breaks);
    }

    public String toString() {
        return "HistogramAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", breaks=" + Arrays.toString(this.breaks) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistogramAggregatorFactory that = (HistogramAggregatorFactory)o;
        if (!Arrays.equals(this.breaks, that.breaks)) {
            return false;
        }
        if (this.breaksList != null ? !this.breaksList.equals(that.breaksList) : that.breaksList != null) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + (this.breaksList != null ? this.breaksList.hashCode() : 0);
        result = 31 * result + (this.breaks != null ? Arrays.hashCode(this.breaks) : 0);
        return result;
    }
}

