/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.Clock;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Druids;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesQueryEngine;
import io.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import io.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OnheapIncrementalIndexBenchmark
extends AbstractBenchmark {
    private static AggregatorFactory[] factories;
    static final int dimensionCount = 5;
    private final Class<? extends OnheapIncrementalIndex> incrementalIndex;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        return ImmutableList.of((Object)new Object[]{OnheapIncrementalIndex.class}, (Object)new Object[]{MapIncrementalIndex.class});
    }

    public OnheapIncrementalIndexBenchmark(Class<? extends OnheapIncrementalIndex> incrementalIndex) {
        this.incrementalIndex = incrementalIndex;
    }

    private static MapBasedInputRow getLongRow(long timestamp, int rowID, int dimensionCount) {
        ArrayList<String> dimensionList = new ArrayList<String>(dimensionCount);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < dimensionCount; ++i) {
            String dimName = String.format("Dim_%d", i);
            dimensionList.add(dimName);
            builder.put((Object)dimName, (Object)new Integer(rowID).longValue());
        }
        return new MapBasedInputRow(timestamp, dimensionList, (Map)builder.build());
    }

    @Ignore
    @Test
    @BenchmarkOptions(callgc=true, clock=Clock.REAL_TIME, warmupRounds=10, benchmarkRounds=20)
    public void testConcurrentAddRead() throws InterruptedException, ExecutionException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int taskCount = 30;
        int concurrentThreads = 3;
        int elementsPerThread = 32768;
        final OnheapIncrementalIndex incrementalIndex = this.incrementalIndex.getConstructor(Long.TYPE, QueryGranularity.class, AggregatorFactory[].class, Integer.TYPE).newInstance(0, QueryGranularity.NONE, factories, 983040);
        ArrayList<Object> queryAggregatorFactories = new ArrayList<Object>(6);
        queryAggregatorFactories.add(new CountAggregatorFactory("rows"));
        for (int i = 0; i < 5; ++i) {
            queryAggregatorFactories.add(new LongSumAggregatorFactory(String.format("sumResult%s", i), String.format("sumResult%s", i)));
            queryAggregatorFactories.add(new DoubleSumAggregatorFactory(String.format("doubleSumResult%s", i), String.format("doubleSumResult%s", i)));
        }
        ListeningExecutorService indexExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("index-executor-%d").setPriority(1).build()));
        ListeningExecutorService queryExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("query-executor-%d").build()));
        final long timestamp = System.currentTimeMillis();
        Interval queryInterval = new Interval((Object)"1900-01-01T00:00:00Z/2900-01-01T00:00:00Z");
        LinkedList<ListenableFuture> indexFutures = new LinkedList<ListenableFuture>();
        LinkedList<ListenableFuture> queryFutures = new LinkedList<ListenableFuture>();
        IncrementalIndexSegment incrementalIndexSegment = new IncrementalIndexSegment((IncrementalIndex)incrementalIndex, null);
        TimeseriesQueryRunnerFactory factory = new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        final AtomicInteger currentlyRunning = new AtomicInteger(0);
        AtomicBoolean concurrentlyRan = new AtomicBoolean(false);
        final AtomicBoolean someoneRan = new AtomicBoolean(false);
        for (int j = 0; j < 30; ++j) {
            indexFutures.add(indexExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    currentlyRunning.incrementAndGet();
                    try {
                        for (int i = 0; i < 32768; ++i) {
                            incrementalIndex.add((InputRow)OnheapIncrementalIndexBenchmark.getLongRow(timestamp + (long)i, 1, 5));
                        }
                    }
                    catch (IndexSizeExceededException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    currentlyRunning.decrementAndGet();
                    someoneRan.set(true);
                }
            }));
            queryFutures.add(queryExecutor.submit(new Runnable((QueryRunnerFactory)factory, (Segment)incrementalIndexSegment, queryInterval, queryAggregatorFactories, someoneRan, currentlyRunning, concurrentlyRan){
                final /* synthetic */ QueryRunnerFactory val$factory;
                final /* synthetic */ Segment val$incrementalIndexSegment;
                final /* synthetic */ Interval val$queryInterval;
                final /* synthetic */ ArrayList val$queryAggregatorFactories;
                final /* synthetic */ AtomicBoolean val$someoneRan;
                final /* synthetic */ AtomicInteger val$currentlyRunning;
                final /* synthetic */ AtomicBoolean val$concurrentlyRan;
                {
                    this.val$factory = queryRunnerFactory;
                    this.val$incrementalIndexSegment = segment;
                    this.val$queryInterval = interval;
                    this.val$queryAggregatorFactories = arrayList;
                    this.val$someoneRan = atomicBoolean;
                    this.val$currentlyRunning = atomicInteger;
                    this.val$concurrentlyRan = atomicBoolean2;
                }

                @Override
                public void run() {
                    FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(this.val$factory.createRunner(this.val$incrementalIndexSegment), this.val$factory.getToolchest());
                    TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(QueryGranularity.ALL).intervals((List)ImmutableList.of((Object)this.val$queryInterval)).aggregators((List)this.val$queryAggregatorFactories).build();
                    HashMap context = new HashMap();
                    for (Result result : (LinkedList)Sequences.toList((Sequence)runner.run((Query)query, context), new LinkedList())) {
                        if (!this.val$someoneRan.get()) continue;
                        Assert.assertTrue((((TimeseriesResultValue)result.getValue()).getDoubleMetric("doubleSumResult0") > 0.0 ? 1 : 0) != 0);
                    }
                    if (this.val$currentlyRunning.get() > 0) {
                        this.val$concurrentlyRan.set(true);
                    }
                }
            }));
        }
        ArrayList<ListenableFuture> allFutures = new ArrayList<ListenableFuture>(queryFutures.size() + indexFutures.size());
        allFutures.addAll(queryFutures);
        allFutures.addAll(indexFutures);
        Futures.allAsList(allFutures).get();
        queryExecutor.shutdown();
        indexExecutor.shutdown();
        FinalizeResultsQueryRunner runner = new FinalizeResultsQueryRunner(factory.createRunner((Segment)incrementalIndexSegment), factory.getToolchest());
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("xxx").granularity(QueryGranularity.ALL).intervals((List)ImmutableList.of((Object)queryInterval)).aggregators(queryAggregatorFactories).build();
        HashMap context = new HashMap();
        List results = Sequences.toList((Sequence)runner.run((Query)query, context), new LinkedList());
        int expectedVal = 983040;
        for (Result result : results) {
            Assert.assertEquals((long)32768L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric("rows").intValue());
            for (int i = 0; i < 5; ++i) {
                Assert.assertEquals((String)String.format("Failed long sum on dimension %d", i), (long)983040L, (long)((TimeseriesResultValue)result.getValue()).getLongMetric(String.format("sumResult%s", i)).intValue());
                Assert.assertEquals((String)String.format("Failed double sum on dimension %d", i), (long)983040L, (long)((TimeseriesResultValue)result.getValue()).getDoubleMetric(String.format("doubleSumResult%s", i)).intValue());
            }
        }
    }

    static {
        ArrayList<Object> ingestAggregatorFactories = new ArrayList<Object>(6);
        ingestAggregatorFactories.add(new CountAggregatorFactory("rows"));
        for (int i = 0; i < 5; ++i) {
            ingestAggregatorFactories.add(new LongSumAggregatorFactory(String.format("sumResult%s", i), String.format("Dim_%s", i)));
            ingestAggregatorFactories.add(new DoubleSumAggregatorFactory(String.format("doubleSumResult%s", i), String.format("Dim_%s", i)));
        }
        factories = ingestAggregatorFactories.toArray(new AggregatorFactory[0]);
    }

    private static final class MapIncrementalIndex
    extends OnheapIncrementalIndex {
        private final AtomicInteger indexIncrement = new AtomicInteger(0);
        ConcurrentHashMap<Integer, Aggregator[]> indexedMap = new ConcurrentHashMap();

        public MapIncrementalIndex(long minTimestamp, QueryGranularity gran, AggregatorFactory[] metrics, int maxRowCount) {
            super(minTimestamp, gran, metrics, maxRowCount);
        }

        protected Aggregator[] concurrentGet(int offset) {
            return this.indexedMap.get(offset);
        }

        protected void concurrentSet(int offset, Aggregator[] value) {
            this.indexedMap.put(offset, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer addToFacts(AggregatorFactory[] metrics, boolean deserializeComplexMetrics, InputRow row, AtomicInteger numEntries, IncrementalIndex.TimeAndDims key, ThreadLocal<InputRow> rowContainer, Supplier<InputRow> rowSupplier) throws IndexSizeExceededException {
            Aggregator[] aggs;
            Integer priorIdex = (Integer)this.getFacts().get(key);
            if (null != priorIdex) {
                aggs = this.indexedMap.get(priorIdex);
            } else {
                Integer rowIndex;
                aggs = new Aggregator[metrics.length];
                for (int i = 0; i < metrics.length; ++i) {
                    AggregatorFactory agg = metrics[i];
                    aggs[i] = agg.factorize(MapIncrementalIndex.makeColumnSelectorFactory((AggregatorFactory)agg, rowSupplier, (boolean)deserializeComplexMetrics));
                }
                while (null != this.indexedMap.putIfAbsent(rowIndex = Integer.valueOf(this.indexIncrement.incrementAndGet()), aggs)) {
                }
                if (numEntries.get() >= this.maxRowCount && !this.getFacts().containsKey(key)) {
                    throw new IndexSizeExceededException("Maximum number of rows reached");
                }
                Integer prev = this.getFacts().putIfAbsent(key, rowIndex);
                if (null == prev) {
                    numEntries.incrementAndGet();
                } else {
                    aggs = this.indexedMap.get(prev);
                    this.indexedMap.remove(rowIndex);
                }
            }
            rowContainer.set(row);
            Aggregator[] arr$ = aggs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Aggregator agg;
                Aggregator aggregator = agg = arr$[i$];
                synchronized (aggregator) {
                    agg.aggregate();
                    continue;
                }
            }
            rowContainer.set(null);
            return numEntries.get();
        }
    }
}

