/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ConciseBitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.RoaringBitmapFactory;
import com.metamx.collections.spatial.ImmutableRTree;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilters;
import io.druid.query.filter.ExtractionDimFilter;
import io.druid.segment.data.ArrayIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.ExtractionFilter;
import io.druid.segment.filter.Filters;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExtractionDimFilterTest {
    private static final Map<String, String[]> DIM_VALS = ImmutableMap.of((Object)"foo", (Object)new String[]{"foo1", "foo2", "foo3"}, (Object)"bar", (Object)new String[]{"bar1"}, (Object)"baz", (Object)new String[]{"foo1"});
    private static final Map<String, String> EXTRACTION_VALUES = ImmutableMap.of((Object)"foo1", (Object)"extractDimVal");
    private final BitmapFactory factory;
    private final ImmutableBitmap foo1BitMap;
    private final BitmapIndexSelector BITMAP_INDEX_SELECTOR = new BitmapIndexSelector(){

        public Indexed<String> getDimensionValues(String dimension) {
            Object[] vals = (String[])DIM_VALS.get(dimension);
            return vals == null ? null : new ArrayIndexed(vals, String.class);
        }

        public int getNumRows() {
            return 1;
        }

        public BitmapFactory getBitmapFactory() {
            return ExtractionDimFilterTest.this.factory;
        }

        public ImmutableBitmap getBitmapIndex(String dimension, String value) {
            return "foo1".equals(value) ? ExtractionDimFilterTest.this.foo1BitMap : null;
        }

        public ImmutableRTree getSpatialIndex(String dimension) {
            return null;
        }
    };
    private static final ExtractionFn DIM_EXTRACTION_FN = new DimExtractionFn(){

        public byte[] getCacheKey() {
            return new byte[0];
        }

        public String apply(String dimValue) {
            String retval = (String)EXTRACTION_VALUES.get(dimValue);
            return retval == null ? dimValue : retval;
        }

        public boolean preservesOrdering() {
            return false;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }
    };

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new ConciseBitmapFactory()}, (Object)new Object[]{new RoaringBitmapFactory()});
    }

    public ExtractionDimFilterTest(BitmapFactory bitmapFactory) {
        MutableBitmap mutableBitmap = bitmapFactory.makeEmptyMutableBitmap();
        mutableBitmap.add(1);
        this.foo1BitMap = bitmapFactory.makeImmutableBitmap(mutableBitmap);
        this.factory = bitmapFactory;
    }

    @Test
    public void testEmpty() {
        ExtractionFilter extractionFilter = new ExtractionFilter("foo", "NFDJUKFNDSJFNS", DIM_EXTRACTION_FN);
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNull() {
        ExtractionFilter extractionFilter = new ExtractionFilter("FDHJSFFHDS", "extractDimVal", DIM_EXTRACTION_FN);
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNormal() {
        ExtractionFilter extractionFilter = new ExtractionFilter("foo", "extractDimVal", DIM_EXTRACTION_FN);
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)1L, (long)immutableBitmap.size());
    }

    @Test
    public void testOr() {
        Assert.assertEquals((long)1L, (long)Filters.convertDimensionFilters((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.convertDimensionFilters((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testAnd() {
        Assert.assertEquals((long)1L, (long)Filters.convertDimensionFilters((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.convertDimensionFilters((DimFilter)DimFilters.and((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testNot() {
        Assert.assertEquals((long)1L, (long)Filters.convertDimensionFilters((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.convertDimensionFilters((DimFilter)DimFilters.not((DimFilter)new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null))).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }
}

