/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Lists;
import io.druid.segment.data.ArrayBasedOffset;
import io.druid.segment.data.Offset;
import io.druid.segment.data.UnioningOffset;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class UnioningOffsetTest {
    @Test
    public void testSanity() throws Exception {
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[]{2, 3, 4, 5, 6, 7})));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{2, 3, 4, 5, 6, 7}), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[]{4, 5, 9, 10})));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{4, 5, 9, 10}), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 6, 7, 8}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[0])));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 6, 7, 8}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[0]), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 6, 7, 8}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{1}), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
        UnioningOffsetTest.assertExpected(new int[]{1, 2, 3, 6, 7, 8}, new UnioningOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[]{1})));
    }

    private static void assertExpected(int[] expectedValues, UnioningOffset offset) {
        ArrayList offsets = Lists.newArrayList();
        offsets.add(offset);
        for (int i = 0; i < expectedValues.length; ++i) {
            for (int j = 0; j < offsets.size(); ++j) {
                Offset aClone = (Offset)offsets.get(j);
                Assert.assertTrue((String)String.format("Clone[%d] out of bounds", j), (boolean)aClone.withinBounds());
                Assert.assertEquals((String)String.format("Clone[%d] not right", j), (long)expectedValues[i], (long)aClone.getOffset());
                aClone.increment();
            }
            offsets.add(((Offset)offsets.get(0)).clone());
        }
        for (Offset aClone : offsets) {
            Assert.assertFalse((boolean)aClone.withinBounds());
        }
    }
}

