/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Lists;
import io.druid.segment.data.ArrayBasedOffset;
import io.druid.segment.data.IntersectingOffset;
import io.druid.segment.data.Offset;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;

public class IntersectingOffsetTest {
    @Test
    public void testSanity() throws Exception {
        IntersectingOffsetTest.assertExpected(new int[]{2, 3, 6, 7}, new IntersectingOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[]{2, 3, 4, 5, 6, 7})));
        IntersectingOffsetTest.assertExpected(new int[]{2, 3, 6, 7}, new IntersectingOffset((Offset)new ArrayBasedOffset(new int[]{2, 3, 4, 5, 6, 7}), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
        IntersectingOffsetTest.assertExpected(new int[0], new IntersectingOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[]{4, 5, 9, 10})));
        IntersectingOffsetTest.assertExpected(new int[0], new IntersectingOffset((Offset)new ArrayBasedOffset(new int[]{4, 5, 9, 10}), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
        IntersectingOffsetTest.assertExpected(new int[0], new IntersectingOffset((Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8}), (Offset)new ArrayBasedOffset(new int[0])));
        IntersectingOffsetTest.assertExpected(new int[0], new IntersectingOffset((Offset)new ArrayBasedOffset(new int[0]), (Offset)new ArrayBasedOffset(new int[]{1, 2, 3, 6, 7, 8})));
    }

    private static void assertExpected(int[] expectedValues, IntersectingOffset offset) {
        LinkedList offsets = Lists.newLinkedList();
        offsets.add(offset);
        for (int i = 0; i < expectedValues.length; ++i) {
            for (Offset aClone : offsets) {
                Assert.assertTrue((boolean)aClone.withinBounds());
                Assert.assertEquals((long)expectedValues[i], (long)aClone.getOffset());
                aClone.increment();
            }
            offsets.add(((Offset)offsets.getFirst()).clone());
        }
        for (Offset aClone : offsets) {
            Assert.assertFalse((boolean)aClone.withinBounds());
        }
    }
}

