/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.InMemoryCompressedFloats;
import io.druid.segment.data.IndexedFloats;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InMemoryCompressedFloatsTest {
    private InMemoryCompressedFloats floats;
    private float[] vals;

    @Before
    public void setUp() throws Exception {
        this.floats = null;
        this.vals = null;
    }

    private void setupSimple() {
        this.vals = new float[]{0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f};
        this.floats = new InMemoryCompressedFloats(5, ByteOrder.nativeOrder());
        for (int i = 0; i < this.vals.length; ++i) {
            Assert.assertEquals((long)i, (long)this.floats.add(this.vals[i]));
        }
    }

    @Test
    public void testSanity() throws Exception {
        this.setupSimple();
        Assert.assertEquals((long)this.vals.length, (long)this.floats.size());
        for (int i = 0; i < this.floats.size(); ++i) {
            Assert.assertEquals((double)this.vals[i], (double)this.floats.get(i), (double)0.0);
        }
    }

    @Test
    public void testBulkFill() throws Exception {
        this.setupSimple();
        this.tryFill(0, 16);
        this.tryFill(3, 6);
        this.tryFill(7, 7);
        this.tryFill(7, 9);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBulkFillTooMuch() throws Exception {
        this.setupSimple();
        this.tryFill(7, 10);
    }

    private void tryFill(int startIndex, int size) {
        float[] filled = new float[size];
        this.floats.fill(startIndex, filled);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((double)this.vals[i + startIndex], (double)filled[i], (double)0.0);
        }
    }

    @Test
    public void testCanConvertToCompressedFloatsIndexedSupplier() throws Exception {
        this.setupSimple();
        IndexedFloats indexed = this.floats.toCompressedFloatsIndexedSupplier().get();
        for (int i = 0; i < this.floats.size(); ++i) {
            Assert.assertEquals((float)this.floats.get(i), (float)indexed.get(i), (float)0.0f);
        }
        indexed.close();
    }
}

