/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Maps;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ObjectStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class GenericIndexedTest {
    @Test(expected=UnsupportedOperationException.class)
    public void testNotSortedNoIndexOf() throws Exception {
        GenericIndexed.fromArray((Object[])new String[]{"a", "c", "b"}, (ObjectStrategy)GenericIndexed.STRING_STRATEGY).indexOf((Object)"a");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSerializationNotSortedNoIndexOf() throws Exception {
        this.serializeAndDeserialize((GenericIndexed<String>)GenericIndexed.fromArray((Object[])new String[]{"a", "c", "b"}, (ObjectStrategy)GenericIndexed.STRING_STRATEGY)).indexOf((Object)"a");
    }

    @Test
    public void testSanity() throws Exception {
        Object[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"};
        GenericIndexed indexed = GenericIndexed.fromArray((Object[])strings, (ObjectStrategy)GenericIndexed.STRING_STRATEGY);
        Assert.assertEquals((long)strings.length, (long)indexed.size());
        for (int i = 0; i < strings.length; ++i) {
            Assert.assertEquals((Object)strings[i], (Object)indexed.get(i));
        }
        HashMap mixedUp = Maps.newHashMap();
        for (int i = 0; i < strings.length; ++i) {
            mixedUp.put(strings[i], i);
        }
        for (Map.Entry entry : mixedUp.entrySet()) {
            Assert.assertEquals((long)((Integer)entry.getValue()).intValue(), (long)indexed.indexOf(entry.getKey()));
        }
        Assert.assertEquals((long)-13L, (long)indexed.indexOf((Object)"q"));
        Assert.assertEquals((long)-9L, (long)indexed.indexOf((Object)"howdydo"));
        Assert.assertEquals((long)-1L, (long)indexed.indexOf((Object)"1111"));
    }

    @Test
    public void testSortedSerialization() throws Exception {
        Object[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"};
        GenericIndexed<String> deserialized = this.serializeAndDeserialize((GenericIndexed<String>)GenericIndexed.fromArray((Object[])strings, (ObjectStrategy)GenericIndexed.STRING_STRATEGY));
        Assert.assertEquals((long)strings.length, (long)deserialized.size());
        for (int i = 0; i < strings.length; ++i) {
            Assert.assertEquals((Object)strings[i], (Object)deserialized.get(i));
        }
        HashMap mixedUp = Maps.newHashMap();
        for (int i = 0; i < strings.length; ++i) {
            mixedUp.put(strings[i], i);
        }
        for (Map.Entry entry : mixedUp.entrySet()) {
            Assert.assertEquals((long)((Integer)entry.getValue()).intValue(), (long)deserialized.indexOf(entry.getKey()));
        }
        Assert.assertEquals((long)-13L, (long)deserialized.indexOf((Object)"q"));
        Assert.assertEquals((long)-9L, (long)deserialized.indexOf((Object)"howdydo"));
        Assert.assertEquals((long)-1L, (long)deserialized.indexOf((Object)"1111"));
    }

    private GenericIndexed<String> serializeAndDeserialize(GenericIndexed<String> indexed) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel channel = Channels.newChannel(baos);
        indexed.writeToChannel(channel);
        channel.close();
        ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
        Assert.assertEquals((long)indexed.getSerializedSize(), (long)byteBuffer.remaining());
        GenericIndexed deserialized = GenericIndexed.read((ByteBuffer)byteBuffer, (ObjectStrategy)GenericIndexed.STRING_STRATEGY);
        Assert.assertEquals((long)0L, (long)byteBuffer.remaining());
        return deserialized;
    }
}

