/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.metamx.common.guava.CloseQuietly;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import io.druid.segment.data.CompressionStrategyTest;
import io.druid.segment.data.IndexedInts;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedVSizeIntsIndexedSupplierTest
extends CompressionStrategyTest {
    private static final int[] MAX_VALUES = new int[]{255, 65535, 0xFFFFFF, 0xFFFFFFF};
    private IndexedInts indexed;
    private CompressedVSizeIntsIndexedSupplier supplier;
    private int[] vals;
    private final ByteOrder byteOrder;

    @Parameterized.Parameters(name="{index}: compression={0}, byteOrder={1}")
    public static Iterable<Object[]> compressionStrategies() {
        Iterable compressionStrategies = Iterables.transform(CompressionStrategyTest.compressionStrategies(), (Function)new Function<Object[], CompressedObjectStrategy.CompressionStrategy>(){

            public CompressedObjectStrategy.CompressionStrategy apply(Object[] input) {
                return (CompressedObjectStrategy.CompressionStrategy)input[0];
            }
        });
        Set combinations = Sets.cartesianProduct((Set[])new Set[]{Sets.newHashSet((Iterable)compressionStrategies), Sets.newHashSet((Object[])new ByteOrder[]{ByteOrder.BIG_ENDIAN, ByteOrder.LITTLE_ENDIAN})});
        return Iterables.transform((Iterable)combinations, (Function)new Function<List, Object[]>(){

            public Object[] apply(List input) {
                return new Object[]{input.get(0), input.get(1)};
            }
        });
    }

    public CompressedVSizeIntsIndexedSupplierTest(CompressedObjectStrategy.CompressionStrategy compressionStrategy, ByteOrder byteOrder) {
        super(compressionStrategy);
        this.byteOrder = byteOrder;
    }

    @Before
    public void setUp() throws Exception {
        CloseQuietly.close((Closeable)this.indexed);
        this.indexed = null;
        this.supplier = null;
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        CloseQuietly.close((Closeable)this.indexed);
    }

    private void setupSimple(int chunkSize) {
        CloseQuietly.close((Closeable)this.indexed);
        this.vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        this.supplier = CompressedVSizeIntsIndexedSupplier.fromList((List)Ints.asList((int[])this.vals), (int)Ints.max((int[])this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy);
        this.indexed = this.supplier.get();
    }

    private void setupSimpleWithSerde(int chunkSize) throws IOException {
        this.vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
        this.makeWithSerde(chunkSize);
    }

    private void makeWithSerde(int chunkSize) throws IOException {
        CloseQuietly.close((Closeable)this.indexed);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedVSizeIntsIndexedSupplier theSupplier = CompressedVSizeIntsIndexedSupplier.fromList((List)Ints.asList((int[])this.vals), (int)Ints.max((int[])this.vals), (int)chunkSize, (ByteOrder)this.byteOrder, (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy);
        theSupplier.writeToChannel(Channels.newChannel(baos));
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)theSupplier.getSerializedSize(), (long)bytes.length);
        this.supplier = CompressedVSizeIntsIndexedSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)this.byteOrder);
        this.indexed = this.supplier.get();
    }

    private void setupLargeChunks(int chunkSize, int totalSize, int maxValue) throws IOException {
        this.vals = new int[totalSize];
        Random rand = new Random(0L);
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = rand.nextInt(maxValue);
        }
        this.makeWithSerde(chunkSize);
    }

    @Test
    public void testSanity() throws Exception {
        this.setupSimple(2);
        Assert.assertEquals((long)8L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(4);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(32);
        Assert.assertEquals((long)1L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testLargeChunks() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue((int)maxValue);
            this.setupLargeChunks(maxChunkSize, 10 * maxChunkSize, maxValue);
            Assert.assertEquals((long)10L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
            this.setupLargeChunks(maxChunkSize, 10 * maxChunkSize + 1, maxValue);
            Assert.assertEquals((long)11L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
            this.setupLargeChunks(1, 65535, maxValue);
            Assert.assertEquals((long)65535L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
            this.setupLargeChunks(maxChunkSize / 2, 10 * (maxChunkSize / 2) + 1, maxValue);
            Assert.assertEquals((long)11L, (long)this.supplier.getBaseBuffers().size());
            this.assertIndexMatchesVals();
        }
    }

    @Test
    public void testChunkTooBig() throws Exception {
        for (int maxValue : MAX_VALUES) {
            int maxChunkSize = CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue((int)maxValue);
            try {
                this.setupLargeChunks(maxChunkSize + 1, 10 * (maxChunkSize + 1), maxValue);
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((String)("chunk too big for maxValue " + maxValue), (boolean)true);
            }
        }
    }

    @Test
    public void testmaxIntsInBuffer() throws Exception {
        Assert.assertEquals((long)65536L, (long)CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForBytes((int)1));
        Assert.assertEquals((long)32768L, (long)CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForBytes((int)2));
        Assert.assertEquals((long)16384L, (long)CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForBytes((int)4));
        Assert.assertEquals((long)65536L, (long)65536L);
        Assert.assertEquals((long)16384L, (long)CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForBytes((int)3));
    }

    @Test
    public void testSanityWithSerde() throws Exception {
        this.setupSimpleWithSerde(4);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimpleWithSerde(2);
        Assert.assertEquals((long)8L, (long)this.supplier.getBaseBuffers().size());
        this.assertIndexMatchesVals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentThreadReads() throws Exception {
        this.setupSimple(4);
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < CompressedVSizeIntsIndexedSupplierTest.this.indexed.size(); ++j) {
                            long indexedVal;
                            long val = CompressedVSizeIntsIndexedSupplierTest.this.vals[j];
                            if (Longs.compare((long)val, (long)(indexedVal = (long)CompressedVSizeIntsIndexedSupplierTest.this.indexed.get(j))) == 0) continue;
                            failureHappened.set(true);
                            reason.set(String.format("Thread1[%d]: %d != %d", j, val, indexedVal));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final IndexedInts indexed2 = this.supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = indexed2.size() - 1; j >= 0; --j) {
                                long indexedVal;
                                long val = CompressedVSizeIntsIndexedSupplierTest.this.vals[j];
                                if (Longs.compare((long)val, (long)(indexedVal = (long)indexed2.get(j))) == 0) continue;
                                failureHappened.set(true);
                                reason.set(String.format("Thread2[%d]: %d != %d", j, val, indexedVal));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseQuietly.close((Closeable)indexed2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }

    private void assertIndexMatchesVals() {
        int i;
        Assert.assertEquals((long)this.vals.length, (long)this.indexed.size());
        int[] indices = new int[this.vals.length];
        for (i = 0; i < this.indexed.size(); ++i) {
            int expected = this.vals[i];
            int actual = this.indexed.get(i);
            Assert.assertEquals((long)expected, (long)actual);
            indices[i] = i;
        }
        Collections.shuffle(Arrays.asList(new int[][]{indices}));
        for (i = 0; i < this.indexed.size(); ++i) {
            int k = indices[i];
            Assert.assertEquals((long)this.vals[k], (long)this.indexed.get(k));
        }
    }
}

