/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.druid.segment.CompressedVSizeIndexedSupplier;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedMultivalue;
import io.druid.segment.data.VSizeIndexedInts;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompressedVSizeIndexedSupplierTest {
    private List<int[]> vals;
    private CompressedVSizeIndexedSupplier indexedSupplier;

    @Before
    public void setUpSimple() {
        this.vals = Arrays.asList(new int[1], {1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}, {11, 12, 13, 14, 15, 16, 17, 18, 19, 20});
        this.indexedSupplier = CompressedVSizeIndexedSupplier.fromIterable((Iterable)Iterables.transform(this.vals, (Function)new Function<int[], IndexedInts>(){

            public IndexedInts apply(int[] input) {
                return VSizeIndexedInts.fromArray((int[])input, (int)20);
            }
        }), (int)20, (ByteOrder)ByteOrder.nativeOrder(), (CompressedObjectStrategy.CompressionStrategy)CompressedObjectStrategy.CompressionStrategy.LZ4);
    }

    @After
    public void teardown() {
        this.indexedSupplier = null;
        this.vals = null;
    }

    @Test
    public void testSanity() throws Exception {
        this.assertSame(this.vals, (IndexedMultivalue<IndexedInts>)this.indexedSupplier.get());
    }

    @Test
    public void testSerde() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.indexedSupplier.writeToChannel(Channels.newChannel(baos));
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)this.indexedSupplier.getSerializedSize(), (long)bytes.length);
        CompressedVSizeIndexedSupplier deserializedIndexed = CompressedVSizeIndexedSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)ByteOrder.nativeOrder());
        this.assertSame(this.vals, (IndexedMultivalue<IndexedInts>)deserializedIndexed.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetInvalidElementInRow() {
        ((IndexedInts)this.indexedSupplier.get().get(3)).get(15);
    }

    @Test
    public void testIterators() {
        Iterator iterator = this.indexedSupplier.get().iterator();
        int row = 0;
        while (iterator.hasNext()) {
            int[] ints = this.vals.get(row);
            IndexedInts vSizeIndexedInts = (IndexedInts)iterator.next();
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            Iterator valsIterator = vSizeIndexedInts.iterator();
            int j = 0;
            while (valsIterator.hasNext()) {
                Assert.assertEquals((Object)ints[j], valsIterator.next());
                ++j;
            }
            ++row;
        }
    }

    private void assertSame(List<int[]> someInts, IndexedMultivalue<IndexedInts> indexed) {
        Assert.assertEquals((long)someInts.size(), (long)indexed.size());
        for (int i = 0; i < indexed.size(); ++i) {
            int[] ints = someInts.get(i);
            IndexedInts vSizeIndexedInts = (IndexedInts)indexed.get(i);
            Assert.assertEquals((long)ints.length, (long)vSizeIndexedInts.size());
            for (int j = 0; j < ints.length; ++j) {
                Assert.assertEquals((long)ints[j], (long)vSizeIndexedInts.get(j));
            }
        }
    }
}

