/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.OutputSupplier;
import io.druid.segment.data.CompressedLongBufferObjectStrategy;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.CompressedLongsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionStrategyTest;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.IOPeonForTesting;
import io.druid.segment.data.IndexedLongs;
import io.druid.segment.data.ObjectStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedLongsSupplierSerializerTest
extends CompressionStrategyTest {
    public CompressedLongsSupplierSerializerTest(CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        super(compressionStrategy);
    }

    @Test
    public void testSanity() throws Exception {
        ByteOrder order = ByteOrder.nativeOrder();
        int sizePer = 999;
        CompressedLongsSupplierSerializer serializer = new CompressedLongsSupplierSerializer(999, new GenericIndexedWriter((IOPeon)new IOPeonForTesting(), "test", (ObjectStrategy)CompressedLongBufferObjectStrategy.getBufferForOrder((ByteOrder)order, (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy, (int)999)), this.compressionStrategy);
        serializer.open();
        int numElements = 10000;
        for (int i = 0; i < 10000; ++i) {
            serializer.add((long)i);
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.closeAndConsolidate((OutputSupplier)new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return baos;
            }
        });
        IndexedLongs longs = CompressedLongsIndexedSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(baos.toByteArray()), (ByteOrder)order).get();
        Assert.assertEquals((long)10000L, (long)longs.size());
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((float)i, (float)longs.get(i), (float)0.0f);
        }
        longs.close();
    }
}

