/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.primitives.Longs;
import com.metamx.common.guava.CloseQuietly;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionStrategyTest;
import io.druid.segment.data.IndexedLongs;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedLongsIndexedSupplierTest
extends CompressionStrategyTest {
    private IndexedLongs indexed;
    private CompressedLongsIndexedSupplier supplier;
    private long[] vals;

    public CompressedLongsIndexedSupplierTest(CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        super(compressionStrategy);
    }

    @Before
    public void setUp() throws Exception {
        CloseQuietly.close((Closeable)this.indexed);
        this.indexed = null;
        this.supplier = null;
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        CloseQuietly.close((Closeable)this.indexed);
    }

    private void setupSimple(int chunkSize) {
        CloseQuietly.close((Closeable)this.indexed);
        this.vals = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 16L};
        this.supplier = CompressedLongsIndexedSupplier.fromLongBuffer((LongBuffer)LongBuffer.wrap(this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy);
        this.indexed = this.supplier.get();
    }

    private void setupSimpleWithSerde(int chunkSize) throws IOException {
        this.vals = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 16L};
        this.makeWithSerde(chunkSize);
    }

    private void makeWithSerde(int chunkSize) throws IOException {
        CloseQuietly.close((Closeable)this.indexed);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedLongsIndexedSupplier theSupplier = CompressedLongsIndexedSupplier.fromLongBuffer((LongBuffer)LongBuffer.wrap(this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy);
        theSupplier.writeToChannel(Channels.newChannel(baos));
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)theSupplier.getSerializedSize(), (long)bytes.length);
        this.supplier = CompressedLongsIndexedSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)ByteOrder.nativeOrder());
        this.indexed = this.supplier.get();
    }

    private void setupLargeChunks(int chunkSize, int totalSize) throws IOException {
        this.vals = new long[totalSize];
        Random rand = new Random(0L);
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = rand.nextLong();
        }
        this.makeWithSerde(chunkSize);
    }

    @Test
    public void testSanity() throws Exception {
        this.setupSimple(5);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(4);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(32);
        Assert.assertEquals((long)1L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testLargeChunks() throws Exception {
        int maxChunkSize = 8192;
        this.setupLargeChunks(8192, 81920);
        Assert.assertEquals((long)10L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
        this.setupLargeChunks(8192, 81921);
        Assert.assertEquals((long)11L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
        this.setupLargeChunks(8191, 81911);
        Assert.assertEquals((long)11L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChunkTooBig() throws Exception {
        int maxChunkSize = 8192;
        this.setupLargeChunks(8193, 81930);
    }

    @Test
    public void testBulkFill() throws Exception {
        this.setupSimple(5);
        this.tryFill(0, 15);
        this.tryFill(3, 6);
        this.tryFill(7, 7);
        this.tryFill(7, 9);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBulkFillTooMuch() throws Exception {
        this.setupSimple(5);
        this.tryFill(7, 10);
    }

    @Test
    public void testSanityWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseLongBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testBulkFillWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        this.tryFill(0, 15);
        this.tryFill(3, 6);
        this.tryFill(7, 7);
        this.tryFill(7, 9);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBulkFillTooMuchWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        this.tryFill(7, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentThreadReads() throws Exception {
        this.setupSimple(5);
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < CompressedLongsIndexedSupplierTest.this.indexed.size(); ++j) {
                            long indexedVal;
                            long val = CompressedLongsIndexedSupplierTest.this.vals[j];
                            if (Longs.compare((long)val, (long)(indexedVal = CompressedLongsIndexedSupplierTest.this.indexed.get(j))) == 0) continue;
                            failureHappened.set(true);
                            reason.set(String.format("Thread1[%d]: %d != %d", j, val, indexedVal));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final IndexedLongs indexed2 = this.supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = indexed2.size() - 1; j >= 0; --j) {
                                long indexedVal;
                                long val = CompressedLongsIndexedSupplierTest.this.vals[j];
                                if (Longs.compare((long)val, (long)(indexedVal = indexed2.get(j))) == 0) continue;
                                failureHappened.set(true);
                                reason.set(String.format("Thread2[%d]: %d != %d", j, val, indexedVal));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseQuietly.close((Closeable)indexed2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }

    private void tryFill(int startIndex, int size) {
        long[] filled = new long[size];
        this.indexed.fill(startIndex, filled);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((long)this.vals[i + startIndex], (long)filled[i]);
        }
    }

    private void assertIndexMatchesVals() {
        int i;
        Assert.assertEquals((long)this.vals.length, (long)this.indexed.size());
        int[] indices = new int[this.vals.length];
        for (i = 0; i < this.indexed.size(); ++i) {
            Assert.assertEquals((double)this.vals[i], (double)this.indexed.get(i), (double)0.0);
            indices[i] = i;
        }
        Collections.shuffle(Arrays.asList(new int[][]{indices}));
        for (i = 0; i < this.indexed.size(); ++i) {
            int k = indices[i];
            Assert.assertEquals((double)this.vals[k], (double)this.indexed.get(k), (double)0.0);
        }
    }
}

