/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.OutputSupplier;
import io.druid.segment.data.CompressedFloatBufferObjectStrategy;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.data.CompressedFloatsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionStrategyTest;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.IOPeonForTesting;
import io.druid.segment.data.IndexedFloats;
import io.druid.segment.data.ObjectStrategy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedFloatsSupplierSerializerTest
extends CompressionStrategyTest {
    public CompressedFloatsSupplierSerializerTest(CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        super(compressionStrategy);
    }

    @Test
    public void testSanity() throws Exception {
        ByteOrder order = ByteOrder.nativeOrder();
        int sizePer = 999;
        CompressedFloatsSupplierSerializer serializer = new CompressedFloatsSupplierSerializer(999, new GenericIndexedWriter((IOPeon)new IOPeonForTesting(), "test", (ObjectStrategy)CompressedFloatBufferObjectStrategy.getBufferForOrder((ByteOrder)order, (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy, (int)999)), this.compressionStrategy);
        serializer.open();
        int numElements = 10000;
        for (int i = 0; i < 10000; ++i) {
            serializer.add((float)i);
        }
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.closeAndConsolidate((OutputSupplier)new OutputSupplier<OutputStream>(){

            public OutputStream getOutput() throws IOException {
                return baos;
            }
        });
        IndexedFloats floats = CompressedFloatsIndexedSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(baos.toByteArray()), (ByteOrder)order).get();
        Assert.assertEquals((long)10000L, (long)floats.size());
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((float)i, (float)floats.get(i), (float)0.0f);
        }
        floats.close();
    }
}

