/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.Closeables;
import com.google.common.primitives.Floats;
import com.metamx.common.guava.CloseQuietly;
import io.druid.segment.data.CompressedFloatsIndexedSupplier;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionStrategyTest;
import io.druid.segment.data.IndexedFloats;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedFloatsIndexedSupplierTest
extends CompressionStrategyTest {
    private IndexedFloats indexed;
    private CompressedFloatsIndexedSupplier supplier;
    private float[] vals;

    public CompressedFloatsIndexedSupplierTest(CompressedObjectStrategy.CompressionStrategy compressionStrategy) {
        super(compressionStrategy);
    }

    @Before
    public void setUp() throws Exception {
        Closeables.close((Closeable)this.indexed, (boolean)false);
        this.indexed = null;
        this.supplier = null;
        this.vals = null;
    }

    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)this.indexed, (boolean)false);
    }

    private void setupSimple(int chunkSize) {
        CloseQuietly.close((Closeable)this.indexed);
        this.vals = new float[]{0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f};
        this.supplier = CompressedFloatsIndexedSupplier.fromFloatBuffer((FloatBuffer)FloatBuffer.wrap(this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy);
        this.indexed = this.supplier.get();
    }

    private void setupSimpleWithSerde(int chunkSize) throws IOException {
        this.vals = new float[]{0.0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f};
        this.makeWithSerde(chunkSize);
    }

    private void makeWithSerde(int chunkSize) throws IOException {
        CloseQuietly.close((Closeable)this.indexed);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompressedFloatsIndexedSupplier theSupplier = CompressedFloatsIndexedSupplier.fromFloatBuffer((FloatBuffer)FloatBuffer.wrap(this.vals), (int)chunkSize, (ByteOrder)ByteOrder.nativeOrder(), (CompressedObjectStrategy.CompressionStrategy)this.compressionStrategy);
        theSupplier.writeToChannel(Channels.newChannel(baos));
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)theSupplier.getSerializedSize(), (long)bytes.length);
        this.supplier = CompressedFloatsIndexedSupplier.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(bytes), (ByteOrder)ByteOrder.nativeOrder());
        this.indexed = this.supplier.get();
    }

    private void setupLargeChunks(int chunkSize, int totalSize) throws IOException {
        this.vals = new float[totalSize];
        Random rand = new Random(0L);
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = (float)rand.nextGaussian();
        }
        this.makeWithSerde(chunkSize);
    }

    @Test
    public void testSanity() throws Exception {
        this.setupSimple(5);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimple(2);
        Assert.assertEquals((long)9L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testLargeChunks() throws Exception {
        int maxChunkSize = 16384;
        this.setupLargeChunks(16384, 163840);
        Assert.assertEquals((long)10L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
        this.setupLargeChunks(16384, 163841);
        Assert.assertEquals((long)11L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
        this.setupLargeChunks(16383, 163831);
        Assert.assertEquals((long)11L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChunkTooBig() throws Exception {
        int maxChunkSize = 16384;
        this.setupLargeChunks(16385, 163850);
    }

    @Test
    public void testBulkFill() throws Exception {
        this.setupSimple(5);
        this.tryFill(0, 15);
        this.tryFill(3, 6);
        this.tryFill(7, 7);
        this.tryFill(7, 9);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBulkFillTooMuch() throws Exception {
        this.setupSimple(5);
        this.tryFill(7, 11);
    }

    @Test
    public void testSanityWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        Assert.assertEquals((long)4L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
        this.setupSimpleWithSerde(2);
        Assert.assertEquals((long)9L, (long)this.supplier.getBaseFloatBuffers().size());
        this.assertIndexMatchesVals();
    }

    @Test
    public void testBulkFillWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        this.tryFill(0, 15);
        this.tryFill(3, 6);
        this.tryFill(7, 7);
        this.tryFill(7, 9);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testBulkFillTooMuchWithSerde() throws Exception {
        this.setupSimpleWithSerde(5);
        this.tryFill(7, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentThreadReads() throws Exception {
        this.setupSimple(5);
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < CompressedFloatsIndexedSupplierTest.this.indexed.size(); ++j) {
                            float indexedVal;
                            float val = CompressedFloatsIndexedSupplierTest.this.vals[j];
                            if (Floats.compare((float)val, (float)(indexedVal = CompressedFloatsIndexedSupplierTest.this.indexed.get(j))) == 0) continue;
                            failureHappened.set(true);
                            reason.set(String.format("Thread1[%d]: %f != %f", j, Float.valueOf(val), Float.valueOf(indexedVal)));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        try (final IndexedFloats indexed2 = this.supplier.get();){
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = indexed2.size() - 1; j >= 0; --j) {
                                float indexedVal;
                                float val = CompressedFloatsIndexedSupplierTest.this.vals[j];
                                if (Floats.compare((float)val, (float)(indexedVal = indexed2.get(j))) == 0) continue;
                                failureHappened.set(true);
                                reason.set(String.format("Thread2[%d]: %f != %f", j, Float.valueOf(val), Float.valueOf(indexedVal)));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }

    private void tryFill(int startIndex, int size) {
        float[] filled = new float[size];
        this.indexed.fill(startIndex, filled);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((double)this.vals[i + startIndex], (double)filled[i], (double)0.0);
        }
    }

    private void assertIndexMatchesVals() {
        int i;
        Assert.assertEquals((long)this.vals.length, (long)this.indexed.size());
        int[] indices = new int[this.vals.length];
        for (i = 0; i < this.indexed.size(); ++i) {
            Assert.assertEquals((double)this.vals[i], (double)this.indexed.get(i), (double)0.0);
            indices[i] = i;
        }
        Collections.shuffle(Arrays.asList(new int[][]{indices}));
        for (i = 0; i < this.indexed.size(); ++i) {
            int k = indices[i];
            Assert.assertEquals((double)this.vals[k], (double)this.indexed.get(k), (double)0.0);
        }
    }
}

