/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.common.logger.Logger;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.data.RoaringBitmapSerdeFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Ignore
@RunWith(value=Parameterized.class)
public class BitmapCreationBenchmark
extends AbstractBenchmark {
    private static final Logger log = new Logger(BitmapCreationBenchmark.class);
    final BitmapFactory factory;
    final ObjectStrategy<ImmutableBitmap> objectStrategy;
    private static final int numBits = 100000;
    static Random random;
    static int[] randIndex;
    ImmutableBitmap baseImmutableBitmap;
    MutableBitmap baseMutableBitmap;
    byte[] baseBytes;
    ByteBuffer baseByteBuffer;

    @Parameterized.Parameters
    public static List<Class<? extends BitmapSerdeFactory>[]> factoryClasses() {
        return Arrays.asList((Class[])Arrays.asList(ConciseBitmapSerdeFactory.class).toArray(), (Class[])Arrays.asList(RoaringBitmapSerdeFactory.class).toArray());
    }

    public BitmapCreationBenchmark(Class<? extends BitmapSerdeFactory> clazz) throws IllegalAccessException, InstantiationException {
        BitmapSerdeFactory serdeFactory = clazz.newInstance();
        this.factory = serdeFactory.getBitmapFactory();
        this.objectStrategy = serdeFactory.getObjectStrategy();
    }

    @AfterClass
    public static void cleanupAfterClass() {
        List<Class<? extends BitmapSerdeFactory>[]> classes = BitmapCreationBenchmark.factoryClasses();
        for (int i = 0; i < classes.size(); ++i) {
            log.info("Entry [%d] is %s", new Object[]{i, classes.get(i)[0].getCanonicalName()});
        }
    }

    @BeforeClass
    public static void setupBeforeClass() {
        int i;
        for (i = 0; i < 100000; ++i) {
            BitmapCreationBenchmark.randIndex[i] = i;
        }
        random = new Random(78591378L);
        for (i = 0; i < 100000; ++i) {
            int idex = random.nextInt(randIndex.length);
            int swap = randIndex[i];
            BitmapCreationBenchmark.randIndex[i] = randIndex[idex];
            BitmapCreationBenchmark.randIndex[idex] = swap;
        }
    }

    @Before
    public void setup() {
        this.baseMutableBitmap = this.factory.makeEmptyMutableBitmap();
        for (int i = 0; i < 100000; ++i) {
            this.baseMutableBitmap.add(i);
        }
        this.baseImmutableBitmap = this.factory.makeImmutableBitmap(this.baseMutableBitmap);
        this.baseBytes = this.baseImmutableBitmap.toBytes();
        this.baseByteBuffer = ByteBuffer.wrap(this.baseBytes);
    }

    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    @Test
    public void testLinearAddition() {
        MutableBitmap mutableBitmap = this.factory.makeEmptyMutableBitmap();
        for (int i = 0; i < 100000; ++i) {
            mutableBitmap.add(i);
        }
        Assert.assertEquals((long)100000L, (long)mutableBitmap.size());
    }

    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=10)
    @Test
    public void testRandomAddition() {
        MutableBitmap mutableBitmap = this.factory.makeEmptyMutableBitmap();
        for (int i : randIndex) {
            mutableBitmap.add(i);
        }
        Assert.assertEquals((long)100000L, (long)mutableBitmap.size());
    }

    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    @Test
    public void testLinearAdditionDescending() {
        MutableBitmap mutableBitmap = this.factory.makeEmptyMutableBitmap();
        for (int i = 99999; i >= 0; --i) {
            mutableBitmap.add(i);
        }
        Assert.assertEquals((long)100000L, (long)mutableBitmap.size());
    }

    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    @Test
    public void testToImmutableByteArray() {
        ImmutableBitmap immutableBitmap = this.factory.makeImmutableBitmap(this.baseMutableBitmap);
        Assert.assertArrayEquals((byte[])this.baseBytes, (byte[])immutableBitmap.toBytes());
    }

    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    @Test
    public void testFromImmutableByteArray() {
        ImmutableBitmap immutableBitmap = this.factory.mapImmutableBitmap(this.baseByteBuffer);
        Assert.assertEquals((long)100000L, (long)immutableBitmap.size());
    }

    static {
        randIndex = new int[100000];
    }
}

