/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.hash.Hashing;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import com.metamx.common.logger.Logger;
import io.druid.data.input.impl.DelimitedParseSpec;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.granularity.QueryGranularity;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndex;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.OffheapIncrementalIndex;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class TestIndex {
    public static final String[] COLUMNS = new String[]{"ts", "market", "quality", "placement", "placementish", "index", "partial_null_column", "null_column", "quality_uniques"};
    public static final String[] DIMENSIONS = new String[]{"market", "quality", "placement", "placementish", "partial_null_column", "null_column"};
    public static final String[] METRICS = new String[]{"index"};
    private static final Logger log = new Logger(TestIndex.class);
    private static final Interval DATA_INTERVAL = new Interval((Object)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z");
    private static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory(METRICS[0], METRICS[0]), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final IndexSpec indexSpec = new IndexSpec();
    private static IncrementalIndex realtimeIndex;
    private static QueryableIndex mmappedIndex;
    private static QueryableIndex mergedRealtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalIndex getIncrementalTestIndex(boolean useOffheap) {
        Logger logger = log;
        synchronized (logger) {
            if (realtimeIndex != null) {
                return realtimeIndex;
            }
        }
        realtimeIndex = TestIndex.makeRealtimeIndex("druid.sample.tsv", useOffheap);
        return realtimeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryableIndex getMMappedTestIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mmappedIndex != null) {
                return mmappedIndex;
            }
        }
        IncrementalIndex incrementalIndex = TestIndex.getIncrementalTestIndex(false);
        mmappedIndex = TestIndex.persistRealtimeAndLoadMMapped(incrementalIndex);
        return mmappedIndex;
    }

    public static QueryableIndex mergedRealtimeIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mergedRealtime != null) {
                return mergedRealtime;
            }
            try {
                IncrementalIndex top = TestIndex.makeRealtimeIndex("druid.sample.tsv.top", false);
                IncrementalIndex bottom = TestIndex.makeRealtimeIndex("druid.sample.tsv.bottom", false);
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File topFile = new File(tmpFile, "top");
                File bottomFile = new File(tmpFile, "bottom");
                File mergedFile = new File(tmpFile, "merged");
                topFile.mkdirs();
                topFile.deleteOnExit();
                bottomFile.mkdirs();
                bottomFile.deleteOnExit();
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                IndexMerger.persist((IncrementalIndex)top, (Interval)DATA_INTERVAL, (File)topFile, (IndexSpec)indexSpec);
                IndexMerger.persist((IncrementalIndex)bottom, (Interval)DATA_INTERVAL, (File)bottomFile, (IndexSpec)indexSpec);
                mergedRealtime = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(IndexIO.loadIndex((File)topFile), IndexIO.loadIndex((File)bottomFile)), (AggregatorFactory[])METRIC_AGGS, (File)mergedFile, (IndexSpec)indexSpec));
                return mergedRealtime;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static IncrementalIndex makeRealtimeIndex(String resourceFilename, boolean useOffheap) {
        int lineCount;
        final URL resource = TestIndex.class.getClassLoader().getResource(resourceFilename);
        log.info("Realtime loading index file[%s]", new Object[]{resource});
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(new DateTime((Object)"2011-01-12T00:00:00.000Z").getMillis()).withQueryGranularity(QueryGranularity.NONE).withMetrics(METRIC_AGGS).build();
        Object retVal = useOffheap ? new OffheapIncrementalIndex(schema, TestQueryRunners.pool, true, 0x6400000) : new OnheapIncrementalIndex(schema, 10000);
        final AtomicLong startTime = new AtomicLong();
        try {
            lineCount = (Integer)CharStreams.readLines((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return resource.openStream();
                }
            }, (Charset)Charsets.UTF_8), (LineProcessor)new LineProcessor<Integer>((IncrementalIndex)retVal){
                StringInputRowParser parser = new StringInputRowParser((ParseSpec)new DelimitedParseSpec(new TimestampSpec("ts", "iso", null), new DimensionsSpec(Arrays.asList(DIMENSIONS), null, null), "\t", "\u0001", Arrays.asList(COLUMNS)));
                boolean runOnce = false;
                int lineCount = 0;
                final /* synthetic */ IncrementalIndex val$retVal;
                {
                    this.val$retVal = incrementalIndex;
                }

                public boolean processLine(String line) throws IOException {
                    if (!this.runOnce) {
                        startTime.set(System.currentTimeMillis());
                        this.runOnce = true;
                    }
                    this.val$retVal.add(this.parser.parse(line));
                    ++this.lineCount;
                    return true;
                }

                public Integer getResult() {
                    return this.lineCount;
                }
            });
        }
        catch (IOException e) {
            realtimeIndex = null;
            throw Throwables.propagate((Throwable)e);
        }
        log.info("Loaded %,d lines in %,d millis.", new Object[]{lineCount, System.currentTimeMillis() - startTime.get()});
        return retVal;
    }

    public static QueryableIndex persistRealtimeAndLoadMMapped(IncrementalIndex index) {
        try {
            File someTmpFile = File.createTempFile("billy", "yay");
            someTmpFile.delete();
            someTmpFile.mkdirs();
            someTmpFile.deleteOnExit();
            IndexMerger.persist((IncrementalIndex)index, (File)someTmpFile, (IndexSpec)indexSpec);
            return IndexIO.loadIndex((File)someTmpFile);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        if (ComplexMetrics.getSerdeForType((String)"hyperUnique") == null) {
            ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde(Hashing.murmur3_128()));
        }
        realtimeIndex = null;
        mmappedIndex = null;
        mergedRealtime = null;
    }
}

