/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.data.input.Row;
import io.druid.query.Result;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;

public class TestHelper {
    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Sequence<Result<T>> results) {
        TestHelper.assertResults(expectedResults, Sequences.toList(results, (List)Lists.newArrayList()), "");
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results) {
        TestHelper.assertResults(expectedResults, results, "");
    }

    public static <T> void assertExpectedResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> results, String failMsg) {
        TestHelper.assertResults(expectedResults, results, failMsg);
    }

    public static <T> void assertExpectedObjects(Iterable<T> expectedResults, Iterable<T> results, String failMsg) {
        TestHelper.assertObjects(expectedResults, results, failMsg);
    }

    public static <T> void assertExpectedObjects(Iterable<T> expectedResults, Sequence<T> results, String failMsg) {
        TestHelper.assertObjects(expectedResults, Sequences.toList(results, (List)Lists.newArrayList()), failMsg);
    }

    private static <T> void assertResults(Iterable<Result<T>> expectedResults, Iterable<Result<T>> actualResults, String failMsg) {
        Iterator<Result<T>> resultsIter = actualResults.iterator();
        Iterator<Result<T>> resultsIter2 = actualResults.iterator();
        Iterator<Result<T>> expectedResultsIter = expectedResults.iterator();
        while (resultsIter.hasNext() && resultsIter2.hasNext() && expectedResultsIter.hasNext()) {
            Result<T> expectedNext = expectedResultsIter.next();
            Result<T> next = resultsIter.next();
            Result<T> next2 = resultsIter2.next();
            if (expectedNext instanceof Row) {
                Assert.assertEquals((String)failMsg, expectedNext, next);
                Assert.assertEquals((String)failMsg, expectedNext, next2);
                continue;
            }
            TestHelper.assertResult(failMsg, expectedNext, next);
            TestHelper.assertResult(String.format("%s: Second iterator bad, multiple calls to iterator() should be safe", failMsg), expectedNext, next2);
        }
        if (resultsIter.hasNext()) {
            Assert.fail((String)String.format("%s: Expected resultsIter to be exhausted, next element was %s", failMsg, resultsIter.next()));
        }
        if (resultsIter2.hasNext()) {
            Assert.fail((String)String.format("%s: Expected resultsIter2 to be exhausted, next element was %s", failMsg, resultsIter.next()));
        }
        if (expectedResultsIter.hasNext()) {
            Assert.fail((String)String.format("%s: Expected expectedResultsIter to be exhausted, next element was %s", failMsg, expectedResultsIter.next()));
        }
    }

    private static <T> void assertObjects(Iterable<T> expectedResults, Iterable<T> actualResults, String failMsg) {
        Iterator<T> resultsIter = actualResults.iterator();
        Iterator<T> resultsIter2 = actualResults.iterator();
        Iterator<T> expectedResultsIter = expectedResults.iterator();
        while (resultsIter.hasNext() && resultsIter2.hasNext() && expectedResultsIter.hasNext()) {
            T expectedNext = expectedResultsIter.next();
            T next = resultsIter.next();
            T next2 = resultsIter2.next();
            Assert.assertEquals((String)failMsg, expectedNext, next);
            Assert.assertEquals((String)String.format("%s: Second iterator bad, multiple calls to iterator() should be safe", failMsg), expectedNext, next2);
        }
        if (resultsIter.hasNext()) {
            Assert.fail((String)String.format("%s: Expected resultsIter to be exhausted, next element was %s", failMsg, resultsIter.next()));
        }
        if (resultsIter2.hasNext()) {
            Assert.fail((String)String.format("%s: Expected resultsIter2 to be exhausted, next element was %s", failMsg, resultsIter.next()));
        }
        if (expectedResultsIter.hasNext()) {
            Assert.fail((String)String.format("%s: Expected expectedResultsIter to be exhausted, next element was %s", failMsg, expectedResultsIter.next()));
        }
    }

    private static void assertResult(String msg, Result<?> expected, Result actual) {
        Assert.assertEquals((String)msg, expected, (Object)actual);
    }
}

