/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.Pair;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import io.druid.query.aggregation.DoubleMinAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchHit;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.query.timeseries.TimeseriesQuery;
import io.druid.query.timeseries.TimeseriesResultValue;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.SchemalessIndex;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Test;

public class SchemalessTestFull {
    final double UNIQUES_2 = 2.000977198748901;
    final double UNIQUES_1 = 1.0002442201269182;
    final String dataSource = "testing";
    final QueryGranularity allGran = QueryGranularity.ALL;
    final String dimensionValue = "dimension";
    final String valueValue = "value";
    final String marketDimension = "market";
    final String qualityDimension = "quality";
    final String placementDimension = "placement";
    final String placementishDimension = "placementish";
    final String indexMetric = "index";
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final DoubleSumAggregatorFactory indexDoubleSum = new DoubleSumAggregatorFactory("index", "index");
    final HyperUniquesAggregatorFactory uniques = new HyperUniquesAggregatorFactory("uniques", "quality_uniques");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addRowsIndexConstant = new ArithmeticPostAggregator("addRowsIndexConstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> commonAggregators = Arrays.asList(this.rowsCount, this.indexDoubleSum, this.uniques);
    final QuerySegmentSpec fullOnInterval = new MultipleIntervalSegmentSpec(Arrays.asList(new Interval((Object)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z")));

    @Test
    public void testCompleteIntersectingSchemas() {
        List<Result<TimeseriesResultValue>> expectedTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-13T00:00:00.000Z")))));
        this.testAll(1, 5, expectedTimeSeriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testEmptyStrings() {
        List<Result<TimeseriesResultValue>> expectedTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit[0]))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit[0]))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.testAll(9, 10, expectedTimeSeriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testNonIntersectingSchemas() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)103.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), new HashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 1L);
                this.put("index", 0.0);
                this.put("addRowsIndexConstant", 2.0);
                this.put("uniques", 0.0);
                this.put("maxIndex", 0.0);
                this.put("minIndex", 0.0);
            }
        }))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.testAll(2, 3, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testPartialIntersectingSchemas() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("quality", "automotive"), new SearchHit("market", "total_market")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-13T00:00:00.000Z")))));
        this.testAll(2, 4, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testSupersetSchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TopNResultValue>> expectedTopNResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults;
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.testAll(1, 2, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testValueAndEmptySchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)2L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)103.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), new HashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 1L);
                this.put("index", 0.0);
                this.put("addRowsIndexConstant", 2.0);
                this.put("uniques", 0.0);
                this.put("maxIndex", 0.0);
                this.put("minIndex", 0.0);
            }
        }))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.testAll(0, 1, expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults);
    }

    @Test
    public void testEmptySchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)0.0).put((Object)"addRowsIndexConstant", (Object)2.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)0.0).put((Object)"minIndex", (Object)0.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)0L).put((Object)"index", (Object)0.0).put((Object)"addRowsIndexConstant", (Object)1.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)Double.NEGATIVE_INFINITY).put((Object)"minIndex", (Object)Double.POSITIVE_INFINITY).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new LinkedHashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 1L);
                this.put("index", 0.0);
                this.put("addRowsIndexConstant", 2.0);
                this.put("uniques", 0.0);
                this.put("maxIndex", 0.0);
                this.put("minIndex", 0.0);
            }
        }))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new SearchHit[0]))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit[0]))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(null, SchemalessIndex.getMergedIncrementalIndex(0, 0)), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MII[0, 0]");
    }

    @Test
    public void testExactSameSchemas() {
        List<Result<SearchResultValue>> expectedSearchResults;
        List<Result<TopNResultValue>> expectedTopNResults;
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults;
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)202.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)200.0).put((Object)"minIndex", (Object)200.0).build())));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)202.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)200.0).put((Object)"minIndex", (Object)200.0).build()))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(null, SchemalessIndex.getMergedIncrementalIndex(1, 1)), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MII[1, 1]");
    }

    @Test
    public void testMultiDimensionalValues() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)3L).put((Object)"index", (Object)300.0).put((Object)"addRowsIndexConstant", (Object)304.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new HashMap<String, Object>(){
            {
                this.put("market", null);
                this.put("rows", 2L);
                this.put("index", 200.0);
                this.put("addRowsIndexConstant", 203.0);
                this.put("uniques", 0.0);
                this.put("maxIndex", 100.0);
                this.put("minIndex", 100.0);
            }
        }, ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placement", "mezzanine")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit[0]))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(null, SchemalessIndex.getMergedIncrementalIndex(new int[]{6, 7, 8})), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MII[6, 7]");
    }

    @Test
    public void testDifferentMetrics() {
        List<Result<TimeseriesResultValue>> expectedTimeseriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)11L).put((Object)"index", (Object)900.0).put((Object)"addRowsIndexConstant", (Object)912.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        List<Result<TimeseriesResultValue>> expectedFilteredTimeSeriesResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())));
        List<Result<TopNResultValue>> expectedTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)3L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)204.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<TopNResultValue>> expectedFilteredTopNResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build(), ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)1L).put((Object)"index", (Object)100.0).put((Object)"addRowsIndexConstant", (Object)102.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()))));
        List<Result<SearchResultValue>> expectedSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        List<Result<SearchResultValue>> expectedFilteredSearchResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive")))));
        List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults = Arrays.asList(new Result(new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)new DateTime((Object)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)new DateTime((Object)"2011-01-13T00:00:00.000Z")))));
        this.runTests((Segment)new QueryableIndexSegment(null, SchemalessIndex.getMergedIncrementalIndexDiffMetrics()), expectedTimeseriesResults, expectedFilteredTimeSeriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, "Failed: MIIDM");
    }

    private List<Pair<QueryableIndex, String>> getIndexes(int index1, int index2) {
        return Arrays.asList(new Pair((Object)SchemalessIndex.getIncrementalIndex(index1, index2), (Object)String.format("Failed: II[%,d, %,d]", index1, index2)), new Pair((Object)SchemalessIndex.getIncrementalIndex(index2, index1), (Object)String.format("Failed: II[%,d, %,d]", index2, index1)), new Pair((Object)SchemalessIndex.getMergedIncrementalIndex(index1, index2), (Object)String.format("Failed: MII[%,d, %,d]", index1, index2)), new Pair((Object)SchemalessIndex.getMergedIncrementalIndex(index2, index1), (Object)String.format("Failed: MII[%,d, %,d]", index2, index1)));
    }

    private void testAll(int index1, int index2, List<Result<TimeseriesResultValue>> expectedTimeseriesResults, List<Result<TimeseriesResultValue>> expectedFilteredTimeseriesResults, List<Result<TopNResultValue>> expectedTopNResults, List<Result<TopNResultValue>> expectedFilteredTopNResults, List<Result<SearchResultValue>> expectedSearchResults, List<Result<SearchResultValue>> expectedFilteredSearchResults, List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults) {
        for (Pair<QueryableIndex, String> entry : this.getIndexes(index1, index2)) {
            this.runTests((Segment)new QueryableIndexSegment(null, (QueryableIndex)entry.lhs), expectedTimeseriesResults, expectedFilteredTimeseriesResults, expectedTopNResults, expectedFilteredTopNResults, expectedSearchResults, expectedFilteredSearchResults, expectedTimeBoundaryResults, (String)entry.rhs);
        }
    }

    private void runTests(Segment adapter, List<Result<TimeseriesResultValue>> expectedTimeseriesResults, List<Result<TimeseriesResultValue>> expectedFilteredTimeseriesResults, List<Result<TopNResultValue>> expectedTopNResults, List<Result<TopNResultValue>> expectedFilteredTopNResults, List<Result<SearchResultValue>> expectedSearchResults, List<Result<SearchResultValue>> expectedFilteredSearchResults, List<Result<TimeBoundaryResultValue>> expectedTimeBoundaryResults, String failMsg) {
        this.testFullOnTimeseries(TestQueryRunners.makeTimeSeriesQueryRunner(adapter), expectedTimeseriesResults, failMsg);
        this.testFilteredTimeseries(TestQueryRunners.makeTimeSeriesQueryRunner(adapter), expectedFilteredTimeseriesResults, failMsg);
        this.testFullOnTopN(TestQueryRunners.makeTopNQueryRunner(adapter), expectedTopNResults, failMsg);
        this.testFilteredTopN(TestQueryRunners.makeTopNQueryRunner(adapter), expectedFilteredTopNResults, failMsg);
        this.testFullOnSearch(TestQueryRunners.makeSearchQueryRunner(adapter), expectedSearchResults, failMsg);
        this.testFilteredSearch(TestQueryRunners.makeSearchQueryRunner(adapter), expectedFilteredSearchResults, failMsg);
        this.testTimeBoundary(TestQueryRunners.makeTimeBoundaryQueryRunner(adapter), expectedTimeBoundaryResults, failMsg);
    }

    private void testFullOnTimeseries(QueryRunner runner, List<Result<TimeseriesResultValue>> expectedResults, String failMsg) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
        failMsg = failMsg + " timeseries ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFilteredTimeseries(QueryRunner runner, List<Result<TimeseriesResultValue>> expectedResults, String failMsg) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).filters("market", "spot").aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
        failMsg = failMsg + " filtered timeseries ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFullOnTopN(QueryRunner runner, List<Result<TopNResultValue>> expectedResults, String failMsg) {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(this.allGran).dimension("market").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
        failMsg = failMsg + " topN ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFilteredTopN(QueryRunner runner, List<Result<TopNResultValue>> expectedResults, String failMsg) {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(this.allGran).dimension("market").filters("market", "spot").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new AggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
        failMsg = failMsg + " filtered topN ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFullOnSearch(QueryRunner runner, List<Result<SearchResultValue>> expectedResults, String failMsg) {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).query("a").build();
        failMsg = failMsg + " search ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testFilteredSearch(QueryRunner runner, List<Result<SearchResultValue>> expectedResults, String failMsg) {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.allGran).filters("market", "spot").intervals(this.fullOnInterval).query("a").build();
        failMsg = failMsg + " filtered search ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }

    private void testTimeBoundary(QueryRunner runner, List<Result<TimeBoundaryResultValue>> expectedResults, String failMsg) {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        failMsg = failMsg + " timeBoundary ";
        HashMap context = new HashMap();
        List actualResults = Sequences.toList((Sequence)runner.run((Query)query, context), (List)Lists.newArrayList());
        TestHelper.assertExpectedResults(expectedResults, actualResults, failMsg);
    }
}

