/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.hash.Hashing;
import com.metamx.common.Pair;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.granularity.QueryGranularity;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.DoubleSumAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.RowboatFilteringIndexAdapter;
import io.druid.segment.TestIndex;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.PartitionChunk;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SchemalessIndex {
    private static final Logger log = new Logger(SchemalessIndex.class);
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private static final String testFile = "druid.sample.json";
    private static final String TIMESTAMP = "timestamp";
    private static final List<String> METRICS = Arrays.asList("index");
    private static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final AggregatorFactory[] METRIC_AGGS_NO_UNIQ = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count")};
    private static final IndexSpec indexSpec = new IndexSpec();
    private static final List<Map<String, Object>> events = Lists.newArrayList();
    private static final Map<Integer, Map<Integer, QueryableIndex>> incrementalIndexes = Maps.newHashMap();
    private static final Map<Integer, Map<Integer, QueryableIndex>> mergedIndexes = Maps.newHashMap();
    private static final List<QueryableIndex> rowPersistedIndexes = Lists.newArrayList();
    private static IncrementalIndex index = null;
    private static QueryableIndex mergedIndex = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalIndex getIncrementalIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (index != null) {
                return index;
            }
            index = SchemalessIndex.makeIncrementalIndex(testFile, METRIC_AGGS);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryableIndex getIncrementalIndex(int index1, int index2) {
        Logger logger = log;
        synchronized (logger) {
            HashMap entry;
            if (events.isEmpty()) {
                SchemalessIndex.makeEvents();
            }
            if ((entry = incrementalIndexes.get(index1)) != null) {
                QueryableIndex index = (QueryableIndex)entry.get(index2);
                if (index != null) {
                    return index;
                }
            } else {
                entry = Maps.newHashMap();
                incrementalIndexes.put(index1, entry);
            }
            OnheapIncrementalIndex theIndex = null;
            int count = 0;
            for (Map<String, Object> event : events) {
                if (count != index1 && count != index2) {
                    ++count;
                    continue;
                }
                long timestamp = new DateTime(event.get(TIMESTAMP)).getMillis();
                if (theIndex == null) {
                    theIndex = new OnheapIncrementalIndex(timestamp, QueryGranularity.MINUTE, METRIC_AGGS, 1000);
                }
                ArrayList dims = Lists.newArrayList();
                for (Map.Entry<String, Object> val : event.entrySet()) {
                    if (val.getKey().equalsIgnoreCase(TIMESTAMP) || METRICS.contains(val.getKey())) continue;
                    dims.add(val.getKey());
                }
                try {
                    theIndex.add((InputRow)new MapBasedInputRow(timestamp, (List)dims, event));
                }
                catch (IndexSizeExceededException e) {
                    Throwables.propagate((Throwable)e);
                }
                ++count;
            }
            QueryableIndex retVal = TestIndex.persistRealtimeAndLoadMMapped(theIndex);
            entry.put(index2, retVal);
            return retVal;
        }
    }

    public static QueryableIndex getMergedIncrementalIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mergedIndex != null) {
                return mergedIndex;
            }
            try {
                IncrementalIndex top = SchemalessIndex.makeIncrementalIndex("druid.sample.json.top", METRIC_AGGS);
                IncrementalIndex bottom = SchemalessIndex.makeIncrementalIndex("druid.sample.json.bottom", METRIC_AGGS);
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File topFile = new File(tmpFile, "top");
                File bottomFile = new File(tmpFile, "bottom");
                File mergedFile = new File(tmpFile, "merged");
                topFile.mkdirs();
                topFile.deleteOnExit();
                bottomFile.mkdirs();
                bottomFile.deleteOnExit();
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                IndexMerger.persist((IncrementalIndex)top, (File)topFile, (IndexSpec)indexSpec);
                IndexMerger.persist((IncrementalIndex)bottom, (File)bottomFile, (IndexSpec)indexSpec);
                mergedIndex = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(IndexIO.loadIndex((File)topFile), IndexIO.loadIndex((File)bottomFile)), (AggregatorFactory[])METRIC_AGGS, (File)mergedFile, (IndexSpec)indexSpec));
                return mergedIndex;
            }
            catch (IOException e) {
                mergedIndex = null;
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static QueryableIndex getMergedIncrementalIndex(int index1, int index2) {
        Logger logger = log;
        synchronized (logger) {
            HashMap entry;
            if (rowPersistedIndexes.isEmpty()) {
                SchemalessIndex.makeRowPersistedIndexes();
            }
            if ((entry = mergedIndexes.get(index1)) != null) {
                QueryableIndex index = (QueryableIndex)entry.get(index2);
                if (index != null) {
                    return index;
                }
            } else {
                entry = Maps.newHashMap();
                mergedIndexes.put(index1, entry);
            }
            try {
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File mergedFile = new File(tmpFile, "merged");
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                QueryableIndex index = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex(Arrays.asList(rowPersistedIndexes.get(index1), rowPersistedIndexes.get(index2)), (AggregatorFactory[])METRIC_AGGS, (File)mergedFile, (IndexSpec)indexSpec));
                entry.put(index2, index);
                return index;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static QueryableIndex getMergedIncrementalIndex(int[] indexes) {
        Logger logger = log;
        synchronized (logger) {
            if (rowPersistedIndexes.isEmpty()) {
                SchemalessIndex.makeRowPersistedIndexes();
            }
            try {
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File mergedFile = new File(tmpFile, "merged");
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                ArrayList indexesToMerge = Lists.newArrayList();
                for (int i = 0; i < indexes.length; ++i) {
                    indexesToMerge.add(rowPersistedIndexes.get(indexes[i]));
                }
                QueryableIndex index = IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex((List)indexesToMerge, (AggregatorFactory[])METRIC_AGGS, (File)mergedFile, (IndexSpec)indexSpec));
                return index;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static QueryableIndex getAppendedIncrementalIndex(Iterable<Pair<String, AggregatorFactory[]>> files, List<Interval> intervals) {
        return SchemalessIndex.makeAppendedMMappedIndex(files, intervals);
    }

    public static QueryableIndex getMergedIncrementalIndexDiffMetrics() {
        return SchemalessIndex.getMergedIncrementalIndex(Arrays.asList(new Pair((Object)"druid.sample.json.top", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"druid.sample.json.bottom", (Object)METRIC_AGGS)));
    }

    public static QueryableIndex getMergedIncrementalIndex(Iterable<Pair<String, AggregatorFactory[]>> files) {
        return SchemalessIndex.makeMergedMMappedIndex(files);
    }

    private static void makeEvents() {
        URL resource = TestIndex.class.getClassLoader().getResource(testFile);
        String filename = resource.getFile();
        log.info("Realtime loading index file[%s]", new Object[]{filename});
        try {
            for (Object obj : (List)jsonMapper.readValue(new File(filename), List.class)) {
                Map event = (Map)jsonMapper.convertValue(obj, Map.class);
                events.add(event);
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeRowPersistedIndexes() {
        Logger logger = log;
        synchronized (logger) {
            try {
                if (events.isEmpty()) {
                    SchemalessIndex.makeEvents();
                }
                for (Map<String, Object> event : events) {
                    long timestamp = new DateTime(event.get(TIMESTAMP)).getMillis();
                    ArrayList dims = Lists.newArrayList();
                    for (Map.Entry<String, Object> entry : event.entrySet()) {
                        if (entry.getKey().equalsIgnoreCase(TIMESTAMP) || METRICS.contains(entry.getKey())) continue;
                        dims.add(entry.getKey());
                    }
                    OnheapIncrementalIndex rowIndex = new OnheapIncrementalIndex(timestamp, QueryGranularity.MINUTE, METRIC_AGGS, 1000);
                    rowIndex.add((InputRow)new MapBasedInputRow(timestamp, (List)dims, event));
                    File tmpFile = File.createTempFile("billy", "yay");
                    tmpFile.delete();
                    tmpFile.mkdirs();
                    tmpFile.deleteOnExit();
                    IndexMerger.persist((IncrementalIndex)rowIndex, (File)tmpFile, (IndexSpec)indexSpec);
                    rowPersistedIndexes.add(IndexIO.loadIndex((File)tmpFile));
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static IncrementalIndex makeIncrementalIndex(String resourceFilename, AggregatorFactory[] aggs) {
        URL resource = TestIndex.class.getClassLoader().getResource(resourceFilename);
        log.info("Realtime loading resource[%s]", new Object[]{resource});
        String filename = resource.getFile();
        log.info("Realtime loading index file[%s]", new Object[]{filename});
        OnheapIncrementalIndex retVal = new OnheapIncrementalIndex(new DateTime((Object)"2011-01-12T00:00:00.000Z").getMillis(), QueryGranularity.MINUTE, aggs, 1000);
        try {
            List events = (List)jsonMapper.readValue(new File(filename), List.class);
            for (Object obj : events) {
                Map event = (Map)jsonMapper.convertValue(obj, Map.class);
                ArrayList dims = Lists.newArrayList();
                for (Map.Entry entry : event.entrySet()) {
                    if (((String)entry.getKey()).equalsIgnoreCase(TIMESTAMP) || METRICS.contains(entry.getKey())) continue;
                    dims.add(entry.getKey());
                }
                retVal.add((InputRow)new MapBasedInputRow(new DateTime(event.get(TIMESTAMP)).getMillis(), (List)dims, event));
            }
        }
        catch (IOException e) {
            index = null;
            throw Throwables.propagate((Throwable)e);
        }
        return retVal;
    }

    private static List<File> makeFilesToMap(File tmpFile, Iterable<Pair<String, AggregatorFactory[]>> files) throws IOException {
        ArrayList filesToMap = Lists.newArrayList();
        for (Pair<String, AggregatorFactory[]> file : files) {
            IncrementalIndex index = SchemalessIndex.makeIncrementalIndex((String)file.lhs, (AggregatorFactory[])file.rhs);
            File theFile = new File(tmpFile, (String)file.lhs);
            theFile.mkdirs();
            theFile.deleteOnExit();
            filesToMap.add(theFile);
            IndexMerger.persist((IncrementalIndex)index, (File)theFile, (IndexSpec)indexSpec);
        }
        return filesToMap;
    }

    private static QueryableIndex makeAppendedMMappedIndex(Iterable<Pair<String, AggregatorFactory[]>> files, List<Interval> intervals) {
        try {
            File tmpFile = File.createTempFile("yay", "boo");
            tmpFile.delete();
            File mergedFile = new File(tmpFile, "merged");
            mergedFile.mkdirs();
            mergedFile.deleteOnExit();
            List<File> filesToMap = SchemalessIndex.makeFilesToMap(tmpFile, files);
            VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural().nullsFirst());
            NoneShardSpec noneShardSpec = new NoneShardSpec();
            for (int i = 0; i < intervals.size(); ++i) {
                timeline.add(intervals.get(i), (Object)i, noneShardSpec.createChunk((Object)filesToMap.get(i)));
            }
            ArrayList adapters = Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)timeline.lookup(new Interval((Object)"1000-01-01/3000-01-01")), (Function)new Function<TimelineObjectHolder<Integer, File>, Iterable<IndexableAdapter>>(){

                public Iterable<IndexableAdapter> apply(final TimelineObjectHolder<Integer, File> timelineObjectHolder) {
                    return Iterables.transform((Iterable)timelineObjectHolder.getObject(), (Function)new Function<PartitionChunk<File>, IndexableAdapter>(){

                        public IndexableAdapter apply(PartitionChunk<File> chunk) {
                            try {
                                return new RowboatFilteringIndexAdapter((IndexableAdapter)new QueryableIndexIndexableAdapter(IndexIO.loadIndex((File)((File)chunk.getObject()))), (Predicate)new Predicate<Rowboat>(){

                                    public boolean apply(Rowboat input) {
                                        return timelineObjectHolder.getInterval().contains(input.getTimestamp());
                                    }
                                });
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                }
            })));
            return IndexIO.loadIndex((File)IndexMerger.append((List)adapters, (File)mergedFile, (IndexSpec)indexSpec));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static QueryableIndex makeMergedMMappedIndex(Iterable<Pair<String, AggregatorFactory[]>> files) {
        try {
            File tmpFile = File.createTempFile("yay", "who");
            tmpFile.delete();
            File mergedFile = new File(tmpFile, "merged");
            mergedFile.mkdirs();
            mergedFile.deleteOnExit();
            List<File> filesToMap = SchemalessIndex.makeFilesToMap(tmpFile, files);
            return IndexIO.loadIndex((File)IndexMerger.mergeQueryableIndex((List)Lists.newArrayList((Iterable)Iterables.transform(filesToMap, (Function)new Function<File, QueryableIndex>(){

                public QueryableIndex apply(@Nullable File input) {
                    try {
                        return IndexIO.loadIndex((File)input);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            })), (AggregatorFactory[])METRIC_AGGS, (File)mergedFile, (IndexSpec)indexSpec));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        if (ComplexMetrics.getSerdeForType((String)"hyperUnique") == null) {
            ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde(Hashing.murmur3_128()));
        }
    }
}

